/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.tuple;

import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.CloneableObject;

public class Tuple
extends CloneableDataObject {
    private Object key;
    private Object value;

    public Tuple() {
    }

    public Tuple(Object key, Object value) {
        this.key = key;
        this.value = value;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Tuple && Utils.equalsNullSafe(this.key, ((Tuple)other).key) && Utils.equalsNullSafe(this.value, ((Tuple)other).value);
    }

    public boolean equalsByKey(Object key) {
        return Utils.equalsNullSafe(this.key, key);
    }

    public boolean equalsByValue(Object value) {
        return Utils.equalsNullSafe(this.value, value);
    }

    @Override
    public Tuple clone() {
        Tuple result = (Tuple)super.clone();
        if (this.key instanceof CloneableObject) {
            result.key = ((CloneableObject)this.key).clone();
        }
        if (this.value instanceof CloneableObject) {
            result.value = ((CloneableObject)this.value).clone();
        }
        return result;
    }

    public String toString() {
        return "<" + String.valueOf(this.key) + ", " + String.valueOf(this.value) + ">";
    }
}

