/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.tuple;

import com.streamscape.sdo.CloneableObject;
import com.streamscape.sdo.tuple.Triple;
import com.streamscape.sdo.tuple.Tuple;
import com.streamscape.sdo.tuple.TupleSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TripleSet
extends ArrayList<Triple>
implements CloneableObject {
    public TripleSet() {
    }

    public TripleSet(TripleSet other) {
        super(other);
    }

    public Set<Object> getSubjects() {
        return this.getPart(Triple::getSubject);
    }

    public Set<Object> getPredicates() {
        return this.getPart(Triple::getPredicate);
    }

    public Set<Object> getObjects() {
        return this.getPart(Triple::getObject);
    }

    private Set<Object> getPart(Function<Triple, Object> getter) {
        return this.stream().map(getter).collect(Collectors.toSet());
    }

    public Map<Object, TripleSet> toSubjectMap() {
        return this.toMap(Triple::getSubject);
    }

    public Map<Object, TripleSet> toPredicateMap() {
        return this.toMap(Triple::getPredicate);
    }

    public Map<Object, TripleSet> toObjectMap() {
        return this.toMap(Triple::getObject);
    }

    private Map<Object, TripleSet> toMap(Function<Triple, Object> key) {
        HashMap<Object, TripleSet> result = new HashMap<Object, TripleSet>();
        this.forEach((? super E triple) -> result.computeIfAbsent(key.apply((Triple)triple), k -> new TripleSet()).add(triple));
        return result;
    }

    public Map<Object, TupleSet> toSubjectTupleSet() {
        return this.toTupleSet(Triple::getSubject, Triple::getPredicate, Triple::getObject);
    }

    public Map<Object, TupleSet> toPredicateTupleSet() {
        return this.toTupleSet(Triple::getPredicate, Triple::getSubject, Triple::getObject);
    }

    public Map<Object, TupleSet> toObjectTupleSet() {
        return this.toTupleSet(Triple::getObject, Triple::getSubject, Triple::getPredicate);
    }

    private Map<Object, TupleSet> toTupleSet(Function<Triple, Object> key, Function<Triple, Object> tupleKey, Function<Triple, Object> tupleValue) {
        HashMap<Object, TupleSet> result = new HashMap<Object, TupleSet>();
        this.forEach((? super E triple) -> result.computeIfAbsent(key.apply((Triple)triple), k -> new TupleSet()).add(new Tuple(tupleKey.apply((Triple)triple), tupleValue.apply((Triple)triple))));
        return result;
    }

    public TripleSet getSubject(String subject) {
        return this.getSubjectTriples(subject);
    }

    public TripleSet getSubjectTriples(String subject) {
        return this.toSubjectMap().get(subject);
    }

    public TupleSet getSubjectTuples(String subject) {
        return this.toSubjectTupleSet().get(subject);
    }

    public TripleSet getObject(String object) {
        return this.getObjectTriples(object);
    }

    public TripleSet getObjectTriples(String object) {
        return this.toObjectMap().get(object);
    }

    public TupleSet getObjectTuples(String object) {
        return this.toObjectTupleSet().get(object);
    }

    public TripleSet getPredicate(String predicate) {
        return this.getPredicateTriples(predicate);
    }

    public TripleSet getPredicateTriples(String predicate) {
        return this.toPredicateMap().get(predicate);
    }

    public TupleSet getPredicateTuples(String predicate) {
        return this.toPredicateTupleSet().get(predicate);
    }

    public Map<Object, Map<Object, Object>> toSubjectGraph() {
        return this.toGraph(Triple::getSubject, Triple::getPredicate, Triple::getObject);
    }

    public Map<Object, Map<Object, Object>> toPredicateGraph() {
        return this.toGraph(Triple::getPredicate, Triple::getSubject, Triple::getObject);
    }

    public Map<Object, Map<Object, Object>> toObjectGraph() {
        return this.toGraph(Triple::getObject, Triple::getSubject, Triple::getPredicate);
    }

    private Map<Object, Map<Object, Object>> toGraph(Function<Triple, Object> key, Function<Triple, Object> key1, Function<Triple, Object> value1) {
        HashMap<Object, Map<Object, Object>> result = new HashMap<Object, Map<Object, Object>>();
        this.forEach((? super E triple) -> result.computeIfAbsent(key.apply((Triple)triple), k -> new HashMap()).put(key1.apply((Triple)triple), value1.apply((Triple)triple)));
        return result;
    }

    public boolean equalsBySubjects(TripleSet other) {
        return this.equalsByPart(other, Triple::getSubject);
    }

    public boolean equalsByPredicates(TripleSet other) {
        return this.equalsByPart(other, Triple::getPredicate);
    }

    public boolean equalsByObjects(TripleSet other) {
        return this.equalsByPart(other, Triple::getObject);
    }

    private boolean equalsByPart(TripleSet other, Function<Triple, Object> getter) {
        if (this.size() == other.size()) {
            Iterator iter1 = this.iterator();
            Iterator iter2 = other.iterator();
            while (iter1.hasNext()) {
                if (getter.apply((Triple)iter1.next()).equals(getter.apply((Triple)iter2.next()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public TripleSet diff(TripleSet other) {
        LinkedList<Triple> otherCopy = new LinkedList<Triple>(other);
        TripleSet result = this.stream().filter(triple -> !otherCopy.remove(triple)).collect(Collectors.toCollection(TripleSet::new));
        result.addAll(otherCopy);
        return result;
    }

    public TripleSet diffBySubjects(TripleSet other) {
        return this.diffByPart(other, TripleSet::toSubjectMap);
    }

    public TripleSet diffByPredicates(TripleSet other) {
        return this.diffByPart(other, TripleSet::toPredicateMap);
    }

    public TripleSet diffByObjects(TripleSet other) {
        return this.diffByPart(other, TripleSet::toObjectMap);
    }

    private TripleSet diffByPart(TripleSet other, Function<TripleSet, Map<Object, TripleSet>> mapGetter) {
        Map<Object, TripleSet> map = mapGetter.apply(this);
        Map<Object, TripleSet> otherMap = mapGetter.apply(other);
        TripleSet result = map.entrySet().stream().filter(entry -> otherMap.remove(entry.getKey()) == null).flatMap(entry -> ((TripleSet)entry.getValue()).stream()).collect(Collectors.toCollection(TripleSet::new));
        otherMap.values().forEach(result::addAll);
        return result;
    }

    @Override
    public TripleSet clone() {
        TripleSet result = new TripleSet();
        this.forEach((? super E triple) -> result.add(triple.clone()));
        return result;
    }
}

