/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sys;

import com.streamscape.Trace;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.SystemDataObject;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

public class SysId
extends CloneableDataObject
implements SystemDataObject {
    private String os = System.getProperty("os.name");
    private String ver = System.getProperty("os.version");
    private String creator = null;
    private String lastModified = null;
    private String id = UUID.randomUUID().toString();
    private long timeStamp = System.currentTimeMillis();
    private long pid = 0L;

    public SysId(String creator) {
        this.creator = creator;
        try {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            this.pid = Long.valueOf(jvmName.substring(0, jvmName.indexOf(64)));
        }
        catch (Exception exception) {
            Trace.logError(this, "Obtaining JVM process id failed.");
        }
        this.setLastModified(this.timeStamp);
    }

    public String getOSName() {
        return this.os;
    }

    public String getOSVersion() {
        return this.ver;
    }

    public long getPid() {
        return this.pid;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = SysId.getDateTime(lastModified);
    }

    private static String getDateTime(long time) {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(time);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Date getTimestamp() {
        return new Date(this.timeStamp);
    }

    @Override
    public void touch() {
        this.timeStamp = System.currentTimeMillis();
    }
}

