/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.validation;

import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.validation.AParameterValidator;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class TinyintValidator
extends AParameterValidator {
    public TinyintValidator(SQLTypeToken type) {
        super(type);
    }

    @Override
    public void validateDefaultValue(SQLQueryParameter parameter, String defValue) throws SQLQueryValidationException {
        if (this.isDefaultValueIsNull(defValue)) {
            return;
        }
        short val = 0;
        try {
            val = Short.parseShort(defValue);
        }
        catch (Exception exception) {
            this.throwValidationException(5057, parameter, "Invalid default value (" + defValue + ").");
        }
        if (val < -255 || val > 255) {
            this.throwValidationException(5057, parameter, "Value out of range (" + defValue + ").");
        }
    }

    @Override
    public void validateValue(SQLQueryParameter parameter, String value) throws SQLQueryValidationException {
        this.checkNullValue(parameter, value);
        if (this.isValueIsNull(value)) {
            return;
        }
        short val = 0;
        try {
            val = Short.parseShort(value);
        }
        catch (Exception exception) {
            this.throwValidationException(5057, parameter, "Invalid value (" + value + ").");
        }
        if (val < -255 || val > 255) {
            this.throwValidationException(5057, parameter, "Value out of range (" + value + ").");
        }
    }

    @Override
    public String convertValue(SQLQueryParameter parameter, Object value) throws SQLQueryValidationException {
        if (value == null) {
            return null;
        }
        try {
            return "" + Short.parseShort(value.toString());
        }
        catch (Exception exception) {
            this.throwValidationException(5057, parameter, "Invalid value (" + value.toString() + ").");
            return null;
        }
    }

    @Override
    protected String generateDefaultValueImpl(SQLQueryParameter parameter) {
        parameter.setDefaultValueWithoutValidation("0");
        return "0";
    }

    @Override
    protected void setValue(SQLQueryParameter parameter, PreparedStatement statement, String value) throws SQLException {
        statement.setShort(parameter.getOrdinal(), Short.parseShort(value));
    }
}

