/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.validation;

import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.validation.AParameterValidator;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

class TimestampValidator
extends AParameterValidator {
    public static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public TimestampValidator(SQLTypeToken type) {
        super(type);
    }

    @Override
    public void validateValue(SQLQueryParameter parameter, String value) throws SQLQueryValidationException {
        this.checkNullValue(parameter, value);
        if (this.isValueIsNull(value)) {
            return;
        }
        try {
            Timestamp.valueOf(value);
        }
        catch (Exception exception) {
            this.throwValidationException(5054, parameter, "Invalid value (" + value + "). Does not comply with JDBC timestamp escape format.");
        }
    }

    @Override
    public void validateDefaultValue(SQLQueryParameter parameter, String defValue) throws SQLQueryValidationException {
        if (this.isDefaultValueIsNull(defValue)) {
            return;
        }
        try {
            Timestamp.valueOf(defValue);
        }
        catch (Exception exception) {
            this.throwValidationException(5053, parameter, "Invalid default value (" + defValue + "). Does not comply with JDBC timestamp escape format.");
        }
    }

    @Override
    public String convertValue(SQLQueryParameter parameter, Object value) throws SQLQueryValidationException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Timestamp) {
            Timestamp time = (Timestamp)value;
            return time.toString();
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return FORMAT.format(date);
        }
        this.throwValidationException(5054, parameter, "Invalid value (" + value.toString() + ").");
        return null;
    }

    @Override
    public String escapeValue(SQLQueryParameter parameter) {
        if (this.isValueIsNull(parameter)) {
            return parameter.getValue();
        }
        return "'" + parameter.getValue() + "'";
    }

    @Override
    protected String generateDefaultValueImpl(SQLQueryParameter parameter) {
        String v = new Timestamp(System.currentTimeMillis()).toString();
        parameter.setDefaultValueWithoutValidation(v);
        return "'" + v + "'";
    }

    @Override
    protected void setValue(SQLQueryParameter parameter, PreparedStatement statement, String value) throws SQLException {
        statement.setTimestamp(parameter.getOrdinal(), Timestamp.valueOf(value));
    }
}

