/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.validation;

import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.validation.AParameterValidator;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class RealValidator
extends AParameterValidator {
    public RealValidator(SQLTypeToken type) {
        super(type);
    }

    @Override
    public void validateDefaultValue(SQLQueryParameter parameter, String defValue) throws SQLQueryValidationException {
        if (this.isDefaultValueIsNull(defValue)) {
            return;
        }
        try {
            Float.parseFloat(defValue);
        }
        catch (Exception exception) {
            this.throwValidationException(5060, parameter, "Invalid default value (" + defValue + ").");
        }
    }

    @Override
    public void validateValue(SQLQueryParameter parameter, String value) throws SQLQueryValidationException {
        this.checkNullValue(parameter, value);
        if (this.isValueIsNull(value)) {
            return;
        }
        try {
            Float.parseFloat(value);
        }
        catch (Exception exception) {
            this.throwValidationException(5060, parameter, "Invalid value (" + value + ").");
        }
    }

    @Override
    public String convertValue(SQLQueryParameter parameter, Object value) throws SQLQueryValidationException {
        if (value == null) {
            return null;
        }
        try {
            return Float.toString(Float.parseFloat(value.toString()));
        }
        catch (Exception exception) {
            this.throwValidationException(5060, parameter, "Invalid value (" + value.toString() + ").");
            return null;
        }
    }

    @Override
    protected String generateDefaultValueImpl(SQLQueryParameter parameter) {
        parameter.setDefaultValueWithoutValidation("0");
        return "0";
    }

    @Override
    protected void setValue(SQLQueryParameter parameter, PreparedStatement statement, String value) throws SQLException {
        statement.setFloat(parameter.getOrdinal(), Float.parseFloat(value));
    }
}

