/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.validation;

import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.validation.ArrayValidator;
import com.streamscape.sdo.sql.validation.BigintValidator;
import com.streamscape.sdo.sql.validation.BinaryValidator;
import com.streamscape.sdo.sql.validation.BooleanValidator;
import com.streamscape.sdo.sql.validation.CharValidator;
import com.streamscape.sdo.sql.validation.DateValidator;
import com.streamscape.sdo.sql.validation.DecimalValidator;
import com.streamscape.sdo.sql.validation.DoubleValidator;
import com.streamscape.sdo.sql.validation.FloatValidator;
import com.streamscape.sdo.sql.validation.IParameterValidator;
import com.streamscape.sdo.sql.validation.IntegerValidator;
import com.streamscape.sdo.sql.validation.LongvarbinaryValidator;
import com.streamscape.sdo.sql.validation.LongvarcharValidator;
import com.streamscape.sdo.sql.validation.NumericValidator;
import com.streamscape.sdo.sql.validation.ParameterValidatorStub;
import com.streamscape.sdo.sql.validation.RealValidator;
import com.streamscape.sdo.sql.validation.SmallintValidator;
import com.streamscape.sdo.sql.validation.TimeValidator;
import com.streamscape.sdo.sql.validation.TimestampValidator;
import com.streamscape.sdo.sql.validation.TinyintValidator;
import com.streamscape.sdo.sql.validation.VarbinaryValidator;
import com.streamscape.sdo.sql.validation.VarcharIgnorecaseValidator;
import com.streamscape.sdo.sql.validation.VarcharValidator;
import java.util.HashMap;
import java.util.Map;

public class ParameterValidatorPool {
    private static ParameterValidatorPool shared = null;
    private static ParameterValidatorStub stub = new ParameterValidatorStub();
    private static Map<SQLTypeToken, IParameterValidator> map = new HashMap<SQLTypeToken, IParameterValidator>();

    public static ParameterValidatorPool getInstance() {
        if (shared == null) {
            shared = new ParameterValidatorPool();
        }
        return shared;
    }

    public IParameterValidator getValidator(int type) {
        SQLTypeToken typeObj = SQLTypeToken.getTypeById(type);
        return this.getValidator(typeObj);
    }

    public IParameterValidator getValidator(SQLTypeToken type) {
        IParameterValidator validator = map.get((Object)type);
        return validator != null ? validator : stub;
    }

    static {
        map.put(SQLTypeToken.VARCHAR, new VarcharValidator(SQLTypeToken.VARCHAR));
        map.put(SQLTypeToken.INTEGER, new IntegerValidator(SQLTypeToken.INTEGER));
        map.put(SQLTypeToken.DOUBLE, new DoubleValidator(SQLTypeToken.DOUBLE));
        map.put(SQLTypeToken.VARCHAR_IGNORECASE, new VarcharIgnorecaseValidator(SQLTypeToken.VARCHAR_IGNORECASE));
        map.put(SQLTypeToken.CHAR, new CharValidator(SQLTypeToken.CHAR));
        map.put(SQLTypeToken.LONGVARCHAR, new LongvarcharValidator(SQLTypeToken.LONGVARCHAR));
        map.put(SQLTypeToken.DATE, new DateValidator(SQLTypeToken.DATE));
        map.put(SQLTypeToken.TIME, new TimeValidator(SQLTypeToken.TIME));
        map.put(SQLTypeToken.DECIMAL, new DecimalValidator(SQLTypeToken.DECIMAL));
        map.put(SQLTypeToken.BOOLEAN, new BooleanValidator(SQLTypeToken.BOOLEAN));
        map.put(SQLTypeToken.TINYINT, new TinyintValidator(SQLTypeToken.TINYINT));
        map.put(SQLTypeToken.SMALLINT, new SmallintValidator(SQLTypeToken.SMALLINT));
        map.put(SQLTypeToken.BIGINT, new BigintValidator(SQLTypeToken.BIGINT));
        map.put(SQLTypeToken.REAL, new RealValidator(SQLTypeToken.REAL));
        map.put(SQLTypeToken.FLOAT, new FloatValidator(SQLTypeToken.FLOAT));
        map.put(SQLTypeToken.NUMERIC, new NumericValidator(SQLTypeToken.NUMERIC));
        map.put(SQLTypeToken.TIMESTAMP, new TimestampValidator(SQLTypeToken.TIMESTAMP));
        map.put(SQLTypeToken.BINARY, new BinaryValidator(SQLTypeToken.BINARY));
        map.put(SQLTypeToken.VARBINARY, new VarbinaryValidator(SQLTypeToken.VARBINARY));
        map.put(SQLTypeToken.LONGVARBINARY, new LongvarbinaryValidator(SQLTypeToken.LONGVARBINARY));
        map.put(SQLTypeToken.CLOB, new LongvarcharValidator(SQLTypeToken.CLOB));
        map.put(SQLTypeToken.BLOB, new LongvarbinaryValidator(SQLTypeToken.BLOB));
        map.put(SQLTypeToken.ARRAY, new ArrayValidator(SQLTypeToken.ARRAY));
    }
}

