/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.validation;

import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.validation.AParameterValidator;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class DecimalValidator
extends AParameterValidator {
    public DecimalValidator(SQLTypeToken type) {
        super(type);
    }

    @Override
    public void validateDefaultValue(SQLQueryParameter parameter, String defValue) throws SQLQueryValidationException {
        if (this.isDefaultValueIsNull(defValue)) {
            return;
        }
        BigDecimal val = null;
        try {
            val = new BigDecimal(defValue);
        }
        catch (Exception exception) {
            this.throwValidationException(5055, parameter, "Invalid parameter default value (" + defValue + ").");
        }
        if (parameter.getPrecision() > 0 && val.precision() > parameter.getPrecision()) {
            this.throwValidationException(5055, parameter, "Default precision exceeds limit (" + parameter.getPrecision() + ") : " + defValue + ".");
        }
        if (parameter.getScale() > 0 && val.scale() > parameter.getScale()) {
            this.throwValidationException(5055, parameter, "Default scale exceeds limit (" + parameter.getScale() + ") : " + defValue + ".");
        }
    }

    @Override
    public void validateValue(SQLQueryParameter parameter, String value) throws SQLQueryValidationException {
        this.checkNullValue(parameter, value);
        if (this.isValueIsNull(value)) {
            return;
        }
        BigDecimal val = null;
        try {
            val = new BigDecimal(value);
        }
        catch (Exception exception) {
            this.throwValidationException(5055, parameter, "Invalid parameter value (" + value + ").");
        }
        if (parameter.getPrecision() > 0 && val.precision() > parameter.getPrecision()) {
            this.throwValidationException(5055, parameter, "Precision exceeds limit (" + parameter.getPrecision() + ") : " + value + ".");
        }
        if (parameter.getScale() > 0 && val.scale() > parameter.getScale()) {
            this.throwValidationException(5055, parameter, "Scale exceeds limit (" + parameter.getScale() + ") : " + value + ".");
        }
    }

    @Override
    public String convertValue(SQLQueryParameter parameter, Object value) throws SQLQueryValidationException {
        if (value == null) {
            return null;
        }
        try {
            return new BigDecimal(value.toString()).toString();
        }
        catch (Exception exception) {
            this.throwValidationException(5055, parameter, "Invalid parameter value (" + value.toString() + ").");
            return null;
        }
    }

    @Override
    protected String generateDefaultValueImpl(SQLQueryParameter parameter) {
        parameter.setDefaultValueWithoutValidation("0");
        return "0";
    }

    @Override
    protected void setValue(SQLQueryParameter parameter, PreparedStatement statement, String value) throws SQLException {
        statement.setBigDecimal(parameter.getOrdinal(), new BigDecimal(value));
    }
}

