/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.validation;

import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.validation.AParameterValidator;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

class DateValidator
extends AParameterValidator {
    public static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public DateValidator(SQLTypeToken type) {
        super(type);
    }

    @Override
    public void validateDefaultValue(SQLQueryParameter parameter, String defValue) throws SQLQueryValidationException {
        if (this.isDefaultValueIsNull(defValue)) {
            return;
        }
        try {
            java.sql.Date.valueOf(this.unescape(defValue));
        }
        catch (Exception exception) {
            this.throwValidationException(5052, parameter, "Invalid parameter default value (" + defValue + "). Does not comply with JDBC date escape format.");
        }
    }

    @Override
    public void validateValue(SQLQueryParameter parameter, String value) throws SQLQueryValidationException {
        this.checkNullValue(parameter, value);
        if (this.isValueIsNull(value)) {
            return;
        }
        try {
            java.sql.Date.valueOf(value);
        }
        catch (Exception exception) {
            this.throwValidationException(5052, parameter, "Invalid parameter value (" + value + "). Does not comply with JDBC date escape format.");
        }
    }

    @Override
    public String convertValue(SQLQueryParameter parameter, Object value) throws SQLQueryValidationException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof java.sql.Date) {
            java.sql.Date date = (java.sql.Date)value;
            return date.toString();
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return FORMAT.format(date);
        }
        this.throwValidationException(5052, parameter, "Invalid parameter value (" + value.toString() + ").");
        return null;
    }

    @Override
    public String escapeValue(SQLQueryParameter parameter) {
        if (this.isValueIsNull(parameter)) {
            return parameter.getValue();
        }
        return "'" + parameter.getValue() + "'";
    }

    @Override
    protected String generateDefaultValueImpl(SQLQueryParameter parameter) {
        parameter.setDefaultValueWithoutValidation("1970-01-01");
        return "'1970-01-01'";
    }

    @Override
    protected void setValue(SQLQueryParameter parameter, PreparedStatement statement, String value) throws SQLException {
        statement.setDate(parameter.getOrdinal(), java.sql.Date.valueOf(value));
    }
}

