/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.validation;

import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.validation.AParameterValidator;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class BigintValidator
extends AParameterValidator {
    public BigintValidator(SQLTypeToken type) {
        super(type);
    }

    @Override
    public void validateDefaultValue(SQLQueryParameter parameter, String defValue) throws SQLQueryValidationException {
        if (this.isDefaultValueIsNull(defValue)) {
            return;
        }
        try {
            Long.parseLong(defValue);
        }
        catch (Exception e) {
            this.throwValidationException(5059, parameter, "Invalid default value (" + defValue + ").");
        }
    }

    @Override
    public void validateValue(SQLQueryParameter parameter, String value) throws SQLQueryValidationException {
        this.checkNullValue(parameter, value);
        if (this.isValueIsNull(value)) {
            return;
        }
        try {
            Long.parseLong(value);
        }
        catch (Exception exception) {
            this.throwValidationException(5059, parameter, "Invalid value (" + value + ").");
        }
    }

    @Override
    public String convertValue(SQLQueryParameter parameter, Object value) throws SQLQueryValidationException {
        if (value == null) {
            return null;
        }
        try {
            return Long.toString(Long.parseLong(value.toString()));
        }
        catch (Exception exception) {
            this.throwValidationException(5059, parameter, "Invalid value (" + value.toString() + ").");
            return null;
        }
    }

    @Override
    protected String generateDefaultValueImpl(SQLQueryParameter parameter) {
        parameter.setDefaultValueWithoutValidation("0");
        return "0";
    }

    @Override
    protected void setValue(SQLQueryParameter parameter, PreparedStatement statement, String value) throws SQLException {
        statement.setLong(parameter.getOrdinal(), Long.parseLong(value));
    }
}

