/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.validation;

import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.dialect.DatabaseDialectsPool;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.validation.AParameterValidator;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;

public class ArrayValidator
extends AParameterValidator {
    public ArrayValidator(SQLTypeToken type) {
        super(type);
    }

    @Override
    public void validateDefaultValue(SQLQueryParameter parameter, String defValue) throws SQLQueryValidationException {
    }

    @Override
    public void validateValue(SQLQueryParameter parameter, String value) throws SQLQueryValidationException {
    }

    @Override
    public String convertValue(SQLQueryParameter parameter, Object value) throws SQLQueryValidationException {
        if (value == null) {
            return null;
        }
        if (value instanceof Array) {
            try {
                value = ((Array)value).getArray();
            }
            catch (SQLException e) {
                this.throwValidationException(5048, parameter, "Failed to get array from value.");
            }
        }
        if (!value.getClass().isArray()) {
            this.throwValidationException(5048, parameter, "Provided value is nor array.");
        }
        parameter.setObjectValue(value);
        Object[] array = (Object[])value;
        StringBuilder str = new StringBuilder();
        str.append("ARRAY[");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                str.append(", ");
            }
            if (array[i] instanceof String) {
                str.append("'").append(array[i]).append("'");
                continue;
            }
            str.append(array[i]);
        }
        str.append("]");
        return str.toString();
    }

    @Override
    public void prepareValue(SQLQueryParameter parameter, PreparedStatement statement) throws SQLQueryValidationException, DatabaseSQLException {
        try {
            if (parameter.getMode() == SQLQueryParameterMode.OUT.getMode() || parameter.getMode() == SQLQueryParameterMode.INOUT.getMode()) {
                ((CallableStatement)statement).registerOutParameter(parameter.getOrdinal(), parameter.getType());
            }
            if (parameter.getMode() == SQLQueryParameterMode.IN.getMode() || parameter.getMode() == SQLQueryParameterMode.INOUT.getMode()) {
                Object value = parameter.getObjectValue();
                if (value == null && parameter.getValue() != null) {
                    value = this.parseArrayStringValue(parameter.getValue());
                }
                if (value == null) {
                    value = this.parseArrayStringValue(parameter.getDefaultValue());
                }
                DatabaseDialectsPool.getInstance().getDialect(statement.getConnection()).setArrayParameter(parameter, value, statement);
            }
        }
        catch (SQLException e) {
            throw new DatabaseSQLException(e);
        }
    }

    protected Object parseArrayStringValue(String value) throws SQLQueryValidationException {
        int index;
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).equalsIgnoreCase("null")) {
            return null;
        }
        if (value.equalsIgnoreCase("ARRAY[]")) {
            return new Object[0];
        }
        if (!value.startsWith("ARRAY[") || !value.endsWith("]")) {
            throw new SQLQueryValidationException(5048, "Failed to parse array value: " + value);
        }
        if (value.length() <= index) {
            throw new SQLQueryValidationException(5048, "Failed to parse array value: " + value);
        }
        if (value.charAt(index) == ']') {
            return null;
        }
        ArrayList<String> objects = new ArrayList<String>();
        char quotechar = '\u0000';
        StringBuffer stringvalue = new StringBuffer();
        for (index = 6; index < value.length(); ++index) {
            char c = value.charAt(index);
            if (c == '\'' || c == '\"') {
                if (quotechar == '\u0000') {
                    quotechar = c;
                    continue;
                }
                quotechar = '\u0000';
                continue;
            }
            if (c == ',' || c == ']') {
                if (quotechar == '\u0000') {
                    String s = stringvalue.toString().trim();
                    if (s.equalsIgnoreCase("null")) {
                        s = null;
                    }
                    objects.add(s);
                    stringvalue = new StringBuffer();
                    continue;
                }
                stringvalue.append(c);
                continue;
            }
            stringvalue.append(c);
        }
        return objects.toArray();
    }

    @Override
    protected void setValue(SQLQueryParameter parameter, PreparedStatement statement, String value) throws SQLException {
    }

    @Override
    protected String generateDefaultValueImpl(SQLQueryParameter parameter) {
        parameter.setDefaultValueWithoutValidation("ARRAY[]");
        return "ARRAY[]";
    }
}

