/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.validation;

import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.validation.IParameterValidator;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

abstract class AParameterValidator
implements IParameterValidator {
    protected SQLTypeToken type;

    public AParameterValidator(SQLTypeToken type) {
        this.type = type;
    }

    protected String toMessage(SQLQueryParameter parameter) {
        return "variable '@" + parameter.getName() + "', SQL type " + SQLTypeToken.getTypeById(parameter.getType()).getName();
    }

    protected String toMessage(String parameterName) {
        return "variable '@" + parameterName + "', SQL type " + this.type.getName();
    }

    @Override
    public boolean isDefaultValueIsNull(SQLQueryParameter parameter) {
        String defValue = parameter.getDefaultValue();
        return defValue == null || "NULL".equals(defValue);
    }

    protected void checkNullValue(SQLQueryParameter parameter, String value) throws SQLQueryValidationException {
        if (this.isValueIsNull(value) && !parameter.isNullable()) {
            this.throwValidationException(5048, parameter, "Parameter does not allow nulls.");
        }
    }

    @Override
    public boolean isValueIsNull(SQLQueryParameter parameter) {
        return this.isValueIsNull(parameter.getValue());
    }

    protected boolean isValueIsNull(String value) {
        return value == null || "NULL".equals(value);
    }

    protected boolean isDefaultValueIsNull(String defValue) {
        return defValue == null || "NULL".equals(defValue);
    }

    @Override
    public String escapeValue(SQLQueryParameter parameter) {
        return parameter.getValue();
    }

    @Override
    public String renderValue(SQLQueryParameter parameter) throws SQLQueryValidationException {
        if (!this.isValueIsNull(parameter)) {
            return this.escapeValue(parameter);
        }
        if (!this.isDefaultValueIsNull(parameter)) {
            return parameter.getDefaultValue();
        }
        if (!parameter.isNullable()) {
            this.throwValidationException(5048, parameter, "Parameter does not allow nulls.");
        }
        return null;
    }

    @Override
    public void prepareValue(SQLQueryParameter parameter, PreparedStatement statement) throws SQLQueryValidationException, DatabaseSQLException {
        try {
            if (parameter.getMode() == SQLQueryParameterMode.OUT.getMode() || parameter.getMode() == SQLQueryParameterMode.INOUT.getMode()) {
                ((CallableStatement)statement).registerOutParameter(parameter.getOrdinal(), parameter.getType());
            }
            if (parameter.getMode() == SQLQueryParameterMode.IN.getMode() || parameter.getMode() == SQLQueryParameterMode.INOUT.getMode()) {
                String value = this.renderValue(parameter);
                if (value != null) {
                    value = this.unescape(value);
                }
                if (value == null) {
                    statement.setNull(parameter.getOrdinal(), parameter.getType());
                } else {
                    this.setValue(parameter, statement, value);
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseSQLException(e);
        }
    }

    protected abstract void setValue(SQLQueryParameter var1, PreparedStatement var2, String var3) throws SQLException;

    @Override
    public int[] validateTypeSettings(String parameterName, List<String> settings) throws SQLQueryValidationException {
        int[] out = new int[3];
        if (settings == null || settings.isEmpty()) {
            return out;
        }
        if (settings.size() > 2) {
            StringBuffer sb = new StringBuffer();
            for (String setting : settings) {
                sb.append(setting).append(",");
            }
            String str = sb.toString();
            str = str.substring(0, str.length() - 1);
            this.throwValidationException(5048, parameterName, "Invalid type settings '" + str + "'.");
        }
        if (settings.size() == 1) {
            String value = settings.get(0);
            if (this.type.allowLength()) {
                try {
                    int length = Integer.parseInt(value);
                    if (length <= 0) {
                        throw new Exception();
                    }
                    out[0] = length;
                }
                catch (Exception exception) {
                    this.throwValidationException(5048, parameterName, "Invalid parameter length '" + value + "'.");
                }
            } else if (this.type.allowPrecision()) {
                try {
                    int precision = Integer.parseInt(value);
                    if (precision <= 0) {
                        throw new Exception();
                    }
                    out[1] = precision;
                }
                catch (Exception exception) {
                    this.throwValidationException(5048, parameterName, "Invalid parameter precision '" + value + "'.");
                }
            } else {
                this.throwValidationException(5048, parameterName, "Parameter length and precision are not supported.");
            }
        } else if (this.type.allowPrecision() && this.type.allowScale()) {
            String precisionStr = settings.get(0);
            String scaleStr = settings.get(1);
            int precision = 0;
            int scale = 0;
            try {
                precision = Integer.parseInt(precisionStr);
                if (precision <= 0) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                this.throwValidationException(5048, parameterName, "Invalid parameter precision '" + precisionStr + "'.");
            }
            try {
                scale = Integer.parseInt(scaleStr);
                if (scale <= 0) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                this.throwValidationException(5048, parameterName, "Invalid parameter scale '" + scaleStr + "'.");
            }
            if (scale > precision) {
                this.throwValidationException(5048, parameterName, "Parameter scale '" + scaleStr + "' must be less or equal to precision.");
            }
            out[1] = precision;
            out[2] = scale;
        } else {
            this.throwValidationException(5048, parameterName, "Parameter precision is not supported.");
        }
        return out;
    }

    @Override
    public String generateDefaultValue(SQLQueryParameter parameter) {
        if (parameter.isNullable()) {
            return "NULL";
        }
        return this.generateDefaultValueImpl(parameter);
    }

    protected abstract String generateDefaultValueImpl(SQLQueryParameter var1);

    protected String unescape(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    protected void throwValidationException(int errorCode, SQLQueryParameter parameter, String message) throws SQLQueryValidationException {
        throw new SQLQueryValidationException(errorCode, "Invalid " + this.toMessage(parameter) + ". " + message);
    }

    protected void throwValidationException(int errorCode, String parameterName, String message) throws SQLQueryValidationException {
        throw new SQLQueryValidationException(errorCode, "Invalid " + this.toMessage(parameterName) + ". " + message);
    }
}

