/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.validation;

import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.validation.AParameterValidator;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class ACharValidator
extends AParameterValidator {
    public ACharValidator(SQLTypeToken type) {
        super(type);
    }

    @Override
    public void validateDefaultValue(SQLQueryParameter parameter, String defValue) throws SQLQueryValidationException {
        if (this.isDefaultValueIsNull(defValue)) {
            return;
        }
        if (parameter.getLength() > 0 && defValue.length() > parameter.getLength()) {
            this.throwValidationException(5049, parameter, "Default value (" + defValue + ") exceeds maximum length (" + parameter.getLength() + ").");
        }
    }

    @Override
    public void validateValue(SQLQueryParameter parameter, String value) throws SQLQueryValidationException {
        this.checkNullValue(parameter, value);
        if (this.isValueIsNull(value)) {
            return;
        }
        if (parameter.getLength() > 0 && value.length() > parameter.getLength()) {
            this.throwValidationException(5049, parameter, "Value (" + value + ") exceeds maximum length (" + parameter.getLength() + ").");
        }
    }

    @Override
    public String convertValue(SQLQueryParameter parameter, Object value) throws SQLQueryValidationException {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public String escapeValue(SQLQueryParameter parameter) {
        if (this.isValueIsNull(parameter)) {
            return parameter.getValue();
        }
        return "'" + parameter.getValue() + "'";
    }

    @Override
    protected String generateDefaultValueImpl(SQLQueryParameter parameter) {
        parameter.setDefaultValueWithoutValidation("");
        return "''";
    }

    @Override
    protected void setValue(SQLQueryParameter parameter, PreparedStatement statement, String value) throws SQLException {
        statement.setString(parameter.getOrdinal(), value);
    }
}

