/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.validation;

import com.streamscape.Trace;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.validation.AParameterValidator;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ABinaryValidator
extends AParameterValidator {
    public ABinaryValidator(SQLTypeToken type) {
        super(type);
    }

    @Override
    public void validateDefaultValue(SQLQueryParameter parameter, String defValue) throws SQLQueryValidationException {
        if (this.isDefaultValueIsNull(defValue)) {
            return;
        }
        if (parameter.getLength() > 0 && defValue.length() / 2 > parameter.getLength()) {
            this.throwValidationException(5049, parameter, "Default value (" + defValue + ") exceeds maximum length (" + parameter.getLength() * 2 + ").");
        }
        this.validateHexString(parameter, defValue);
    }

    @Override
    public void validateValue(SQLQueryParameter parameter, String value) throws SQLQueryValidationException {
        this.checkNullValue(parameter, value);
        if (this.isValueIsNull(value)) {
            return;
        }
        if (parameter.getLength() > 0 && value.length() / 2 > parameter.getLength()) {
            this.throwValidationException(5049, parameter, "Value (" + value + ") exceeds maximum length (" + parameter.getLength() * 2 + ").");
        }
        this.validateHexString(parameter, value);
    }

    @Override
    public String convertValue(SQLQueryParameter parameter, Object value) throws SQLQueryValidationException {
        if (value == null) {
            return null;
        }
        if (!(value instanceof byte[])) {
            this.throwValidationException(5049, parameter, "Expected object of type byte[] for binary column.");
        }
        return StringConverter.byteArrayToHexString((byte[])value);
    }

    @Override
    public String escapeValue(SQLQueryParameter parameter) {
        if (this.isValueIsNull(parameter)) {
            return parameter.getValue();
        }
        return "'" + parameter.getValue() + "'";
    }

    @Override
    protected String generateDefaultValueImpl(SQLQueryParameter parameter) {
        parameter.setDefaultValueWithoutValidation("00");
        return "'00'";
    }

    @Override
    protected void setValue(SQLQueryParameter parameter, PreparedStatement statement, String value) throws SQLException {
        try {
            statement.setBytes(parameter.getOrdinal(), StringConverter.hexStringToByteArray(value));
        }
        catch (IOException e) {
            Trace.logError(this, "Failed to set parameter " + parameter.getName() + " to value " + value + ": " + e.getMessage());
        }
    }

    protected void validateHexString(SQLQueryParameter parameter, String value) throws SQLQueryValidationException {
        try {
            StringConverter.validateHexString(value);
        }
        catch (IOException e) {
            this.throwValidationException(5049, parameter, "Value (" + value + ") is not hex string: " + e.getMessage());
        }
    }
}

