/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.syntax;

import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.excp.SQLQueryParseException;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import com.streamscape.sdo.sql.enums.SQLQueryType;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.syntax.ASQLQuerySyntax;
import com.streamscape.sdo.sql.validation.IParameterValidator;
import com.streamscape.sdo.sql.validation.ParameterValidatorPool;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DefaultSQLQuerySyntax
extends ASQLQuerySyntax {
    private static final char PARAMETER_ESCAPE_DELIMITER = '\u00e0';
    private static final Pattern PARAMETER_TEMPLATE_PATTERN = Pattern.compile("\\$\\{(ARRAY\\s|OTHER\\s)?([\\w\\-\\.]+){1}(\\(\\d+[,\\d]*\\))?(\\s@\\w+){1}(\\s\\w+)?(\\s?={1})?(\\s.+)?\\}");

    DefaultSQLQuerySyntax() {
    }

    @Override
    protected List<SQLQueryParameter> parseImpl(String template, List<Object> sqlBricks, SQLQueryType type, SQLQuery queryObject) throws SQLQueryParseException {
        ArrayList<String> saveStrings = new ArrayList<String>();
        String sql = this.extractStrings(template, saveStrings);
        String[] tokenList = sql.split("\\s+");
        ArrayList<SQLQueryParameter> params = new ArrayList<SQLQueryParameter>();
        boolean searchable = false;
        boolean returnCode = type.isCallable();
        int index = 1;
        SQLQueryParseException fault = null;
        for (String token : tokenList) {
            if (token.length() == 0) {
                if (sqlBricks == null) continue;
                sqlBricks.add(" ");
                continue;
            }
            if (token.trim().toUpperCase().equals("WHERE")) {
                searchable = true;
            }
            if (token.trim().toUpperCase().equals("CALL")) {
                returnCode = false;
            }
            if (token.startsWith("${") && token.endsWith("}")) {
                token = token.replace('\u00e0', ' ');
                try {
                    SQLQueryParameter param = this.fetchParameter(token, saveStrings, index, searchable, returnCode, type.isCallable(), queryObject);
                    params.add(param);
                    if (sqlBricks != null) {
                        sqlBricks.add(param);
                    }
                }
                catch (SQLQueryParseException exception) {
                    if (fault != null && exception.getCause() == null) {
                        exception.initCause(fault);
                    }
                    fault = exception;
                }
                ++index;
                continue;
            }
            if (token.endsWith("=")) {
                if (sqlBricks == null) continue;
                sqlBricks.add(token.substring(0, token.length() - 1));
                sqlBricks.add("=");
                continue;
            }
            if (token.startsWith("?")) {
                String brick;
                if (saveStrings.size() > 0) {
                    String savedString = (String)saveStrings.remove(0);
                    brick = token.replaceAll("^\\?", savedString);
                } else {
                    brick = token;
                }
                if (sqlBricks == null) continue;
                sqlBricks.add(brick);
                continue;
            }
            if (sqlBricks == null) continue;
            sqlBricks.add(token);
        }
        if (fault != null) {
            throw fault;
        }
        return params;
    }

    @Override
    public String generateParameter(String name, SQLTypeToken type, String typeName, String defaultValue, SQLQueryParameterMode mode) {
        StringBuffer str = new StringBuffer();
        str.append("${").append(type.getName());
        if (typeName != null) {
            str.append(" ").append(typeName);
        }
        str.append(" @").append(name);
        if (defaultValue != null) {
            str.append(" ").append("DEFAULT").append(" = ").append(defaultValue);
        }
        if (mode != null) {
            str.append(" ").append(mode.getName());
        }
        str.append("}");
        return str.toString();
    }

    private SQLQueryParameter fetchParameter(String template, List<String> saveStrings, int ordinal, boolean searchable, boolean returnCode, boolean callable, SQLQuery object) throws SQLQueryParseException {
        Matcher matcher;
        SQLQueryParameterMode mode = SQLQueryParameterMode.IN;
        if (!callable && (((String)template).endsWith(" IN}") || ((String)template).endsWith(" OUT}") || ((String)template).endsWith(" INOUT}"))) {
            throw new SQLQueryParseException(5044, ErrorMessages.format("SQL query '%1$s' is invalid.", new String[]{template}));
        }
        if (callable && !((String)template).endsWith(" IN}") && !((String)template).endsWith(" OUT}") && !((String)template).endsWith(" INOUT}")) {
            throw new SQLQueryParseException(5044, ErrorMessages.format("SQL query '%1$s' is invalid.", new String[]{template}));
        }
        if (callable) {
            int index = ((String)template).lastIndexOf(" ");
            mode = SQLQueryParameterMode.getMode(((String)template).substring(index + 1, ((String)template).length() - 1));
            template = ((String)template).substring(0, index) + "}";
        }
        if ((matcher = PARAMETER_TEMPLATE_PATTERN.matcher((CharSequence)template)).find() && matcher.group().equals(template)) {
            int[] out;
            SQLTypeToken type;
            String otherMappingType = matcher.group(1);
            String mappingType = matcher.group(2);
            String typeSettings = matcher.group(3);
            String name = matcher.group(4).substring(2);
            String defaultWord = matcher.group(5);
            String group6 = matcher.group(6);
            String defaultValue = matcher.group(7);
            boolean hasDefault = false;
            if (defaultWord != null) {
                if (!(defaultWord = defaultWord.trim()).toUpperCase().equals("DEFAULT")) {
                    throw new SQLQueryParseException(5044, ErrorMessages.format("SQL query '%1$s' is invalid.", new String[]{template}));
                }
                hasDefault = true;
            }
            if (hasDefault && (defaultValue == null || defaultValue.trim().equals(""))) {
                throw new SQLQueryParseException(5044, ErrorMessages.format("SQL query '%1$s' is invalid.", new String[]{template}));
            }
            if (hasDefault && (group6 == null || group6.trim().equals(""))) {
                throw new SQLQueryParseException(5044, ErrorMessages.format("SQL query '%1$s' is invalid.", new String[]{template}));
            }
            if (hasDefault && (defaultValue = defaultValue.trim()).equals("?")) {
                defaultValue = saveStrings.remove(0);
                defaultValue = defaultValue.trim();
            }
            ArrayList<String> settings = null;
            if (typeSettings != null) {
                settings = new ArrayList<String>();
                typeSettings = typeSettings.substring(1, typeSettings.length() - 1);
                StringTokenizer proc = new StringTokenizer(typeSettings, ",", false);
                while (proc.hasMoreTokens()) {
                    String token = proc.nextToken();
                    settings.add(token);
                }
            }
            if (otherMappingType != null) {
                String tmp = mappingType;
                mappingType = otherMappingType.trim();
                otherMappingType = tmp;
            }
            if ((type = SQLTypeToken.getTypeByName(mappingType)) == null) {
                throw new SQLQueryParseException(5047, "SQL type '" + mappingType + "' is not supported.");
            }
            IParameterValidator validator = ParameterValidatorPool.getInstance().getValidator(type);
            try {
                out = validator.validateTypeSettings(name, settings);
            }
            catch (SQLQueryValidationException exception) {
                throw new SQLQueryParseException(5044, ErrorMessages.format("SQL query '%1$s' is invalid.", new String[]{template}), exception);
            }
            if (object != null) {
                SQLQueryParameter param;
                try {
                    param = object.getParameters().get(name);
                }
                catch (SQLQueryValidationException exception) {
                    throw new SQLQueryParseException(5044, ErrorMessages.format("SQL query '%1$s' is invalid.", new String[]{template}), exception);
                }
                if (param == null) {
                    throw new SQLQueryParseException(5046, "SQL query parameter '" + name + "' does not exist.");
                }
                return param;
            }
            try {
                return new SQLQueryParameter(name, type.getId(), otherMappingType, hasDefault, defaultValue, null, out[0], out[1], out[2], searchable, returnCode, ordinal, mode.getMode());
            }
            catch (SQLQueryValidationException exception) {
                throw new SQLQueryParseException(5044, ErrorMessages.format("SQL query '%1$s' is invalid.", new String[]{template}), exception);
            }
        }
        throw new SQLQueryParseException(5044, ErrorMessages.format("SQL query '%1$s' is invalid.", new String[]{template}));
    }

    private String extractStrings(String sql, List<String> stringList) throws SQLQueryParseException {
        char quoteChar = '\u0000';
        char prevChar = '\u0000';
        StringBuffer sb = new StringBuffer();
        StringBuffer sbString = null;
        StringBuffer sbStringIn = null;
        int i = 0;
        boolean inString = false;
        while (i < sql.length()) {
            char c = sql.charAt(i++);
            if (quoteChar == '\u0000') {
                if (c == '\"' || c == '\'') {
                    quoteChar = c;
                    sbString = new StringBuffer();
                    sbString.append(c);
                } else if (c == '$') {
                    sb.append(' ').append(c);
                } else if (c == '{' && prevChar == '$') {
                    quoteChar = c;
                    sb.append(c);
                } else if (c == '=') {
                    sb.append(' ').append(c).append(' ');
                } else {
                    if (c == '?') {
                        throw new SQLQueryParseException(5044, ErrorMessages.format("SQL query '%1$s' is invalid.", sql) + " '?' is not a valid character.");
                    }
                    sb.append(c);
                }
            } else if (quoteChar == '{') {
                if (!(inString || c != '\"' && c != '\'')) {
                    inString = true;
                    sbStringIn = new StringBuffer();
                    sbStringIn.append(c);
                } else if (inString) {
                    if (c == '\"' || c == '\'') {
                        inString = false;
                        sbStringIn.append(c);
                        stringList.add(sbStringIn.toString());
                        sb.append('\u00e0').append('?');
                    } else {
                        sbStringIn.append(c);
                    }
                } else {
                    if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                        if (prevChar == '=') {
                            sb.append('\u00e0');
                        }
                        sb.append(c);
                    } else if (prevChar != ' ' && prevChar != '\t' && prevChar != '\n' && prevChar != '\r' && prevChar != '{') {
                        sb.append('\u00e0');
                    }
                    if (c == '}') {
                        quoteChar = '\u0000';
                        sb.append(' ');
                    }
                }
            } else if (quoteChar == c) {
                quoteChar = '\u0000';
                sbString.append(c);
                stringList.add(sbString.toString());
                sb.append('?');
            } else {
                sbString.append(c);
            }
            prevChar = c;
        }
        return sb.toString();
    }
}

