/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.syntax;

import com.streamscape.sdo.excp.SQLQueryParseException;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import com.streamscape.sdo.sql.enums.SQLQueryType;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.syntax.ISQLQuerySyntax;
import com.streamscape.sdo.sql.syntax.SqlWithComment;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class ASQLQuerySyntax
implements ISQLQuerySyntax {
    private static final Pattern STORED_PROCEDURE_PATTERN_WITH_BRACKETS = Pattern.compile("\\s*\\{(@ReturnCode\\s*=)?(\\s*[cC][aA][lL]{2}){1}\\s+(.+){1}\\}\\s*");
    private static final Pattern STORED_PROCEDURE_PATTERN_WITHOUT_BRACKETS = Pattern.compile("\\s*(@ReturnCode\\s*=)?(\\s*[cC][aA][lL]{2}){1}\\s+(.+){1}\\s*");
    public static final String COMMENT_BEGIN = "/*";
    public static final String COMMENT_END = "*/";

    ASQLQuerySyntax() {
    }

    @Override
    public SQLQuery parse(List<Object> sqlBricks, Object inObject) throws SQLQueryParseException, SQLQueryValidationException {
        Object inTemplate;
        if (inObject == null) {
            throw new NullPointerException();
        }
        SQLQuery queryObject = null;
        if (inObject instanceof SQLQuery) {
            queryObject = (SQLQuery)inObject;
            inTemplate = queryObject.getSqlScript();
        } else if (inObject instanceof String) {
            inTemplate = (String)inObject;
        } else {
            throw new IllegalArgumentException();
        }
        inTemplate = ((String)inTemplate).trim();
        SqlWithComment tempSql = this.readComment((String)inTemplate);
        inTemplate = tempSql.sql;
        String comment = tempSql.comment;
        Object template = inTemplate;
        SQLQueryType type = SQLQueryType.determineType((String)template);
        if (type != SQLQueryType.SELECT && type != SQLQueryType.INSERT && type != SQLQueryType.UPDATE && type != SQLQueryType.DELETE) {
            boolean brackets = true;
            Matcher matcher = STORED_PROCEDURE_PATTERN_WITH_BRACKETS.matcher((CharSequence)template);
            if (!matcher.find()) {
                brackets = false;
                matcher = STORED_PROCEDURE_PATTERN_WITHOUT_BRACKETS.matcher((CharSequence)template);
            }
            matcher.reset();
            if (matcher.find() && matcher.group().equals(template)) {
                String returnCode = matcher.group(1);
                type = SQLQueryType.CALL;
                if (returnCode != null) {
                    template = ((String)template).substring(0, matcher.start(1)) + this.generateParameter("ReturnCode", SQLTypeToken.INTEGER, null, null, SQLQueryParameterMode.OUT) + "=" + ((String)template).substring(matcher.end(1));
                    type = SQLQueryType.CALL_WITH_RETURN;
                }
                if (brackets) {
                    template = ((String)template).substring(1, ((String)template).length() - 1);
                }
            } else {
                type = SQLQueryType.DYNAMIC;
            }
        }
        List<SQLQueryParameter> params = this.parseImpl((String)template, sqlBricks, type, queryObject);
        if (queryObject == null) {
            if (comment != null) {
                inTemplate = comment + (String)inTemplate;
            }
            SQLQuery object = new SQLQuery((String)inTemplate, type.getId());
            for (SQLQueryParameter param : params) {
                object.getParameters().add(param);
            }
            return object;
        }
        return queryObject;
    }

    private SqlWithComment readComment(String inString) {
        StringBuffer comment = new StringBuffer();
        while (inString.startsWith(COMMENT_BEGIN)) {
            int pos = inString.indexOf(COMMENT_END);
            if (pos != -1) {
                comment.append(inString.substring(0, pos + COMMENT_END.length())).append("\n");
                inString = inString.substring(pos + COMMENT_END.length());
                continue;
            }
            inString = inString.substring(COMMENT_BEGIN.length());
        }
        return new SqlWithComment(inString, comment.toString());
    }

    protected abstract List<SQLQueryParameter> parseImpl(String var1, List<Object> var2, SQLQueryType var3, SQLQuery var4) throws SQLQueryParseException;
}

