/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.enums;

import java.util.HashMap;
import java.util.Map;

public enum SQLTypeToken {
    INTEGER(4, "INTEGER", false, false, false, true),
    DOUBLE(8, "DOUBLE", false, false, false, true),
    TINYINT(-6, "TINYINT", false, false, false, true),
    SMALLINT(5, "SMALLINT", false, false, false, true),
    BIGINT(-5, "BIGINT", false, false, false, true),
    REAL(7, "REAL", false, false, false, true),
    FLOAT(6, "FLOAT", false, false, false, true),
    CHAR(1, "CHAR", true, false, false, true),
    VARCHAR(12, "VARCHAR", true, false, false, true),
    NVARCHAR(-9, "NVARCHAR", true, false, false, true),
    LONGVARCHAR(-1, "LONGVARCHAR", true, false, false, true),
    DATE(91, "DATE", false, false, false, true),
    TIME(92, "TIME", false, false, false, true),
    TIMESTAMP(93, "TIMESTAMP", false, false, false, true),
    BOOLEAN(16, "BOOLEAN", false, false, false, true),
    DECIMAL(3, "DECIMAL", false, true, true, true),
    NUMERIC(2, "NUMERIC", false, true, true, true),
    UNKNOWN(Integer.MIN_VALUE, "UNKNOWN", false, false, false, false),
    BLOB(2004, "BLOB", true, false, false, true),
    CLOB(2005, "CLOB", true, false, false, true),
    OTHER(1111, "OTHER", true, false, false, true),
    ARRAY(2003, "ARRAY", true, false, false, true),
    BINARY(-2, "BINARY", true, false, false, true),
    VARBINARY(-3, "VARBINARY", true, false, false, true),
    LONGVARBINARY(-4, "LONGVARBINARY", true, false, false, true),
    VARCHAR_IGNORECASE(12, "VARCHAR_IGNORECASE", true, false, false, false);

    private static Map<Integer, SQLTypeToken> typeMap;
    private static Map<String, SQLTypeToken> nameMap;
    private int id;
    private String name;
    private boolean length;
    private boolean precision;
    private boolean scale;
    private boolean supported;

    private SQLTypeToken(int id, String name, boolean length, boolean precision, boolean scale, boolean supported) {
        this.id = id;
        this.name = name;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.supported = supported;
    }

    public static SQLTypeToken getTypeById(int id) {
        return typeMap.get(id);
    }

    public static SQLTypeToken getTypeByName(String name) {
        return nameMap.get(name);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean allowLength() {
        return this.length;
    }

    public boolean allowPrecision() {
        return this.precision;
    }

    public boolean allowScale() {
        return this.scale;
    }

    public boolean isSupported() {
        return this.supported;
    }

    static {
        typeMap = new HashMap<Integer, SQLTypeToken>();
        nameMap = new HashMap<String, SQLTypeToken>();
        nameMap.put("INTEGER", INTEGER);
        nameMap.put("DOUBLE", DOUBLE);
        nameMap.put("VARCHAR_IGNORECASE", VARCHAR_IGNORECASE);
        nameMap.put("VARCHAR", VARCHAR);
        nameMap.put("CHAR", CHAR);
        nameMap.put("LONGVARCHAR", LONGVARCHAR);
        nameMap.put("NVARCHAR", NVARCHAR);
        nameMap.put("DATE", DATE);
        nameMap.put("TIME", TIME);
        nameMap.put("DECIMAL", DECIMAL);
        nameMap.put("BOOLEAN", BOOLEAN);
        nameMap.put("BIT", BOOLEAN);
        nameMap.put("TINYINT", TINYINT);
        nameMap.put("SMALLINT", SMALLINT);
        nameMap.put("BIGINT", BIGINT);
        nameMap.put("REAL", REAL);
        nameMap.put("FLOAT", FLOAT);
        nameMap.put("NUMERIC", NUMERIC);
        nameMap.put("TIMESTAMP", TIMESTAMP);
        nameMap.put("BINARY", BINARY);
        nameMap.put("VARBINARY", VARBINARY);
        nameMap.put("LONGVARBINARY", LONGVARBINARY);
        nameMap.put("BLOB", BLOB);
        nameMap.put("CLOB", CLOB);
        nameMap.put("OTHER", OTHER);
        nameMap.put("ARRAY", ARRAY);
        typeMap.put(4, INTEGER);
        typeMap.put(8, DOUBLE);
        typeMap.put(100, VARCHAR_IGNORECASE);
        typeMap.put(12, VARCHAR);
        typeMap.put(-9, NVARCHAR);
        typeMap.put(1, CHAR);
        typeMap.put(-1, LONGVARCHAR);
        typeMap.put(91, DATE);
        typeMap.put(92, TIME);
        typeMap.put(3, DECIMAL);
        typeMap.put(16, BOOLEAN);
        typeMap.put(-7, BOOLEAN);
        typeMap.put(-6, TINYINT);
        typeMap.put(5, SMALLINT);
        typeMap.put(-5, BIGINT);
        typeMap.put(7, REAL);
        typeMap.put(6, FLOAT);
        typeMap.put(2, NUMERIC);
        typeMap.put(93, TIMESTAMP);
        typeMap.put(9, TIMESTAMP);
        typeMap.put(-2, BINARY);
        typeMap.put(-3, VARBINARY);
        typeMap.put(-4, LONGVARBINARY);
        typeMap.put(2004, BLOB);
        typeMap.put(2005, CLOB);
        typeMap.put(1111, OTHER);
        typeMap.put(2003, ARRAY);
    }
}

