/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.enums;

import java.util.HashMap;
import java.util.Map;

public enum SQLQueryType {
    SELECT(1, "SELECT", false),
    INSERT(2, "INSERT", false),
    UPDATE(3, "UPDATE", false),
    DELETE(4, "DELETE", false),
    CALL(5, "CALL", true),
    CALL_WITH_RETURN(6, "CALL WITH RETURN", true),
    DYNAMIC(7, "DYNAMIC", false);

    private static Map<Integer, SQLQueryType> typeMap;
    private static Map<String, SQLQueryType> nameMap;
    private int id;
    private String name;
    private boolean callable;

    public static SQLQueryType determineType(String sqlScript) {
        if (sqlScript.toUpperCase().startsWith("SELECT")) {
            return SELECT;
        }
        if (sqlScript.toUpperCase().startsWith("INSERT")) {
            return INSERT;
        }
        if (sqlScript.toUpperCase().startsWith("UPDATE")) {
            return UPDATE;
        }
        if (sqlScript.toUpperCase().startsWith("DELETE")) {
            return DELETE;
        }
        return null;
    }

    public static boolean isCallable(int id) {
        return SQLQueryType.getTypeById(id).isCallable();
    }

    public static SQLQueryType getTypeById(int id) {
        return typeMap.get(id);
    }

    public static SQLQueryType getTypeByName(String name) {
        return nameMap.get(name);
    }

    private SQLQueryType(int id, String name, boolean callable) {
        this.id = id;
        this.name = name;
        this.callable = callable;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCallable() {
        return this.callable;
    }

    static {
        typeMap = new HashMap<Integer, SQLQueryType>();
        nameMap = new HashMap<String, SQLQueryType>();
        typeMap.put(1, SELECT);
        typeMap.put(2, INSERT);
        typeMap.put(3, UPDATE);
        typeMap.put(4, DELETE);
        typeMap.put(5, CALL);
        typeMap.put(6, CALL_WITH_RETURN);
        typeMap.put(7, DYNAMIC);
        nameMap.put("SELECT", SELECT);
        nameMap.put("INSERT", INSERT);
        nameMap.put("UPDATE", UPDATE);
        nameMap.put("DELETE", DELETE);
        nameMap.put("CALL", CALL);
        nameMap.put("CALL WITH RETURN", CALL_WITH_RETURN);
        nameMap.put("DYNAMIC", DYNAMIC);
    }
}

