/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.enums;

import java.util.HashMap;
import java.util.Map;

public enum SQLQueryParameterMode {
    IN(1, "IN"),
    OUT(2, "OUT"),
    INOUT(3, "INOUT");

    private int mode;
    private String name;
    private static Map<Integer, SQLQueryParameterMode> modeMap;
    private static Map<String, SQLQueryParameterMode> nameMap;

    public static SQLQueryParameterMode getMode(int mode) {
        return modeMap.get(mode);
    }

    public static SQLQueryParameterMode getMode(String name) {
        return nameMap.get(name);
    }

    private SQLQueryParameterMode(int mode, String name) {
        this.mode = mode;
        this.name = name;
    }

    public int getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    static {
        modeMap = new HashMap<Integer, SQLQueryParameterMode>();
        nameMap = new HashMap<String, SQLQueryParameterMode>();
        modeMap.put(IN.getMode(), IN);
        modeMap.put(OUT.getMode(), OUT);
        modeMap.put(INOUT.getMode(), INOUT);
        nameMap.put(IN.getName(), IN);
        nameMap.put(OUT.getName(), OUT);
        nameMap.put(INOUT.getName(), INOUT);
    }
}

