/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.dialect;

import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.dialect.IDatabaseDialect;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class OracleDatabaseDialect
implements IDatabaseDialect {
    @Override
    public void setArrayParameter(SQLQueryParameter parameter, Object value, PreparedStatement statement) throws DatabaseSQLException, SQLQueryValidationException {
        try {
            Connection rawConnection = DatabaseConnection.getRawConnection(statement.getConnection());
            Class oracleConnectionClass = ClassUtils.loadClass("oracle.jdbc.OracleConnection", rawConnection.getClass().getClassLoader());
            Method createArrayMethod = oracleConnectionClass.getMethod("createARRAY", String.class, Object.class);
            Array array = (Array)ClassUtils.invokeMethod(rawConnection, createArrayMethod, new Object[]{parameter.getTypeName().toUpperCase(), (Object[])value});
            statement.setArray(parameter.getOrdinal(), array);
        }
        catch (SQLException exception) {
            throw new DatabaseSQLException(exception);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof SQLException) {
                throw new DatabaseSQLException((SQLException)e.getCause());
            }
            throw new SQLQueryValidationException(5048, "Invalid variable '@" + parameter.getName() + "', SQL type " + SQLTypeToken.getTypeById(parameter.getType()).getName() + ". " + e.getCause().getMessage());
        }
        catch (UtilitiesException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<SQLQueryParameter> onParameterMetaData(ParameterMetaData meta) throws DatabaseSQLException, SQLQueryValidationException {
        return null;
    }
}

