/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql.dialect;

import com.streamscape.Trace;
import com.streamscape.sdo.sql.dialect.DefaultDatabaseDialect;
import com.streamscape.sdo.sql.dialect.IDatabaseDialect;
import com.streamscape.sdo.sql.dialect.OracleDatabaseDialect;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DatabaseDialectsPool {
    private static DatabaseDialectsPool instance;
    private static Map<DatabaseVendor, IDatabaseDialect> dialectsMap;

    public static synchronized DatabaseDialectsPool getInstance() {
        if (instance == null) {
            instance = new DatabaseDialectsPool();
        }
        return instance;
    }

    public IDatabaseDialect getDialect(Connection connection) {
        return dialectsMap.get((Object)DatabaseVendor.getDatabaseVendor(connection));
    }

    private DatabaseDialectsPool() {
    }

    static {
        dialectsMap = new ConcurrentHashMap<DatabaseVendor, IDatabaseDialect>();
        dialectsMap.put(DatabaseVendor.ORACLE, new OracleDatabaseDialect());
        dialectsMap.put(DatabaseVendor.DEFAULT, new DefaultDatabaseDialect());
    }

    static enum DatabaseVendor {
        ORACLE,
        DEFAULT;


        public static DatabaseVendor getDatabaseVendor(Connection connection) {
            try {
                String databaseProductName = connection.getMetaData().getDatabaseProductName().toLowerCase();
                if (databaseProductName.contains("oracle")) {
                    return ORACLE;
                }
                return DEFAULT;
            }
            catch (SQLException e) {
                Trace.logError(DatabaseDialectsPool.class, "Failed to get dtabase product name: " + e.getMessage());
                return DEFAULT;
            }
        }
    }
}

