/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql;

import com.streamscape.Trace;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class StoredProcedureDescription
extends CloneableDataObject {
    private static final int PARAMETER_MODE_RETURN = 5;
    private String name = null;
    private ArrayList<SQLQueryParameter> parameters = new ArrayList();

    private StoredProcedureDescription() {
    }

    public StoredProcedureDescription(String procName, Connection connection) {
        this.name = procName;
        try {
            DatabaseMetaData meta = connection.getMetaData();
            ResultSet result = meta.getProcedureColumns(connection.getCatalog(), null, procName, null);
            int ordinal = 1;
            if (result != null) {
                while (result.next()) {
                    String parameterName = result.getString("COLUMN_NAME").substring(1);
                    int parameterType = result.getInt("DATA_TYPE");
                    String parameterTypeName = result.getString("TYPE_NAME");
                    boolean isReturnCode = false;
                    int parameterMode = result.getInt("COLUMN_TYPE");
                    if (parameterMode == 1) {
                        parameterMode = SQLQueryParameterMode.IN.getMode();
                    } else if (parameterMode == 4) {
                        parameterMode = SQLQueryParameterMode.OUT.getMode();
                    } else if (parameterMode == 2) {
                        parameterMode = SQLQueryParameterMode.INOUT.getMode();
                    } else if (parameterMode == 5) {
                        parameterMode = SQLQueryParameterMode.OUT.getMode();
                        isReturnCode = true;
                    }
                    boolean parameterNullable = false;
                    short nullable = result.getShort("NULLABLE");
                    if (nullable == 1) {
                        parameterNullable = true;
                    }
                    short parameterLength = result.getShort("LENGTH");
                    short parameterScale = result.getShort("SCALE");
                    short parameterPrecision = result.getShort("PRECISION");
                    SQLQueryParameter param = new SQLQueryParameter(parameterName, parameterType, parameterTypeName, parameterNullable, null, null, parameterLength, parameterPrecision, parameterScale, false, isReturnCode, ordinal, parameterMode);
                    this.parameters.add(param);
                    ++ordinal;
                }
            }
        }
        catch (SQLException error) {
            Trace.logError(this, error.getMessage());
        }
        catch (SQLQueryValidationException error) {
            Trace.logError(this, error.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public Iterator<SQLQueryParameter> iterator() {
        return this.parameters.iterator();
    }

    @Override
    public Object clone() {
        StoredProcedureDescription result = new StoredProcedureDescription();
        result.name = this.name;
        for (SQLQueryParameter parameter : this.parameters) {
            result.parameters.add((SQLQueryParameter)parameter.clone());
        }
        return result;
    }
}

