/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql;

import com.streamscape.sdo.excp.SQLQueryParseException;
import com.streamscape.sdo.sql.DatabaseDescriptor;
import java.sql.Connection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLTableName {
    private static final Pattern TABLE_NAME_TEMPLATE = Pattern.compile("((\\[([\\w\\$#\\s]+)\\]\\.)|(([\\w\\$#\\s]+)\\.))?((\\[([\\w\\$#\\s]+)\\]\\.)|(([\\w\\$#\\s]+)\\.))?((\\[([\\w\\$#\\s]+)\\])|(([\\w\\$#\\s]+)))");
    private String catalog = null;
    private String schema = null;
    private String table = null;

    private SQLTableName() {
    }

    public static SQLTableName parse(String string) throws SQLQueryParseException {
        SQLTableName object = new SQLTableName();
        if (string == null) {
            return object;
        }
        Matcher matcher = TABLE_NAME_TEMPLATE.matcher(string);
        if (!matcher.find() || !matcher.group().equals(string)) {
            throw new SQLQueryParseException(5044, "Invalid table name: " + string);
        }
        String token = matcher.group(13);
        if (token != null || (token = matcher.group(11)) != null) {
            object.table = token;
        }
        if ((token = matcher.group(8)) != null || (token = matcher.group(10)) != null) {
            object.schema = token;
        } else {
            token = matcher.group(3);
            if (token != null || (token = matcher.group(5)) != null) {
                object.schema = token;
                return object;
            }
        }
        token = matcher.group(3);
        if (token != null || (token = matcher.group(5)) != null) {
            object.catalog = token;
        }
        return object;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String toString() {
        StringBuffer string = new StringBuffer();
        if (this.catalog != null) {
            string.append(this.catalog).append(".");
        }
        if (this.schema != null) {
            string.append(this.schema).append(".");
        }
        string.append(this.table);
        return string.toString();
    }

    public String toQuotedString() {
        return this.toQuotedString(null);
    }

    public String toQuotedString(Connection connection) {
        StringBuffer string = new StringBuffer();
        if (this.catalog != null) {
            string.append(DatabaseDescriptor.quoteTableName(this.catalog, connection)).append(".");
        }
        if (this.schema != null) {
            string.append(DatabaseDescriptor.quoteTableName(this.schema, connection)).append(".");
        }
        string.append(DatabaseDescriptor.quoteTableName(this.table, connection));
        return string.toString();
    }
}

