/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.excp.SQLQueryParseException;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SQLQueryParameterList
extends CloneableDataObject {
    private List<SQLQueryParameter> parameters = new ArrayList<SQLQueryParameter>();

    public void add(SQLQueryParameter parameter) throws SQLQueryParseException {
        String name = parameter.getName();
        for (SQLQueryParameter param : this.parameters) {
            if (!param.getName().equalsIgnoreCase(name)) continue;
            throw new SQLQueryParseException(5045, "SQL query parameter '" + name + "' already exists.");
        }
        this.parameters.add(parameter);
    }

    public void add(List<SQLQueryParameter> parameters) throws SQLQueryParseException {
        for (SQLQueryParameter parameter : parameters) {
            this.add(parameter);
        }
    }

    public SQLQueryParameter get(String name) throws SQLQueryValidationException {
        for (SQLQueryParameter param : this.parameters) {
            if (!param.getName().equalsIgnoreCase(name)) continue;
            return param;
        }
        throw new SQLQueryValidationException(5048, "Parameter undefined '" + name + "'.");
    }

    public SQLQueryParameter get(int ordinal) throws SQLQueryValidationException {
        for (SQLQueryParameter param : this.parameters) {
            if (param.getOrdinal() != ordinal) continue;
            return param;
        }
        throw new SQLQueryValidationException(5048, "Parameter undefined at ordinal " + ordinal + ".");
    }

    public Iterator<SQLQueryParameter> iterator() {
        return this.sort().iterator();
    }

    private List<SQLQueryParameter> sort() {
        Collections.sort(this.parameters, new Comparator<SQLQueryParameter>(this){

            @Override
            public int compare(SQLQueryParameter p1, SQLQueryParameter p2) {
                return p1.getOrdinal() - p2.getOrdinal();
            }
        });
        return this.parameters;
    }

    public void set(String name, String value) throws SQLQueryValidationException {
        SQLQueryParameter param = this.checkSetValue(name);
        param.setValue(value);
    }

    public void set(String name, Object value) throws SQLQueryValidationException {
        SQLQueryParameter param = this.checkSetValue(name);
        param.setValue(value);
    }

    public void set(int ordinal, String value) throws SQLQueryValidationException {
        SQLQueryParameter param = this.checkSetValue(ordinal);
        param.setValue(value);
    }

    public void set(int ordinal, Object value) throws SQLQueryValidationException {
        SQLQueryParameter param = this.checkSetValue(ordinal);
        param.setValue(value);
    }

    private SQLQueryParameter checkSetValue(int ordinal) throws SQLQueryValidationException {
        SQLQueryParameter param = this.get(ordinal);
        if (param == null) {
            throw new SQLQueryValidationException(5048, "Parameter undefined at ordinal " + ordinal + ".");
        }
        return this.checkSetValue(param);
    }

    private SQLQueryParameter checkSetValue(String name) throws SQLQueryValidationException {
        SQLQueryParameter param = this.get(name);
        if (param == null) {
            throw new SQLQueryValidationException(5048, "Parameter undefined '" + name + "'.");
        }
        return this.checkSetValue(param);
    }

    private SQLQueryParameter checkSetValue(SQLQueryParameter param) throws SQLQueryValidationException {
        if (param == null) {
            throw new SQLQueryValidationException(5004, "Null parameter object specified.");
        }
        if (param.getMode() == SQLQueryParameterMode.OUT.getMode()) {
            throw new SQLQueryValidationException(5048, "SQLQueryParameterMode.OUT for parameter: " + param.getName() + ".");
        }
        return param;
    }

    @Override
    public Object clone() {
        SQLQueryParameterList result = new SQLQueryParameterList();
        if (this.parameters != null) {
            for (SQLQueryParameter parameter : this.parameters) {
                result.parameters.add((SQLQueryParameter)parameter.clone());
            }
        }
        return result;
    }
}

