/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql;

import com.streamscape.Trace;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.validation.IParameterValidator;
import com.streamscape.sdo.sql.validation.ParameterValidatorPool;
import java.sql.PreparedStatement;

public class SQLQueryParameter
extends CloneableDataObject {
    private String name = "";
    private int type = -99;
    private String typeName = null;
    private boolean nullable = false;
    private boolean searchable = false;
    private boolean returnCode = false;
    private String defaultValue = null;
    private String value = null;
    private int length = -99;
    private int precision = -99;
    private int scale = -99;
    private int ordinal = -99;
    private int mode = -99;
    private transient Object objectValue = null;
    private transient boolean isValueSet = false;

    public SQLQueryParameter() {
    }

    public SQLQueryParameter(String name, int type, String typeName, boolean nullable, String defaultValue, String value, int length, int precision, int scale, boolean searchable, boolean returnCode, int ordinal, int mode) throws SQLQueryValidationException {
        SQLTypeToken typeObj = SQLTypeToken.getTypeById(type);
        if (typeObj == null) {
            Trace.logError(this, "Unable to determine the JDBC type for the code '" + type + "'.");
        }
        if (typeObj == null || !typeObj.isSupported()) {
            throw new SQLQueryValidationException(5048, "Parameter type unsupported " + (String)(typeObj != null ? typeObj.getName() : "id " + type) + " for parameter: " + name + ".");
        }
        if (SQLQueryParameterMode.getMode(mode) == null) {
            throw new SQLQueryValidationException(5048, "Incompatible parameter type " + mode + "' for parameter: " + name + ".");
        }
        if (typeObj != SQLTypeToken.ARRAY && typeObj != SQLTypeToken.OTHER) {
            typeName = null;
        }
        this.name = name;
        this.type = type;
        this.typeName = typeName;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.searchable = searchable;
        this.returnCode = returnCode;
        this.ordinal = ordinal;
        this.nullable = nullable;
        this.mode = mode;
        this.setDefaultValue(defaultValue);
        if (value != null) {
            this.setValue(value);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    protected void setValue(String value) throws SQLQueryValidationException {
        if (this.getMode() == SQLQueryParameterMode.OUT.getMode()) {
            throw new SQLQueryValidationException(5048, "Incompatible parameter type SQLQueryParameterMode.OUT for parameter: " + this.name + ".");
        }
        IParameterValidator validator = ParameterValidatorPool.getInstance().getValidator(this.type);
        validator.validateValue(this, value);
        this.value = value;
        this.isValueSet = true;
    }

    protected void setValue(Object value) throws SQLQueryValidationException {
        if (this.getMode() == SQLQueryParameterMode.OUT.getMode()) {
            throw new SQLQueryValidationException(5048, "Incompatible parameter type SQLQueryParameterMode.OUT for parameter: " + this.name + ".");
        }
        IParameterValidator validator = ParameterValidatorPool.getInstance().getValidator(this.type);
        this.setValue(validator.convertValue(this, value));
    }

    public void setDefaultValue(String defaultValue) throws SQLQueryValidationException {
        IParameterValidator validator = ParameterValidatorPool.getInstance().getValidator(this.type);
        validator.validateDefaultValue(this, defaultValue);
        this.defaultValue = defaultValue;
    }

    public void setDefaultValueWithoutValidation(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getValue() {
        return this.value;
    }

    protected void prepareValue(PreparedStatement statement) throws SQLQueryValidationException, DatabaseSQLException {
        IParameterValidator validator = ParameterValidatorPool.getInstance().getValidator(this.type);
        validator.prepareValue(this, statement);
    }

    protected String renderValue() throws SQLQueryValidationException {
        IParameterValidator validator = ParameterValidatorPool.getInstance().getValidator(this.type);
        return validator.renderValue(this);
    }

    protected String generateDefaultValue() {
        IParameterValidator validator = ParameterValidatorPool.getInstance().getValidator(this.type);
        return validator.generateDefaultValue(this);
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public int getLength() {
        return this.length;
    }

    protected void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    protected void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    protected void setScale(int scale) {
        this.scale = scale;
    }

    public boolean isReturnCode() {
        return this.returnCode;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setObjectValue(Object value) {
        this.objectValue = value;
    }

    public Object getObjectValue() {
        return this.objectValue;
    }

    boolean isValueSet() {
        return this.isValueSet;
    }

    void clearIsSetFlag() {
        this.isValueSet = false;
    }
}

