/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql;

import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sql.QueryParameterMappingTable;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SQLQueryMapper {
    private SQLQuery base;
    private int count;

    public SQLQueryMapper(SQLQuery base) {
        this(base, -1);
    }

    public SQLQueryMapper(SQLQuery base, int returnObjectCount) {
        if (base == null) {
            throw new NullPointerException();
        }
        if (returnObjectCount < -1 || returnObjectCount == 0) {
            throw new IllegalArgumentException();
        }
        this.base = base;
        this.count = returnObjectCount;
    }

    public SQLQuery map(QueryParameterMappingTable table, DataEvent event) throws SQLQueryValidationException {
        SQLQuery baseOut = (SQLQuery)this.base.clone();
        for (String name : table.getParameterNames()) {
            SQLQueryParameter param = baseOut.getParameters().get(name);
            if (param == null) continue;
            String value = table.getParameterValue(name, event);
            param.setValue(value);
        }
        return baseOut;
    }

    public SQLQuery map(QueryParameterMappingTable table) throws SQLQueryValidationException {
        return this.map(table, null);
    }

    public List<SQLQuery> map(RowSet set) throws SQLQueryValidationException {
        ArrayList<SQLQuery> out = new ArrayList<SQLQuery>();
        int rowCount = this.count == -1 ? set.getRowCount() : Math.min(set.getRowCount(), this.count);
        if (rowCount < 1) {
            return out;
        }
        try {
            set.beforeFirst();
            for (int i = 0; i < rowCount; ++i) {
                set.next();
                SQLQuery baseOut = (SQLQuery)this.base.clone();
                Iterator<SQLQueryParameter> iterator = baseOut.getParameters().iterator();
                while (iterator.hasNext()) {
                    SQLQueryParameter param = iterator.next();
                    if (param.getMode() == SQLQueryParameterMode.OUT.getMode()) continue;
                    String name = param.getName();
                    Object value = null;
                    int index = set.findColumn(name);
                    if (index > -1) {
                        value = set.getObject(index);
                    } else {
                        index = set.getOutParameterIndex(name);
                        if (index > -1) {
                            value = set.getOutParameterValue(index);
                        }
                    }
                    baseOut.getParameters().set(name, value);
                }
                out.add(baseOut);
            }
        }
        catch (SQLException exception) {
            throw new SQLQueryValidationException(5048, exception.getMessage());
        }
        return out;
    }
}

