/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql;

import com.streamscape.Trace;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.sdo.sql.SQLQueryFactory;
import com.streamscape.sdo.sql.enums.SQLQueryType;

public class SQLQueryInfo
extends CloneableDataObject {
    protected String componentType = null;
    protected String componentName = null;
    protected String sql = null;
    protected String sqlType = null;
    protected String url = null;
    protected String database = null;

    public SQLQueryInfo() {
    }

    public SQLQueryInfo(SQLQuery query) {
        try {
            this.sql = SQLQueryFactory.renderQuery(query);
            this.sqlType = SQLQueryType.getTypeById(query.getQueryType()).getName();
        }
        catch (Exception error) {
            Trace.logError(this, error.getMessage());
        }
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }
}

