/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql;

import com.streamscape.Trace;
import com.streamscape.cli.ClientContext;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.SerializerSupport;
import com.streamscape.omf.SerializerSupportException;
import com.streamscape.omf.serializer.SerializerFactory;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sdo.excp.SQLQueryException;
import com.streamscape.sdo.excp.SQLQueryParseException;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetFactory;
import com.streamscape.sdo.sql.DatabaseDescriptor;
import com.streamscape.sdo.sql.SQLColumn;
import com.streamscape.sdo.sql.SQLColumnSet;
import com.streamscape.sdo.sql.SQLDynamicQueryParser;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.sdo.sql.SQLQueryBatch;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.SQLTableName;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import com.streamscape.sdo.sql.enums.SQLQueryType;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.syntax.SQLQuerySyntax;
import com.streamscape.sef.dispatcher.AbstractFabricContextFactory;
import com.streamscape.sef.mf.admin.FabricContextType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class SQLQueryFactory
extends AbstractFabricContextFactory
implements SerializerSupport {
    private static final String SET_CLAUSE = "SET";
    private static final String WHERE_CLAUSE = "WHERE";
    protected static SQLQueryFactory instance = null;

    public static SQLQueryFactory getInstance() {
        if (instance == null) {
            instance = new SQLQueryFactory();
        }
        return instance;
    }

    @Override
    public void initSerializer(SerializerFactory factory, String serializerName) throws SerializerSupportException {
        for (SemanticType type : SQLQueryFactory.getSupportedTypes()) {
            try {
                if (factory.isAliased(type.getTypeName())) continue;
                factory.alias(type);
            }
            catch (FactoryManagerException ex) {
                throw new SerializerSupportException(ex);
            }
        }
    }

    public static SemanticType getSQLQueryType() throws UtilitiesException {
        SQLQuery sdo = (SQLQuery)ClassUtils.createFromClassName(SQLQueryFactory.class, SQLQuery.class.getName(), true);
        SemanticType type = new SemanticType("SQLQuery", sdo.getClass().getName());
        type.setDescription("A data object that represents an SQL Query.");
        type.setAncestorType("StructuredDataObject");
        return type;
    }

    public static SemanticType getSQLParameterType() throws UtilitiesException {
        SQLQueryParameter sdo = new SQLQueryParameter();
        SemanticType type = new SemanticType("SQLQueryParameter", sdo.getClass().getName());
        type.setDescription("A data object that represents an SQL Query parameter.");
        type.setAncestorType("SQLQuery");
        return type;
    }

    public static SemanticType getSQLQueryBatchType() throws UtilitiesException {
        SQLQueryBatch sdo = (SQLQueryBatch)ClassUtils.createFromClassName(SQLQueryFactory.class, SQLQueryBatch.class.getName(), true);
        SemanticType type = new SemanticType("SQLQueryBatch", sdo.getClass().getName());
        type.setDescription("A data object that represents an SQL Query Batch.");
        type.setAncestorType("StructuredDataObject");
        return type;
    }

    public static SQLColumnSet createColumnSet() {
        return new SQLColumnSet();
    }

    public static SQLColumnSet createColumnSet(ResultSet resultSet) throws SQLException, SQLQueryValidationException, MetaDataException {
        if (resultSet instanceof RowSet) {
            return SQLQueryFactory.createColumnSet((RowSet)resultSet);
        }
        ResultSetMetaData metaData = resultSet.getMetaData();
        if (metaData == null) {
            throw new SQLException("Result set meta data is null.");
        }
        SQLColumnSet sqlColumnSet = SQLQueryFactory.createColumnSet();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            SQLQueryParameter param = new SQLQueryParameter(metaData.getColumnName(i), metaData.getColumnType(i), metaData.getColumnTypeName(i), metaData.isNullable(i) == 1, null, null, 0, 0, 0, false, false, i, SQLQueryParameterMode.IN.getMode());
            if (!param.isNullable()) {
                param.generateDefaultValue();
            }
            sqlColumnSet.addColumn(param.getName(), SQLTypeToken.getTypeById(param.getType()), param.generateDefaultValue());
        }
        return sqlColumnSet;
    }

    public static SQLColumnSet createColumnSet(RowSet rowSet) throws MetaDataException, SQLQueryValidationException {
        RowMetaData metaData = rowSet.getRowMetaData();
        SQLColumnSet sqlColumnSet = SQLQueryFactory.createColumnSet();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            ColumnDescriptor columnDescriptor = metaData.getColumnDescriptor(i);
            SQLQueryParameter param = new SQLQueryParameter(columnDescriptor.getName(), columnDescriptor.getSQLType(), null, columnDescriptor.isNullable(), null, null, 0, 0, 0, false, false, i, SQLQueryParameterMode.IN.getMode());
            if (!param.isNullable()) {
                param.generateDefaultValue();
            }
            sqlColumnSet.addColumn(param.getName(), SQLTypeToken.getTypeById(param.getType()), param.generateDefaultValue());
        }
        return sqlColumnSet;
    }

    public static SQLQuery createQuery(String sqlScript) throws SQLQueryParseException, SQLQueryValidationException {
        SQLQueryFactory.checkContext();
        if (sqlScript == null) {
            throw new NullPointerException();
        }
        return SQLQueryFactory.parse(null, sqlScript);
    }

    public static SQLQueryBatch createBatch(String sqlScript) throws SQLQueryParseException, SQLQueryValidationException {
        SQLQueryFactory.checkContext();
        if (sqlScript == null) {
            throw new NullPointerException();
        }
        ArrayList<String> saveStrings = new ArrayList<String>();
        String sql = SQLQueryFactory.extractStrings(sqlScript, saveStrings);
        ArrayList<String> scripts = new ArrayList<String>();
        int i = 0;
        StringTokenizer proc = new StringTokenizer(sql, ";", false);
        while (proc.hasMoreTokens()) {
            String[] bricks;
            String token = proc.nextToken().trim();
            if ("".equals(token)) continue;
            StringBuffer script = new StringBuffer();
            for (String brick : bricks = token.split("\\s")) {
                if ("?".equals(brick)) {
                    script.append((String)saveStrings.get(i++));
                } else {
                    script.append(brick);
                }
                script.append(" ");
            }
            scripts.add(script.toString().trim());
        }
        ArrayList<SQLQuery> objects = new ArrayList<SQLQuery>();
        for (String script : scripts) {
            SQLQuery object = SQLQueryFactory.createQuery(script);
            objects.add(object);
        }
        return new SQLQueryBatch(objects);
    }

    public static String toSQL(SQLQuery object) throws SQLQueryParseException, SQLQueryValidationException {
        SQLQueryFactory.checkContext();
        ArrayList<Object> bricks = new ArrayList<Object>();
        SQLQueryFactory.parse(bricks, object);
        StringBuffer sql = new StringBuffer();
        for (Object e : bricks) {
            if (e instanceof String) {
                sql.append((String)e).append(" ");
                continue;
            }
            if (!(e instanceof SQLQueryParameter)) continue;
            sql.append("? ");
        }
        Object out = sql.toString();
        if (object.isCallable() && !((String)out).trim().startsWith("{")) {
            out = "{" + (String)out + "}";
        }
        return out;
    }

    private static String renderCallable(SQLQuery object) throws SQLQueryParseException, SQLQueryValidationException {
        ArrayList<Object> bricks = new ArrayList<Object>();
        SQLQueryFactory.parse(bricks, object);
        StringBuffer sql = new StringBuffer();
        for (Object e : bricks) {
            if (e instanceof String) {
                sql.append((String)e).append(" ");
                continue;
            }
            if (!(e instanceof SQLQueryParameter)) continue;
            SQLQueryParameter param = (SQLQueryParameter)e;
            if (param.getMode() == SQLQueryParameterMode.OUT.getMode()) {
                sql.append(param.getName()).append(" ");
                continue;
            }
            String value = param.renderValue();
            if (value != null) {
                sql.append(value).append(" ");
                continue;
            }
            sql.append("NULL ");
        }
        return "{" + sql.toString().trim() + "}";
    }

    private static String renderUpdateQuery(SQLQuery object) throws SQLQueryParseException, SQLQueryValidationException {
        String setClause;
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> setParameters = new ArrayList<Object>();
        ArrayList<Object> whereClauseParameters = new ArrayList<Object>();
        int pos = object.getSqlScript().toUpperCase().indexOf(SET_CLAUSE);
        if (pos == -1) {
            throw new SQLQueryParseException(5043, "Update query does not have 'set' statement.");
        }
        String updatedTable = object.getSqlScript().substring(0, pos);
        int wherePos = object.getSqlScript().toUpperCase().indexOf(WHERE_CLAUSE, pos);
        String whereClause = null;
        if (wherePos != -1) {
            setClause = object.getSqlScript().substring(pos + 1 + SET_CLAUSE.length(), wherePos);
            whereClause = object.getSqlScript().substring(wherePos + 1 + WHERE_CLAUSE.length());
        } else {
            setClause = object.getSqlScript().substring(pos + 1 + SET_CLAUSE.length());
        }
        Iterator<SQLQueryParameter> iter = object.getParameterIterator();
        int counter = 0;
        while (iter.hasNext()) {
            SQLQueryParameter param = iter.next();
            if (!param.isValueSet()) continue;
            SQLQueryParameter temp = new SQLQueryParameter(param.getName(), param.getType(), param.getTypeName(), param.isNullable(), param.getDefaultValue(), param.getValue(), param.getLength(), param.getPrecision(), param.getScale(), param.isSearchable(), param.isReturnCode(), ++counter, param.getMode());
            if (setClause.contains(temp.getName())) {
                setParameters.add(temp);
                continue;
            }
            if (whereClause == null || !whereClause.contains(temp.getName())) continue;
            whereClauseParameters.add(temp);
        }
        sql.append(updatedTable);
        sql.append(SET_CLAUSE).append(' ');
        boolean first = true;
        for (SQLQueryParameter sQLQueryParameter : setParameters) {
            if (!first) {
                sql.append(',');
            } else {
                first = false;
            }
            sql.append(sQLQueryParameter.getName() + " = " + sQLQueryParameter.renderValue());
        }
        if (whereClauseParameters.size() > 0) {
            sql.append(' ').append(WHERE_CLAUSE).append(' ');
            first = true;
            for (SQLQueryParameter sQLQueryParameter : whereClauseParameters) {
                if (!first) {
                    sql.append(" AND ");
                } else {
                    first = false;
                }
                sql.append(sQLQueryParameter.getName() + " = " + sQLQueryParameter.renderValue());
            }
        }
        String sqlScript = sql.toString();
        return sql.toString().trim();
    }

    public static String renderQuery(SQLQuery object) throws SQLQueryParseException, SQLQueryValidationException {
        SQLQueryFactory.checkContext();
        if (object.isCallable()) {
            return SQLQueryFactory.renderCallable(object);
        }
        if (object.getQueryType() == SQLQueryType.UPDATE.getId()) {
            return SQLQueryFactory.renderUpdateQuery(object);
        }
        ArrayList<Object> bricks = new ArrayList<Object>();
        SQLQueryFactory.parse(bricks, object);
        StringBuffer sql = new StringBuffer();
        for (Object e : bricks) {
            if (e instanceof String) {
                sql.append((String)e).append(" ");
                continue;
            }
            if (!(e instanceof SQLQueryParameter)) continue;
            SQLQueryParameter param = (SQLQueryParameter)e;
            String value = param.renderValue();
            if (value != null) {
                sql.append(value).append(" ");
                continue;
            }
            sql.append("NULL ");
        }
        return sql.toString();
    }

    public static String renderBatch(SQLQueryBatch batch) throws SQLQueryParseException, SQLQueryValidationException {
        SQLQueryFactory.checkContext();
        StringBuffer result = new StringBuffer();
        Iterator<SQLQuery> iter = batch.getObjectIterator();
        while (iter.hasNext()) {
            SQLQuery query = iter.next();
            String temp = SQLQueryFactory.renderQuery(query);
            result.append(temp).append(";\n");
        }
        return result.toString();
    }

    public static CallableStatement createCallableStatement(Connection connection, SQLQuery object) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        SQLQueryFactory.checkContext();
        if (!object.isCallable()) {
            throw new SQLQueryValidationException(5064, "SQL query is not a Callable Statement (stored procedure).");
        }
        return (CallableStatement)SQLQueryFactory.createStatement(connection, object);
    }

    public static PreparedStatement createPreparedStatement(Connection connection, SQLQuery object) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        SQLQueryFactory.checkContext();
        if (object.isCallable()) {
            throw new SQLQueryValidationException(5063, "SQL query is a Callable Statement and cannot be prepared.");
        }
        if (object.getQueryType() == SQLQueryType.UPDATE.getId()) {
            return (PreparedStatement)SQLQueryFactory.createStatementForUpdate(connection, object);
        }
        return (PreparedStatement)SQLQueryFactory.createStatement(connection, object);
    }

    /*
     * WARNING - void declaration
     */
    protected static Statement createStatement(Connection connection, SQLQuery object) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        void var6_9;
        ArrayList<Object> bricks = new ArrayList<Object>();
        SQLQueryFactory.parse(bricks, object);
        StringBuffer sql = new StringBuffer();
        ArrayList<SQLQueryParameter> parameters = new ArrayList<SQLQueryParameter>();
        for (Object e : bricks) {
            if (e instanceof String) {
                sql.append((String)e).append(" ");
                continue;
            }
            if (!(e instanceof SQLQueryParameter)) continue;
            SQLQueryParameter param = (SQLQueryParameter)e;
            parameters.add(param);
            sql.append("? ");
        }
        Object sqlScript = sql.toString();
        Trace.logDebug(SQLQueryFactory.class, "Prepared Statement SQL : " + (String)sqlScript);
        try {
            if (object.isCallable()) {
                sqlScript = "{" + (String)sqlScript + "}";
                CallableStatement callableStatement = connection.prepareCall((String)sqlScript);
            } else {
                PreparedStatement preparedStatement = connection.prepareStatement((String)sqlScript);
            }
            for (SQLQueryParameter param : parameters) {
                param.prepareValue((PreparedStatement)var6_9);
            }
        }
        catch (SQLException e) {
            throw new DatabaseSQLException(e);
        }
        return var6_9;
    }

    protected static Statement createStatementForUpdate(Connection connection, SQLQuery object) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        PreparedStatement statement;
        String setClause;
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> setParameters = new ArrayList<Object>();
        ArrayList<Object> whereClauseParameters = new ArrayList<Object>();
        int pos = object.getSqlScript().toUpperCase().indexOf(SET_CLAUSE);
        if (pos == -1) {
            throw new SQLQueryParseException(5043, "Update query does not have 'set' statement.");
        }
        String updatedTable = object.getSqlScript().substring(0, pos);
        int wherePos = object.getSqlScript().toUpperCase().indexOf(WHERE_CLAUSE, pos);
        String whereClause = null;
        if (wherePos != -1) {
            setClause = object.getSqlScript().substring(pos + 1 + SET_CLAUSE.length(), wherePos);
            whereClause = object.getSqlScript().substring(wherePos + 1 + WHERE_CLAUSE.length());
        } else {
            setClause = object.getSqlScript().substring(pos + 1 + SET_CLAUSE.length());
        }
        Iterator<SQLQueryParameter> iter = object.getParameterIterator();
        int counter = 0;
        while (iter.hasNext()) {
            SQLQueryParameter param = iter.next();
            if (!param.isValueSet()) continue;
            SQLQueryParameter temp = new SQLQueryParameter(param.getName(), param.getType(), param.getTypeName(), param.isNullable(), param.getDefaultValue(), param.getValue(), param.getLength(), param.getPrecision(), param.getScale(), param.isSearchable(), param.isReturnCode(), ++counter, param.getMode());
            param.clearIsSetFlag();
            if (setClause.contains(temp.getName())) {
                setParameters.add(temp);
                continue;
            }
            if (whereClause == null || !whereClause.contains(temp.getName())) continue;
            whereClauseParameters.add(temp);
        }
        sql.append(updatedTable);
        sql.append(SET_CLAUSE).append(' ');
        if (setParameters.size() > 0) {
            boolean first = true;
            for (SQLQueryParameter sQLQueryParameter : setParameters) {
                if (!first) {
                    sql.append(',');
                } else {
                    first = false;
                }
                sql.append(sQLQueryParameter.getName() + " = ? ");
            }
        } else {
            sql.append(setClause);
        }
        if (whereClauseParameters.size() > 0) {
            sql.append(' ').append(WHERE_CLAUSE).append(' ');
            boolean first = true;
            for (SQLQueryParameter sQLQueryParameter : whereClauseParameters) {
                if (!first) {
                    sql.append(" AND ");
                } else {
                    first = false;
                }
                sql.append(sQLQueryParameter.getName() + " = ? ");
            }
        } else if (whereClause != null && whereClause.length() > 0) {
            sql.append(' ').append(WHERE_CLAUSE).append(' ').append(whereClause);
        }
        Object sqlScript = sql.toString();
        Trace.logDebug(SQLQueryFactory.class, "Prepared Statement SQL : " + (String)sqlScript);
        try {
            if (object.isCallable()) {
                sqlScript = "{" + (String)sqlScript + "}";
                statement = connection.prepareCall((String)sqlScript);
            } else {
                statement = connection.prepareStatement((String)sqlScript);
            }
            for (SQLQueryParameter sQLQueryParameter : setParameters) {
                sQLQueryParameter.prepareValue(statement);
            }
            for (SQLQueryParameter sQLQueryParameter : whereClauseParameters) {
                sQLQueryParameter.prepareValue(statement);
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseSQLException(sQLException);
        }
        return statement;
    }

    public static SQLQuery createForCall(Connection connection, String procedure) throws SQLQueryValidationException, DatabaseSQLException, SQLQueryParseException {
        SQLQueryFactory.checkContext();
        List<SQLQueryParameter> params = DatabaseDescriptor.getStoredProcedureParameters(procedure, connection);
        StringBuffer str = new StringBuffer();
        str.append("call ").append(procedure).append("(");
        boolean hasReturnCode = false;
        int i = 0;
        int last = params.size() - 1;
        for (SQLQueryParameter param : params) {
            if (i == 0 && param.isReturnCode()) {
                hasReturnCode = true;
                ++i;
                continue;
            }
            String template = SQLQuerySyntax.getSyntax().generateParameter(param.getName(), SQLTypeToken.getTypeById(param.getType()), param.getTypeName(), param.generateDefaultValue(), SQLQueryParameterMode.getMode(param.getMode()));
            str.append(template);
            if (i < last) {
                str.append(", ");
            }
            ++i;
        }
        str.append(")");
        Object sql = str.toString();
        SQLQueryType type = SQLQueryType.CALL;
        if (hasReturnCode) {
            sql = "@ReturnCode = " + (String)sql;
            type = SQLQueryType.CALL_WITH_RETURN;
        }
        SQLQuery object = new SQLQuery("{" + (String)sql + "}", type.getId());
        for (SQLQueryParameter param : params) {
            object.getParameters().add(param);
        }
        return object;
    }

    public static SQLQuery createForSelect(Connection connection, String table) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        return SQLQueryFactory.createForSelect(connection, table, null, null);
    }

    public static SQLQuery createForSelect(Connection connection, String table, String[] selectColumns) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        return SQLQueryFactory.createForSelect(connection, table, selectColumns, null);
    }

    public static SQLQuery createForSelect(Connection connection, String table, String[] selectColumns, String[] whereColumns) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        SQLQueryFactory.checkContext();
        SQLTableName tableName = SQLTableName.parse(table);
        StringBuffer str = new StringBuffer();
        str.append("SELECT ");
        if (selectColumns != null) {
            for (int i = 0; i < selectColumns.length; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(selectColumns[i]);
            }
        } else {
            str.append(" * ");
        }
        str.append(" FROM ").append(tableName);
        if (whereColumns == null) {
            return new SQLQuery(str.toString(), SQLQueryType.SELECT.getId());
        }
        List<SQLQueryParameter> whereParams = SQLQueryFactory.appendWhereClause(connection, tableName, whereColumns, str, 1);
        SQLQuery sqlQuery = new SQLQuery(str.toString(), SQLQueryType.SELECT.getId());
        for (SQLQueryParameter param : whereParams) {
            sqlQuery.getParameters().add(param);
        }
        return sqlQuery;
    }

    public static SQLQuery createForUpdate(Connection connection, String table) throws SQLQueryValidationException, SQLQueryParseException, DatabaseSQLException {
        return SQLQueryFactory.createForUpdate(connection, table, null, null);
    }

    public static SQLQuery createForUpdate(Connection connection, String table, String[] updateColumns) throws SQLQueryValidationException, SQLQueryParseException, DatabaseSQLException {
        return SQLQueryFactory.createForUpdate(connection, table, updateColumns, null);
    }

    public static SQLQuery createForUpdate(Connection connection, String table, String[] updateColumns, String[] whereColumns) throws SQLQueryValidationException, SQLQueryParseException, DatabaseSQLException {
        SQLQueryFactory.checkContext();
        SQLTableName tableName = SQLTableName.parse(table);
        List<SQLQueryParameter> updateParams = DatabaseDescriptor.getTableColumns(tableName, connection, updateColumns, 1);
        StringBuffer str = new StringBuffer();
        str.append("UPDATE ").append(tableName).append(" SET \n\t");
        int i = 0;
        int last = updateParams.size() - 1;
        for (SQLQueryParameter param : updateParams) {
            str.append(param.getName()).append(" = ");
            String template = SQLQuerySyntax.getSyntax().generateParameter(param.getName(), SQLTypeToken.getTypeById(param.getType()), param.getTypeName(), param.generateDefaultValue(), null);
            str.append(template);
            if (i < last) {
                str.append(", \n\t");
            }
            ++i;
        }
        if (whereColumns == null) {
            SQLQuery sqlQuery = new SQLQuery(str.toString(), SQLQueryType.UPDATE.getId());
            sqlQuery.getParameters().add(updateParams);
            return sqlQuery;
        }
        List<SQLQueryParameter> whereParams = SQLQueryFactory.appendWhereClause(connection, tableName, whereColumns, str, updateParams.size() + 1);
        SQLQuery sqlQuery = new SQLQuery(str.toString(), SQLQueryType.UPDATE.getId());
        sqlQuery.getParameters().add(updateParams);
        sqlQuery.getParameters().add(whereParams);
        return sqlQuery;
    }

    public static SQLQuery createForUpdate(String table, SQLColumnSet columnSet) throws SQLQueryParseException, SQLQueryValidationException {
        SQLQueryFactory.checkContext();
        SQLTableName tableName = SQLTableName.parse(table);
        StringBuffer str = new StringBuffer();
        str.append("UPDATE ").append(tableName).append(" SET \n\t");
        ArrayList<SQLQueryParameter> updateParams = new ArrayList<SQLQueryParameter>();
        for (int i = 1; i <= columnSet.getColumnsCount(); ++i) {
            SQLColumn column = columnSet.getColumn(i);
            SQLQueryParameter param = new SQLQueryParameter(column.getName(), column.getType().getId(), null, true, null, null, 0, 0, 0, false, false, i, SQLQueryParameterMode.IN.getMode());
            updateParams.add(param);
            str.append(param.getName()).append(" = ");
            String template = SQLQuerySyntax.getSyntax().generateParameter(param.getName(), SQLTypeToken.getTypeById(param.getType()), param.getTypeName(), param.generateDefaultValue(), null);
            str.append(template);
            if (i >= columnSet.getColumnsCount()) continue;
            str.append(", \n\t");
        }
        SQLQuery sqlQuery = new SQLQuery(str.toString(), SQLQueryType.UPDATE.getId());
        sqlQuery.getParameters().add(updateParams);
        return sqlQuery;
    }

    public static SQLQuery createForDelete(Connection connection, String table) throws SQLQueryValidationException, SQLQueryParseException, DatabaseSQLException {
        return SQLQueryFactory.createForDelete(connection, table, null);
    }

    public static SQLQuery createForDelete(Connection connection, String table, String[] whereColumns) throws SQLQueryValidationException, SQLQueryParseException, DatabaseSQLException {
        SQLQueryFactory.checkContext();
        SQLTableName tableName = SQLTableName.parse(table);
        StringBuffer str = new StringBuffer();
        str.append("DELETE FROM ").append(tableName);
        if (whereColumns == null) {
            return new SQLQuery(str.toString(), SQLQueryType.DELETE.getId());
        }
        List<SQLQueryParameter> whereParams = SQLQueryFactory.appendWhereClause(connection, tableName, whereColumns, str, 1);
        SQLQuery sqlQuery = new SQLQuery(str.toString(), SQLQueryType.DELETE.getId());
        sqlQuery.getParameters().add(whereParams);
        return sqlQuery;
    }

    public static SQLQuery createForInsert(Connection connection, String table) throws SQLQueryValidationException, DatabaseSQLException, SQLQueryParseException {
        SQLQueryFactory.checkContext();
        SQLTableName tableName = SQLTableName.parse(table);
        List<SQLQueryParameter> params = DatabaseDescriptor.getTableColumns(tableName, connection, null, 1);
        StringBuffer str = new StringBuffer();
        str.append("INSERT INTO ").append(tableName).append(" (\n\t");
        int i = 0;
        int last = params.size() - 1;
        for (SQLQueryParameter param : params) {
            str.append(param.getName());
            if (i < last) {
                str.append(", \n\t");
            }
            ++i;
        }
        str.append("\n) VALUES (\n\t");
        i = 0;
        last = params.size() - 1;
        for (SQLQueryParameter param : params) {
            String template = SQLQuerySyntax.getSyntax().generateParameter(param.getName(), SQLTypeToken.getTypeById(param.getType()), param.getTypeName(), param.generateDefaultValue(), null);
            str.append(template);
            if (i < last) {
                str.append(", \n\t");
            }
            ++i;
        }
        str.append("\n)");
        SQLQuery object = new SQLQuery(str.toString(), SQLQueryType.INSERT.getId());
        object.getParameters().add(params);
        return object;
    }

    public static SQLQuery createForDynamicSQL(Connection connection, String query) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        return SQLDynamicQueryParser.createForDynamicSQL(connection, query);
    }

    @Deprecated
    public static void saveQueryObject(SQLQuery sqo) throws SQLQueryException {
        SQLQueryFactory.checkContext();
    }

    public static void saveQueryObject(String workingDir, SQLQuery query) throws SQLQueryException {
        SQLQueryFactory.checkContext();
        try {
            XSerializer xf;
            if (SQLQueryFactory.getContextType().equals((Object)FabricContextType.CLIENT)) {
                xf = ClientContext.getInstance().getXSerializer();
            } else if (SQLQueryFactory.getContextType().equals((Object)FabricContextType.RUNTIME)) {
                xf = RuntimeContext.getInstance().getXSerializer();
            } else {
                throw new RuntimeException("Application engine context is undefined.");
            }
            Trace.logDebug(SQLQueryFactory.class, "Saving query object resource: SQLQuery." + query.getName() + ".xdo");
            String fileName = workingDir + System.getProperty("file.separator") + "SQLQuery." + query.getName() + ".xdo";
            String xdoc = xf.serialize(query);
            File dfoFile = FileIOUtils.newFile(fileName);
            RandomAccessFile artifact = new RandomAccessFile(dfoFile, "rw");
            FileChannel afc = artifact.getChannel();
            Trace.logDebug(SQLQueryFactory.class, "Aquiring a lock on file resource: " + dfoFile.getAbsolutePath());
            FileLock flock = afc.lock();
            artifact.writeBytes(xdoc);
            artifact.getFD().sync();
            flock.release();
            artifact.close();
            Trace.logDebug(SQLQueryFactory.class, "Done.");
        }
        catch (Exception exception) {
            throw new SQLQueryException(5002, (Throwable)exception);
        }
    }

    public static SQLQuery loadQueryObject(String workingDir, String queryName) throws SQLQueryException {
        SQLQueryFactory.checkContext();
        try {
            XSerializer xf;
            if (SQLQueryFactory.getContextType().equals((Object)FabricContextType.CLIENT)) {
                xf = ClientContext.getInstance().getXSerializer();
            } else if (SQLQueryFactory.getContextType().equals((Object)FabricContextType.RUNTIME)) {
                xf = RuntimeContext.getInstance().getXSerializer();
            } else {
                throw new RuntimeException("Application engine context is undefined.");
            }
            Trace.logDebug(SQLQueryFactory.class, "Loading SQL query SQLQuery." + queryName + ".xdo..");
            File scoFile = FileIOUtils.openFile(workingDir + System.getProperty("file.separator") + "SQLQuery." + queryName + ".xdo");
            RandomAccessFile artifact = new RandomAccessFile(scoFile, "rw");
            FileChannel afc = artifact.getChannel();
            FileLock flock = afc.lock();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(artifact.getFD()));
            byte[] bytes = new byte[(int)scoFile.length()];
            bis.read(bytes);
            flock.release();
            bis.close();
            artifact.close();
            return (SQLQuery)xf.deserialize("SQLQuery", bytes);
        }
        catch (Exception ex) {
            throw new SQLQueryException(5002, (Throwable)ex);
        }
    }

    public static List<RowSet> execute(SQLQuery query, int queryTimeout, Connection connection) throws DatabaseSQLException, SQLQueryParseException, SQLQueryValidationException, SQLQueryException {
        List<RowSet> rowSets = null;
        if (query.getSqlScript() == null || query.getSqlScript().isEmpty()) {
            throw new SQLQueryException(5004, "SQL script is null or empty.");
        }
        if (query.getQueryType() == -99) {
            throw new SQLQueryException(5043, "SQL query type not set.");
        }
        Statement statement = null;
        try {
            if (query.getSqlScript().toLowerCase().startsWith("begin tran") || query.getSqlScript().toLowerCase().startsWith("commit")) {
                connection.commit();
            } else if (query.getSqlScript().toLowerCase().startsWith("rollback")) {
                connection.rollback();
            } else if (query.isCallable()) {
                statement = SQLQueryFactory.createCallableStatement(connection, query);
                statement.setQueryTimeout(queryTimeout);
                rowSets = SQLQueryFactory.executeWithMutlipleResultSets((PreparedStatement)statement, query);
            } else {
                statement = SQLQueryFactory.createPreparedStatement(connection, query);
                statement.setQueryTimeout(queryTimeout);
                rowSets = SQLQueryFactory.executeWithMutlipleResultSets((PreparedStatement)statement, query);
            }
        }
        catch (SQLException error) {
            Trace.logException(SQLQueryFactory.class, error, true);
            throw new DatabaseSQLException(error);
        }
        finally {
            if (statement != null) {
                try {
                    if (Trace.isDebugEnabled(SQLQueryFactory.class)) {
                        Trace.logDebug(SQLQueryFactory.class, "Closing statement...");
                    }
                    statement.close();
                }
                catch (SQLException error) {
                    Trace.logException(SQLQueryFactory.class, error, true);
                }
            }
        }
        return rowSets;
    }

    private static List<RowSet> executeWithMutlipleResultSets(PreparedStatement statement, SQLQuery query) throws SQLException {
        ArrayList<RowSet> rowSets = new ArrayList<RowSet>();
        boolean hasResultSet = statement.execute();
        int updateCount = -1;
        if (Trace.isDebugEnabled(SQLQueryFactory.class)) {
            Trace.logDebug(SQLQueryFactory.class, "Executed statement returned " + (hasResultSet ? "ResultSet" : "UpdateCount"));
        }
        RowSet result = null;
        do {
            if (hasResultSet) {
                if (Trace.isDebugEnabled(SQLQueryFactory.class)) {
                    Trace.logDebug(SQLQueryFactory.class, "Adding result set...");
                }
                result = new RowSetFactory().createRowSet(statement.getResultSet());
                rowSets.add(result);
                continue;
            }
            updateCount = statement.getUpdateCount();
            if (updateCount <= -1) continue;
            if (Trace.isDebugEnabled(SQLQueryFactory.class)) {
                Trace.logDebug(SQLQueryFactory.class, "Adding update count...");
            }
            result = new RowSet(new String[]{"UpdateCount"}, new Object[]{updateCount});
            rowSets.add(result);
        } while ((hasResultSet = statement.getMoreResults()) || updateCount > -1);
        if (statement instanceof CallableStatement) {
            if (result == null) {
                result = new RowSet();
                rowSets.add(result);
            }
            if (Trace.isDebugEnabled(SQLQueryFactory.class)) {
                Trace.logDebug(SQLQueryFactory.class, "Populating out parameters...");
            }
            result.populateOutParameters((CallableStatement)statement, query.getParameters());
        }
        if (rowSets.size() > 1) {
            Trace.logDebug(SQLQueryFactory.class, "Multiple row set detected during SQL query execution.");
        }
        return rowSets;
    }

    public static int execute(SQLQueryBatch batch, int queryTimeout, Connection connection) throws DatabaseSQLException, SQLQueryParseException, SQLQueryValidationException, SQLQueryException {
        int executedQueries;
        if (batch == null) {
            throw new SQLQueryException(5004, "SQL query batch is empty.");
        }
        try {
            Statement statement = connection.createStatement();
            statement.setQueryTimeout(queryTimeout);
            int counter = 0;
            Iterator<SQLQuery> iter = batch.getObjectIterator();
            while (iter.hasNext()) {
                SQLQuery query = iter.next();
                String temp = SQLQueryFactory.renderQuery(query);
                statement.execute(temp);
                ++counter;
            }
            executedQueries = counter;
            statement.close();
        }
        catch (SQLException error) {
            throw new DatabaseSQLException(error);
        }
        return executedQueries;
    }

    public static List<SemanticType> getSupportedTypes() {
        ArrayList<SemanticType> types = new ArrayList<SemanticType>();
        SQLQuery query = new SQLQuery();
        SemanticType type = new SemanticType("SQLQuery", query.getClass().getName());
        type.setDescription("An object that holds an SQL Query.");
        type.setAncestorType("StructuredDataObject");
        type.setInterface(false);
        types.add(type);
        SQLQueryParameter parameter = new SQLQueryParameter();
        type = new SemanticType("SQLQueryParameter", parameter.getClass().getName());
        type.setDescription("An object that holds an SQL Query Parameter.");
        type.setAncestorType("StructuredDataObject");
        type.setInterface(false);
        types.add(type);
        SQLQueryBatch batch = new SQLQueryBatch();
        type = new SemanticType("SQLQueryBatch", batch.getClass().getName());
        type.setDescription("An object that holds a group(batch) of SQL Queries.");
        type.setAncestorType("StructuredDataObject");
        type.setInterface(false);
        types.add(type);
        return types;
    }

    private static SQLQuery parse(List<Object> sqlBricks, Object inObject) throws SQLQueryParseException, SQLQueryValidationException {
        return SQLQuerySyntax.getSyntax().parse(sqlBricks, inObject);
    }

    private static String extractStrings(String sql, List<String> stringList) {
        char quoteChar = '\u0000';
        StringBuffer sb = new StringBuffer();
        StringBuffer sbString = null;
        int i = 0;
        while (i < sql.length()) {
            char c = sql.charAt(i++);
            if (quoteChar == '\u0000') {
                if (c == '\"' || c == '\'') {
                    quoteChar = c;
                    sbString = new StringBuffer();
                    sbString.append(c);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (quoteChar == c) {
                quoteChar = '\u0000';
                sbString.append(c);
                stringList.add(sbString.toString());
                sb.append('?');
                continue;
            }
            sbString.append(c);
        }
        return sb.toString();
    }

    private static List<SQLQueryParameter> appendWhereClause(Connection connection, SQLTableName table, String[] whereColumns, StringBuffer str, int ordinal) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        List<SQLQueryParameter> whereParams = DatabaseDescriptor.getTableColumns(table, connection, whereColumns, ordinal);
        str.append("\nWHERE\n\t");
        int i = 0;
        int last = whereParams.size() - 1;
        for (SQLQueryParameter param : whereParams) {
            str.append(param.getName()).append(" = ");
            String template = SQLQuerySyntax.getSyntax().generateParameter(param.getName(), SQLTypeToken.getTypeById(param.getType()), param.getTypeName(), param.generateDefaultValue(), null);
            str.append(template);
            if (i < last) {
                str.append(" AND \n");
            }
            ++i;
        }
        return whereParams;
    }
}

