/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.slex.slang.SemanticQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SQLQueryBatch
extends CloneableDataObject
implements SemanticQuery {
    private List<SQLQuery> objects = null;
    private String queryName = "";
    private String queryDescription = "";

    public SQLQueryBatch() {
        this.objects = new ArrayList<SQLQuery>();
    }

    public void setName(String name) {
        this.queryName = name;
    }

    @Override
    public String getName() {
        return this.queryName;
    }

    public void setDescription(String description) {
        this.queryDescription = description;
    }

    @Override
    public String getDescription() {
        return this.queryDescription;
    }

    public SQLQueryBatch(List<SQLQuery> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        this.objects = objects;
        int ordinal = 0;
        for (SQLQuery object : this.objects) {
            object.setBatchOrdinal(ordinal++);
        }
    }

    public void addQuery(SQLQuery query) {
        query.setBatchOrdinal(this.objects.size());
        this.objects.add(query);
    }

    public SQLQuery getQuery(int ordinal) {
        for (SQLQuery object : this.objects) {
            if (object.getBatchOrdinal() != ordinal) continue;
            return object;
        }
        return null;
    }

    public String getQueryScript() {
        StringBuffer buffer = new StringBuffer();
        for (SQLQuery object : this.objects) {
            buffer.append(object.getSqlScript());
        }
        return buffer.toString();
    }

    public List<SQLQuery> getObjects() {
        return Collections.unmodifiableList(this.sortObjects());
    }

    public Iterator<SQLQuery> getObjectIterator() {
        return this.sortObjects().iterator();
    }

    private List<SQLQuery> sortObjects() {
        Collections.sort(this.objects, new Comparator<SQLQuery>(this){

            @Override
            public int compare(SQLQuery o1, SQLQuery o2) {
                return o1.getBatchOrdinal() - o2.getBatchOrdinal();
            }
        });
        return this.objects;
    }
}

