/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.SQLQueryParameterList;
import com.streamscape.sdo.sql.enums.SQLQueryType;
import com.streamscape.slex.slang.SemanticQuery;
import java.util.Iterator;

public class SQLQuery
extends CloneableDataObject
implements SemanticQuery {
    public static String SQL_QUERY_OBJECTS_NAMESPACE = "/db/SQLQuery";
    private String sqlScript = "";
    private int queryType = -99;
    private int batchOrdinal = -99;
    private String queryName = "";
    private String queryDescription = "";
    private SQLQueryParameterList parameters = null;

    public SQLQuery() {
        this.parameters = new SQLQueryParameterList();
    }

    public SQLQuery(String sqlScript, int queryType) {
        this.sqlScript = sqlScript;
        this.queryType = queryType;
        this.parameters = new SQLQueryParameterList();
    }

    public SQLQueryParameter getParameter(String name) throws SQLQueryValidationException {
        this.assertState();
        return this.parameters.get(name);
    }

    public SQLQueryParameter getParameter(int ordinal) throws SQLQueryValidationException {
        this.assertState();
        return this.parameters.get(ordinal);
    }

    public Iterator<SQLQueryParameter> getParameterIterator() {
        this.assertState();
        return this.parameters.iterator();
    }

    public void setParameter(String name, String value) throws SQLQueryValidationException {
        this.assertState();
        this.parameters.set(name, value);
    }

    public void setParameter(String name, Object value) throws SQLQueryValidationException {
        this.assertState();
        this.parameters.set(name, value);
    }

    public void setParameter(int ordinal, String value) throws SQLQueryValidationException {
        this.assertState();
        this.parameters.set(ordinal, value);
    }

    public SQLQueryParameterList getParameters() {
        return this.parameters;
    }

    public void setName(String name) {
        this.queryName = name;
    }

    @Override
    public String getName() {
        return this.queryName;
    }

    public void setDescription(String description) {
        this.queryDescription = description;
    }

    @Override
    public String getDescription() {
        return this.queryDescription;
    }

    public String getSqlScript() {
        return this.sqlScript;
    }

    public boolean isCallable() {
        return SQLQueryType.isCallable(this.queryType);
    }

    public void setQueryType(int sqlQueryType) {
        this.queryType = sqlQueryType;
    }

    public int getQueryType() {
        return this.queryType;
    }

    @Override
    public Object clone() {
        SQLQuery clone = (SQLQuery)super.clone();
        if (this.parameters != null) {
            clone.parameters = (SQLQueryParameterList)this.parameters.clone();
        }
        return clone;
    }

    protected int getBatchOrdinal() {
        return this.batchOrdinal;
    }

    protected void setBatchOrdinal(int batchOrdinal) {
        this.batchOrdinal = batchOrdinal;
    }

    protected void assertState() throws IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException("SQL Query object is not initialized.");
        }
    }
}

