/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql;

import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sdo.excp.SQLQueryParseException;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.DatabaseDescriptor;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.SQLTableName;
import com.streamscape.sdo.sql.enums.SQLQueryType;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sdo.sql.syntax.SQLQuerySyntax;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

public class SQLDynamicQueryParser {
    public static SQLQuery createForDynamicSQL(Connection connection, String query) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        ArrayList<String> queryBricks;
        StringBuffer queryBuffer = new StringBuffer(query = query.trim());
        String queryType = SQLDynamicQueryParser.getNextWord(queryBuffer, null, queryBricks = new ArrayList<String>());
        if (queryType == null) {
            throw new SQLQueryParseException(5044, "Invalid query format.");
        }
        if (queryType.equalsIgnoreCase("insert")) {
            return SQLDynamicQueryParser.createForDynamicInsert(connection, queryBuffer, queryBricks);
        }
        if (queryType.equalsIgnoreCase("delete")) {
            return SQLDynamicQueryParser.createForDynamicDelete(connection, queryBuffer, queryBricks);
        }
        if (queryType.equalsIgnoreCase("update")) {
            return SQLDynamicQueryParser.createForDynamicUpdate(connection, queryBuffer, queryBricks);
        }
        if (queryType.equalsIgnoreCase("select")) {
            return SQLDynamicQueryParser.createForDynamicSelect(connection, queryBuffer, queryBricks);
        }
        throw new SQLQueryParseException(5044, "Invalid query format, unsupported query " + queryType);
    }

    private static SQLQuery createForDynamicInsert(Connection connection, StringBuffer str, List<String> bricks) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        String word = SQLDynamicQueryParser.getNextWord(str, null, bricks);
        if (word == null || !word.equalsIgnoreCase("into")) {
            throw new SQLQueryParseException(5044, "Invalid query format, expected 'into' word");
        }
        String tableName = SQLDynamicQueryParser.getNextWord(str, "(", bricks);
        if (tableName == null) {
            throw new SQLQueryParseException(5044, "Invalid query format, expected table name");
        }
        ArrayList<String> insertColumns = new ArrayList<String>();
        if (bricks.get(bricks.size() - 1).equals("(")) {
            int i;
            char c = '\u0000';
            StringBuffer column = new StringBuffer();
            for (i = 0; i < str.length(); ++i) {
                c = str.charAt(i);
                if (c == ',' || c == ')') {
                    if (column.equals("")) {
                        throw new SQLQueryParseException(5044, "Invalid query format, empty column name");
                    }
                    insertColumns.add(column.toString().trim());
                    column = new StringBuffer();
                    if (c != 41) continue;
                    break;
                }
                column.append(c);
            }
            if (c != ')') {
                throw new SQLQueryParseException(5044, "Invalid query format, expected ')' after insert column list");
            }
            if (bricks != null) {
                bricks.add(str.substring(0, i + 1));
            }
            str.delete(0, i + 1);
        }
        if ((word = SQLDynamicQueryParser.getNextWord(str, "(", bricks)) == null || !word.equalsIgnoreCase("values")) {
            throw new SQLQueryParseException(5044, "Invalid query format, expected 'values' word");
        }
        if (!bricks.get(bricks.size() - 1).equals("(")) {
            throw new SQLQueryParseException(5044, "Invalid query format, expected '(' symbol after 'values'");
        }
        ArrayList<Object> insertValues = new ArrayList<Object>();
        char c = '\u0000';
        StringBuffer stringValue = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            c = str.charAt(i);
            char quoteChar = '\u0000';
            if (c == '\'' || c == '\"') {
                if (quoteChar == '\u0000') {
                    quoteChar = c;
                } else if (quoteChar == c) {
                    quoteChar = '\u0000';
                }
                stringValue.append(c);
                continue;
            }
            if (quoteChar == '\u0000' && (c == ',' || c == ')')) {
                insertValues.add(stringValue.toString().trim());
                bricks.add("?");
                bricks.add(new Character(c).toString());
                stringValue = new StringBuffer();
                continue;
            }
            stringValue.append(c);
        }
        if (c != ')') {
            throw new SQLQueryParseException(5044, "Invalid query format, expected ')' after values list");
        }
        return SQLDynamicQueryParser.createSQLQueryFromBriks(connection, tableName, bricks, insertColumns, insertValues, SQLQueryType.INSERT.getId());
    }

    private static SQLQuery createForDynamicUpdate(Connection connection, StringBuffer str, List<String> bricks) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        int index;
        String tableName = SQLDynamicQueryParser.getNextWord(str, null, bricks);
        if (tableName == null) {
            throw new SQLQueryParseException(5044, "Invalid query format, expected 'into' word");
        }
        String word = SQLDynamicQueryParser.getNextWord(str, null, bricks);
        if (word == null || !word.equalsIgnoreCase("set")) {
            throw new SQLQueryParseException(5044, "Invalid query format, expected 'set' word");
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Object> columnValues = new ArrayList<Object>();
        char quoteChar = '\u0000';
        StringBuffer token = new StringBuffer();
        boolean valueExpected = false;
        for (index = 0; index < str.length(); ++index) {
            char c = str.charAt(index);
            if (c == '\'' || c == '\"') {
                if (quoteChar == '\u0000') {
                    quoteChar = c;
                } else if (quoteChar == c) {
                    quoteChar = '\u0000';
                }
                token.append(c);
                continue;
            }
            if (quoteChar == '\u0000') {
                String s;
                if (c == '=') {
                    bricks.add(token.toString());
                    bricks.add("=");
                    columnNames.add(token.toString().trim());
                    token = new StringBuffer();
                    valueExpected = true;
                    continue;
                }
                if (c == ',') {
                    s = token.toString().trim();
                    if (s.length() == 0 && valueExpected) {
                        throw new SQLQueryParseException(5044, "Invalid query format, column value is missing");
                    }
                    if (valueExpected) {
                        columnValues.add(s);
                        bricks.add("?");
                    }
                    bricks.add(",");
                    token = new StringBuffer();
                    valueExpected = false;
                    continue;
                }
                if ((c == ' ' || c == '\u0000') && valueExpected) {
                    s = token.toString().trim();
                    if (s.length() == 0) {
                        token.append(c);
                        continue;
                    }
                    if (s.equalsIgnoreCase("WHERE")) {
                        throw new SQLQueryParseException(5044, "Invalid query format, column value is missing");
                    }
                    columnValues.add(s);
                    bricks.add("?");
                    bricks.add(" ");
                    token = new StringBuffer();
                    valueExpected = false;
                    continue;
                }
                if (!(c != ' ' && c != '\u0000' || valueExpected)) {
                    s = token.toString().trim();
                    if (!s.equalsIgnoreCase("WHERE")) continue;
                    break;
                }
                token.append(c);
                continue;
            }
            token.append(c);
        }
        if (index == str.length() && valueExpected) {
            String s = token.toString().trim();
            if (s.length() == 0) {
                throw new SQLQueryParseException(5044, "Invalid query format, column value is missing");
            }
            columnValues.add(s);
            bricks.add("?");
        }
        if (token.toString().trim().equalsIgnoreCase("where")) {
            index -= 6;
        }
        str.delete(0, index);
        SQLDynamicQueryParser.parseWhereClause(str, bricks, columnNames, columnValues);
        return SQLDynamicQueryParser.createSQLQueryFromBriks(connection, tableName, bricks, columnNames, columnValues, SQLQueryType.UPDATE.getId());
    }

    private static SQLQuery createForDynamicSelect(Connection connection, StringBuffer str, List<String> bricks) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        String word = SQLDynamicQueryParser.getNextWord(str, null, bricks);
        if (word == null || !word.equalsIgnoreCase("from")) {
            throw new SQLQueryParseException(5044, "Invalid query format, expected 'from' word");
        }
        String tableName = SQLDynamicQueryParser.getNextWord(str, null, bricks);
        if (tableName == null || tableName.length() == 0) {
            throw new SQLQueryParseException(5044, "Invalid query format, table name is missing");
        }
        while ((word = SQLDynamicQueryParser.getNextWord(str, null, bricks)) != null && word.length() != 0 && !word.equalsIgnoreCase("where")) {
        }
        if (word != null && word.equalsIgnoreCase("where")) {
            bricks.remove(bricks.size() - 1);
            bricks.remove(bricks.size() - 1);
            str.insert(0, "where ");
            ArrayList<String> columnNames = new ArrayList<String>();
            ArrayList<Object> columnValues = new ArrayList<Object>();
            SQLDynamicQueryParser.parseWhereClause(str, bricks, columnNames, columnValues);
            return SQLDynamicQueryParser.createSQLQueryFromBriks(connection, tableName, bricks, columnNames, columnValues, SQLQueryType.SELECT.getId());
        }
        StringBuffer query = new StringBuffer();
        for (String brick : bricks) {
            query.append(brick);
        }
        return new SQLQuery(query.toString(), SQLQueryType.SELECT.getId());
    }

    private static SQLQuery createForDynamicDelete(Connection connection, StringBuffer str, List<String> bricks) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        String word = SQLDynamicQueryParser.getNextWord(str, null, bricks);
        if (word == null || !word.equalsIgnoreCase("from")) {
            throw new SQLQueryParseException(5044, "Invalid query format, expected 'from' word");
        }
        String tableName = SQLDynamicQueryParser.getNextWord(str, null, bricks);
        if (tableName == null || tableName.length() == 0) {
            throw new SQLQueryParseException(5044, "Invalid query format, table name is missing");
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Object> columnValues = new ArrayList<Object>();
        SQLDynamicQueryParser.parseWhereClause(str, bricks, columnNames, columnValues);
        if (columnNames.size() == 0) {
            StringBuffer query = new StringBuffer();
            for (String brick : bricks) {
                query.append(brick);
            }
            return new SQLQuery(query.toString(), SQLQueryType.DELETE.getId());
        }
        return SQLDynamicQueryParser.createSQLQueryFromBriks(connection, tableName, bricks, columnNames, columnValues, SQLQueryType.DELETE.getId());
    }

    private static void parseWhereClause(StringBuffer str, List<String> bricks, List<String> columnNames, List<Object> columnValues) throws SQLQueryParseException {
        int index;
        String word = SQLDynamicQueryParser.getNextWord(str, null, bricks);
        if (word == null || word.length() == 0) {
            return;
        }
        if (!word.equalsIgnoreCase("where")) {
            throw new SQLQueryParseException(5044, "Invalid query format, expected 'where' word");
        }
        if (str.toString().length() == 0) {
            throw new SQLQueryParseException(5044, "Invalid query format, where clause is missing");
        }
        char quoteChar = '\u0000';
        StringBuffer token = new StringBuffer();
        boolean valueExpected = false;
        for (index = 0; index < str.length(); ++index) {
            char c = str.charAt(index);
            if (c == '\'' || c == '\"') {
                if (quoteChar == '\u0000') {
                    quoteChar = c;
                } else if (quoteChar == c) {
                    quoteChar = '\u0000';
                }
                token.append(c);
                continue;
            }
            if (quoteChar == '\u0000') {
                String s;
                if (c == '=') {
                    bricks.add(token.toString());
                    bricks.add("=");
                    columnNames.add(token.toString().trim());
                    token = new StringBuffer();
                    valueExpected = true;
                    continue;
                }
                if (c == '(' || c == ')') {
                    s = token.toString().trim();
                    if (valueExpected) {
                        if (s.length() == 0 || c == '(') {
                            throw new SQLQueryParseException(5044, "Invalid query format, column value is missing, unexpected character: " + c);
                        }
                        columnValues.add(s);
                        bricks.add("?");
                        s = "";
                        valueExpected = false;
                    }
                    if (s.length() > 0) {
                        bricks.add(s);
                    }
                    bricks.add(new Character(c).toString());
                    token = new StringBuffer();
                    continue;
                }
                if (c == ' ' || c == '\u0000') {
                    s = token.toString().trim();
                    if (!valueExpected) {
                        if (!s.equalsIgnoreCase("AND") && !s.equalsIgnoreCase("OR")) continue;
                        bricks.add(" " + s + " ");
                        token = new StringBuffer();
                        continue;
                    }
                    if (s.length() == 0) {
                        token.append(c);
                        continue;
                    }
                    if (s.equalsIgnoreCase("AND") || s.equalsIgnoreCase("OR")) {
                        throw new SQLQueryParseException(5044, "Invalid query format, column value is missing");
                    }
                    columnValues.add(s);
                    bricks.add("?");
                    bricks.add(" ");
                    token = new StringBuffer();
                    valueExpected = false;
                    continue;
                }
                token.append(c);
                continue;
            }
            token.append(c);
        }
        if (index == str.length() && valueExpected) {
            String s = token.toString().trim();
            if (s.length() == 0) {
                throw new SQLQueryParseException(5044, "Invalid query format, column value is missing");
            }
            columnValues.add(s);
            bricks.add("?");
        } else if (token.length() > 0) {
            bricks.add(token.toString());
        }
    }

    private static SQLQuery createSQLQueryFromBriks(Connection connection, String tableName, List<String> bricks, List<String> columnNames, List<Object> columnValues, int queryType) throws SQLQueryParseException, SQLQueryValidationException, DatabaseSQLException {
        if (columnNames.size() > 0 && columnNames.size() != columnValues.size()) {
            throw new SQLQueryParseException(5044, "Invalid query format, columns count not equal values count");
        }
        ArrayList<String> columnsToResolve = new ArrayList<String>();
        for (int i = 0; i < columnNames.size(); ++i) {
            if (!columnValues.get(i).equals("?")) continue;
            columnsToResolve.add(columnNames.get(i));
        }
        List<SQLQueryParameter> queryParameters = DatabaseDescriptor.getTableColumns(SQLTableName.parse(tableName), connection, columnsToResolve.toArray(new String[0]), 1);
        if (columnsToResolve.size() > 0 && columnsToResolve.size() != queryParameters.size() || columnsToResolve.size() == 0 && columnValues.size() != queryParameters.size()) {
            throw new SQLQueryParseException(5044, "Invalid query format, columns count not equal values count");
        }
        int prameterssIndex = 0;
        for (int i = 0; i < columnValues.size(); ++i) {
            if (!columnValues.get(i).equals("?")) continue;
            columnValues.set(i, queryParameters.get(columnsToResolve.isEmpty() ? i : prameterssIndex++));
        }
        StringBuffer query = new StringBuffer();
        int i = 0;
        for (String brick : bricks) {
            Object value;
            if (!brick.equals("?")) {
                query.append(brick);
                continue;
            }
            if ((value = columnValues.get(i++)) instanceof String) {
                query.append((String)value);
                continue;
            }
            if (!(value instanceof SQLQueryParameter)) continue;
            SQLQueryParameter param = (SQLQueryParameter)value;
            String template = SQLQuerySyntax.getSyntax().generateParameter(param.getName(), SQLTypeToken.getTypeById(param.getType()), param.getTypeName(), param.generateDefaultValue(), null);
            query.append(template);
        }
        SQLQuery sqlQuery = new SQLQuery(query.toString(), queryType);
        sqlQuery.getParameters().add(queryParameters);
        return sqlQuery;
    }

    private static String getNextWord(StringBuffer str, String delimiter, List<String> bricks) {
        while (str.length() > 0 && str.charAt(0) == ' ') {
            str.deleteCharAt(0);
        }
        int spacePosition = str.indexOf(" ");
        if (spacePosition == -1) {
            spacePosition = str.length();
        }
        int delimiterPosition = -1;
        if (delimiter != null && (delimiterPosition = str.indexOf(delimiter)) >= 0) {
            if (delimiterPosition < spacePosition || spacePosition == -1) {
                spacePosition = delimiterPosition;
            } else {
                boolean allspaces = true;
                for (int i = spacePosition + 1; i < delimiterPosition; ++i) {
                    if (str.charAt(i) == ' ') continue;
                    allspaces = false;
                    break;
                }
                if (allspaces) {
                    spacePosition = delimiterPosition;
                }
            }
        }
        if (spacePosition == -1) {
            return null;
        }
        String word = str.substring(0, spacePosition);
        if (bricks != null) {
            bricks.add(word);
            if (delimiterPosition >= 0 && (spacePosition < 0 || delimiterPosition == spacePosition)) {
                bricks.add(delimiter);
            } else {
                bricks.add(" ");
            }
        }
        str.delete(0, spacePosition + 1);
        return word;
    }
}

