/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.sql.QueryParameterMappingType;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class QueryParameterMappingTable {
    private ArrayList<String> paramNames = new ArrayList();
    private ArrayList<String> paramValues = new ArrayList();
    private ArrayList<QueryParameterMappingType> paramTypes = new ArrayList();
    private static final String TYPE_VALUE_DELIMITER = "#";
    private static final String NAME_TYPE_DELIMITER = ":";

    public QueryParameterMappingTable() {
    }

    public QueryParameterMappingTable(String table) {
        this.parse(table);
    }

    private void parse(String table) {
        StringTokenizer tokenizer = new StringTokenizer(table, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int pos = token.indexOf(NAME_TYPE_DELIMITER);
            if (pos == -1) continue;
            String paramName = token.substring(0, pos);
            String paramValue = token.substring(pos + 1);
            if (paramValue.equals(QueryParameterMappingType.NULL_VALUE.toString())) {
                this.addParameter(paramName, "", QueryParameterMappingType.NULL_VALUE);
                continue;
            }
            pos = paramValue.indexOf(TYPE_VALUE_DELIMITER);
            if (pos == -1) continue;
            String paramType = paramValue.substring(0, pos);
            paramValue = paramValue.substring(pos + 1);
            if (paramType.equals(QueryParameterMappingType.STATIC.toString())) {
                this.addParameter(paramName, paramValue, QueryParameterMappingType.STATIC);
                continue;
            }
            if (paramType.equals(QueryParameterMappingType.GLOBAL_VARIABLE.toString())) {
                this.addParameter(paramName, paramValue, QueryParameterMappingType.GLOBAL_VARIABLE);
                continue;
            }
            if (!paramType.equals(QueryParameterMappingType.EVENT_PROPERTY.toString())) continue;
            this.addParameter(paramName, paramValue, QueryParameterMappingType.EVENT_PROPERTY);
        }
    }

    public void addParameter(String name, String value, QueryParameterMappingType type) {
        this.paramNames.add(name);
        this.paramValues.add(value);
        this.paramTypes.add(type);
    }

    public String getParameterValue(String paramName, DataEvent event) {
        String result = null;
        int index = this.lookup(paramName);
        if (index != -1) {
            QueryParameterMappingType type = this.paramTypes.get(index);
            switch (type) {
                case GLOBAL_VARIABLE: {
                    if (RuntimeContext.getInstance().getEnvironment().get(this.paramValues.get(index)) == null) break;
                    result = (String)RuntimeContext.getInstance().getEnvironment().get(this.paramValues.get(index));
                    break;
                }
                case STATIC: {
                    result = this.paramValues.get(index);
                    break;
                }
                case EVENT_PROPERTY: {
                    String propertyName = this.paramValues.get(index);
                    try {
                        if (propertyName == null) break;
                        result = (String)event.getEventObjectProperty(propertyName);
                    }
                    catch (SDOException sDOException) {}
                    break;
                }
                case NULL_VALUE: {
                    return null;
                }
            }
        }
        return result;
    }

    private int lookup(String paramName) {
        for (int i = 0; i < this.paramNames.size(); ++i) {
            if (!this.paramNames.get(i).equals(paramName)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.paramNames.size(); ++i) {
            buffer.append(this.paramNames.get(i));
            buffer.append(NAME_TYPE_DELIMITER);
            QueryParameterMappingType type = this.paramTypes.get(i);
            if (type == QueryParameterMappingType.NULL_VALUE) {
                buffer.append(QueryParameterMappingType.NULL_VALUE.toString());
            } else {
                buffer.append(type.toString());
                buffer.append(TYPE_VALUE_DELIMITER);
                buffer.append(this.paramValues.get(i));
            }
            buffer.append(",");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public List<String> getParameterNames() {
        return this.paramNames;
    }
}

