/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sql;

import com.streamscape.Trace;
import com.streamscape.ds.schema.server.VirtualServerObject;
import com.streamscape.sdo.excp.DatabaseSQLException;
import com.streamscape.sdo.excp.SQLQueryParseException;
import com.streamscape.sdo.excp.SQLQueryValidationException;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.SQLTableName;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.service.osf.jdbc.DatabaseConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class DatabaseDescriptor {
    private static final int PARAMETER_MODE_RETURN = 5;

    public static List<String> getTables(Connection connection) {
        ArrayList<String> tables = new ArrayList<String>();
        try {
            DatabaseMetaData meta = connection.getMetaData();
            ResultSet result = meta.getTables(connection.getCatalog(), null, null, new String[]{"TABLE"});
            if (result != null) {
                while (result.next()) {
                    String tableName = result.getString("TABLE_NAME");
                    tables.add(tableName);
                }
            }
        }
        catch (SQLException error) {
            Trace.logError(DatabaseDescriptor.class, error.getMessage());
        }
        return tables;
    }

    public static List<String> getStoredProcedures(Connection connection) {
        ArrayList<String> procedures = new ArrayList<String>();
        try {
            DatabaseMetaData meta = connection.getMetaData();
            ResultSet result = meta.getProcedures(connection.getCatalog(), "dbo", null);
            if (result != null) {
                while (result.next()) {
                    String procName = result.getString("PROCEDURE_NAME");
                    procName = procName.substring(0, procName.length() - 2);
                    procedures.add(procName);
                }
            }
        }
        catch (SQLException error) {
            Trace.logError(DatabaseDescriptor.class, error.getMessage());
        }
        return procedures;
    }

    public static List<SQLQueryParameter> getStoredProcedureParameters(String procName, Connection connection) {
        ArrayList<SQLQueryParameter> parameters = new ArrayList<SQLQueryParameter>();
        try {
            DatabaseMetaData meta = connection.getMetaData();
            ResultSet result = meta.getProcedureColumns(connection.getCatalog(), null, procName, null);
            int ordinal = 1;
            if (result != null) {
                while (result.next()) {
                    String parameterName = result.getString("COLUMN_NAME").substring(1);
                    int parameterType = result.getInt("DATA_TYPE");
                    String parameterTypeName = result.getString("TYPE_NAME");
                    boolean isReturnCode = false;
                    int parameterMode = result.getInt("COLUMN_TYPE");
                    if (parameterMode == 1) {
                        parameterMode = SQLQueryParameterMode.IN.getMode();
                    } else if (parameterMode == 4) {
                        parameterMode = SQLQueryParameterMode.OUT.getMode();
                    } else if (parameterMode == 2) {
                        parameterMode = SQLQueryParameterMode.INOUT.getMode();
                    } else if (parameterMode == 5) {
                        parameterMode = SQLQueryParameterMode.OUT.getMode();
                        parameterName = "ReturnCode";
                        isReturnCode = true;
                    }
                    boolean parameterNullable = false;
                    short nullable = result.getShort("NULLABLE");
                    if (nullable == 1) {
                        parameterNullable = true;
                    }
                    short parameterLength = result.getShort("LENGTH");
                    short parameterScale = result.getShort("SCALE");
                    short parameterPrecision = result.getShort("PRECISION");
                    SQLQueryParameter param = new SQLQueryParameter(parameterName, parameterType, parameterTypeName, parameterNullable, null, null, parameterLength, parameterPrecision, parameterScale, false, isReturnCode, ordinal, parameterMode);
                    parameters.add(param);
                    ++ordinal;
                }
            }
        }
        catch (SQLException error) {
            Trace.logError(DatabaseDescriptor.class, error.getMessage());
        }
        catch (SQLQueryValidationException error) {
            Trace.logError(DatabaseDescriptor.class, error.getMessage());
        }
        return parameters;
    }

    @Deprecated
    public static List<SQLQueryParameter> getTableColumns(SQLTableName tableName, Connection connection) throws SQLQueryParseException {
        ArrayList<SQLQueryParameter> columns = new ArrayList<SQLQueryParameter>();
        try {
            DatabaseMetaData meta = connection.getMetaData();
            ResultSet result = meta.getColumns(tableName.getCatalog() != null ? tableName.getCatalog() : connection.getCatalog(), tableName.getSchema() != null ? tableName.getSchema().toUpperCase() : null, tableName.getTable(), null);
            ArrayList<SQLQueryParameter> otherColumns = new ArrayList<SQLQueryParameter>();
            int ordinal = 1;
            if (result != null) {
                while (result.next()) {
                    String parameterName = result.getString("COLUMN_NAME");
                    int parameterType = result.getInt("DATA_TYPE");
                    String parameterTypeName = result.getString("TYPE_NAME");
                    boolean isReturnCode = false;
                    int parameterMode = SQLQueryParameterMode.IN.getMode();
                    boolean parameterNullable = false;
                    short nullable = result.getShort("NULLABLE");
                    if (nullable == 1) {
                        parameterNullable = true;
                    }
                    SQLQueryParameter param = new SQLQueryParameter(parameterName, parameterType, parameterTypeName, parameterNullable, null, null, 0, 0, 0, false, isReturnCode, ordinal, parameterMode);
                    columns.add(param);
                    if (param.getType() == SQLTypeToken.OTHER.getId()) {
                        otherColumns.add(param);
                    }
                    ++ordinal;
                }
            }
            if (otherColumns.size() > 0) {
                StringBuffer sqlSelectQuery = new StringBuffer();
                sqlSelectQuery.append("select ");
                for (int i = 0; i < otherColumns.size(); ++i) {
                    if (i > 0) {
                        sqlSelectQuery.append(", ");
                    }
                    sqlSelectQuery.append(((SQLQueryParameter)otherColumns.get(i)).getName());
                }
                sqlSelectQuery.append(" from ").append(tableName);
                PreparedStatement pstm = connection.prepareStatement(sqlSelectQuery.toString());
                ResultSetMetaData resultsetmetadata = pstm.getMetaData();
                for (int i = 1; i <= resultsetmetadata.getColumnCount(); ++i) {
                    SQLTypeToken typeObj;
                    int columnType = resultsetmetadata.getColumnType(i);
                    if (columnType == ((SQLQueryParameter)otherColumns.get(i - 1)).getType() || (typeObj = SQLTypeToken.getTypeById(columnType)) == null || !typeObj.isSupported()) continue;
                    SQLQueryParameter param = (SQLQueryParameter)otherColumns.get(i - 1);
                    String columnTypeName = resultsetmetadata.getColumnTypeName(i);
                    int index = columnTypeName.indexOf(32);
                    if (index != -1) {
                        columnTypeName = columnTypeName.substring(0, index);
                    }
                    if (tableName.getSchema() == null) {
                        columnTypeName = SQLTableName.parse(columnTypeName).getTable();
                    }
                    SQLQueryParameter newParam = new SQLQueryParameter(param.getName(), columnType, columnTypeName, param.isNullable(), param.getDefaultValue(), param.getValue(), param.getLength(), param.getPrecision(), param.getScale(), param.isSearchable(), param.isReturnCode(), param.getOrdinal(), param.getMode());
                    columns.set(newParam.getOrdinal() - 1, newParam);
                }
            }
        }
        catch (SQLException error) {
            Trace.logError(DatabaseDescriptor.class, error.getMessage());
        }
        catch (SQLQueryValidationException error) {
            Trace.logError(DatabaseDescriptor.class, error.getMessage());
        }
        return columns;
    }

    public static List<SQLQueryParameter> getTableColumns(SQLTableName tableName, Connection connection, String[] columnNames, int ordinal) throws SQLQueryValidationException, DatabaseSQLException, SQLQueryParseException {
        ArrayList<SQLQueryParameter> columns = new ArrayList<SQLQueryParameter>();
        try {
            StringBuffer sqlSelectQuery = new StringBuffer();
            sqlSelectQuery.append("select ");
            if (columnNames != null && columnNames.length > 0) {
                for (int i = 0; i < columnNames.length; ++i) {
                    if (i > 0) {
                        sqlSelectQuery.append(", ");
                    }
                    sqlSelectQuery.append(columnNames[i]);
                }
            } else {
                sqlSelectQuery.append(" * ");
            }
            sqlSelectQuery.append(" from ").append(tableName.toQuotedString(connection)).append(" where 1=0");
            PreparedStatement pstm = connection.prepareStatement(sqlSelectQuery.toString());
            boolean selectError = false;
            try {
                pstm.execute();
            }
            catch (Exception e) {
                selectError = true;
            }
            if (!selectError) {
                ResultSetMetaData meta = pstm.getMetaData();
                if (meta == null) {
                    throw new DatabaseSQLException(1000, "Failed to get result meta data from prepared statement.");
                }
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    columns.add(DatabaseDescriptor.convertMetaToSQLQueryParameter(connection, meta, i, ordinal++, tableName.getSchema()));
                }
            } else {
                DatabaseMetaData metaData = connection.getMetaData();
                ResultSet metaDataRs = metaData.getColumns(null, tableName.getSchema(), tableName.getTable(), null);
                while (metaDataRs.next()) {
                    columns.add(new SQLQueryParameter(metaDataRs.getString("COLUMN_NAME"), metaDataRs.getInt("DATA_TYPE"), metaDataRs.getString("TYPE_NAME"), metaDataRs.getBoolean("NULLABLE"), null, null, metaDataRs.getInt("COLUMN_SIZE"), metaDataRs.getInt("COLUMN_SIZE"), metaDataRs.getInt("DECIMAL_DIGITS"), false, false, ordinal, SQLQueryParameterMode.IN.getMode()));
                }
                if (columns.isEmpty()) {
                    throw new DatabaseSQLException(1000, "Invalid object name \"" + tableName.getTable() + "\"");
                }
            }
            return columns;
        }
        catch (SQLException error) {
            throw new DatabaseSQLException(error);
        }
    }

    public static List<SQLQueryParameter> getQueryColumns(String query, Connection connection, List<Object> params) throws SQLQueryValidationException, DatabaseSQLException, SQLQueryParseException {
        ArrayList<SQLQueryParameter> columns = new ArrayList<SQLQueryParameter>();
        try {
            PreparedStatement pstm = connection.prepareStatement(query);
            if (params != null) {
                int pos = 0;
                for (Object param : params) {
                    pstm.setObject(++pos, param);
                }
            }
            pstm.setFetchSize(1);
            pstm.execute();
            ResultSetMetaData meta = pstm.getMetaData();
            if (meta == null) {
                throw new DatabaseSQLException(1000, "Failed to get result meta data from prepared statement.");
            }
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                columns.add(DatabaseDescriptor.convertMetaToSQLQueryParameter(connection, meta, i, i, "schema"));
            }
        }
        catch (SQLException error) {
            throw new DatabaseSQLException(error);
        }
        return columns;
    }

    private static SQLQueryParameter convertMetaToSQLQueryParameter(Connection connection, ResultSetMetaData meta, int i, int ordinal, String schema) throws SQLException, SQLQueryParseException, SQLQueryValidationException {
        String columnTypeName = meta.getColumnTypeName(i);
        int index = columnTypeName.indexOf(32);
        if (index != -1) {
            columnTypeName = columnTypeName.substring(0, index);
        }
        if (schema == null) {
            columnTypeName = SQLTableName.parse(columnTypeName).getTable();
        }
        int precision = meta.getPrecision(i);
        int scale = meta.getScale(i);
        if (VirtualServerObject.isSybaseConnection(connection)) {
            String className = meta.getColumnClassName(i);
            if (String.class.getName().equals(className)) {
                precision = meta.getColumnDisplaySize(i);
            } else if (Timestamp.class.getName().equals(className)) {
                precision = meta.getColumnDisplaySize(i);
                scale = meta.getPrecision(i);
            }
        }
        return new SQLQueryParameter(meta.getColumnName(i), meta.getColumnType(i), columnTypeName, meta.isNullable(i) == 1, null, null, meta.getColumnDisplaySize(i), precision, scale, false, false, ordinal, SQLQueryParameterMode.IN.getMode());
    }

    public static String quoteColumnName(String name) {
        return DatabaseDescriptor.quoteColumnName(name, (String)null);
    }

    public static String quoteColumnName(String name, Connection connection) {
        return DatabaseDescriptor.quoteColumnName(name, (connection = DatabaseConnection.getRawConnection(connection)) != null ? connection.getClass().getName() : null);
    }

    public static String quoteColumnName(String name, String className) {
        if (VirtualServerObject.isMSAccessConnection(className)) {
            name = "[" + (String)name + "]";
        } else if (VirtualServerObject.isMySQLConnection(className)) {
            name = "`" + (String)name + "`";
        } else {
            name = ((String)name).replace("\"", "\"\"");
            name = "\"" + (String)name + "\"";
        }
        return name;
    }

    public static String quoteTableName(String name) {
        return DatabaseDescriptor.quoteTableName(name, null);
    }

    public static String quoteTableName(String name, Connection connection) {
        return DatabaseDescriptor.quoteColumnName(name, connection);
    }
}

