/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.security;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.enums.ReadAccess;
import com.streamscape.sdo.enums.TransmitAccess;
import com.streamscape.sdo.enums.WriteAccess;
import com.streamscape.sdo.security.AccessControlException;
import java.util.Arrays;

public class AccessControl
extends CloneableDataObject {
    private byte[] ACL = new byte[]{27, 37, 44};

    public AccessControl() {
    }

    public AccessControl(boolean global) {
        if (global) {
            this.ACL = new byte[]{27, 37, 46};
        }
    }

    protected AccessControl(byte[] ACL) {
        this.ACL = ACL;
    }

    public void setReadAccess(byte access) throws AccessControlException {
        if (!ReadAccess.isValid(access)) {
            throw new AccessControlException("Invalid Read Access mode specified.");
        }
        this.ACL[0] = access;
    }

    public byte getReadAccess() {
        return this.ACL[0];
    }

    public void setWriteAccess(byte access) throws AccessControlException {
        if (!WriteAccess.isValid(access)) {
            throw new AccessControlException("Invalid Write Access mode specified.");
        }
        this.ACL[1] = access;
    }

    public byte getWriteAccess() {
        return this.ACL[1];
    }

    public void setTransmitAccess(byte access) throws AccessControlException {
        if (!TransmitAccess.isValid(access)) {
            throw new AccessControlException("Invalid Transmit Access mode specified.");
        }
        this.ACL[2] = access;
    }

    public byte getTransmitAccess() {
        return this.ACL[2];
    }

    @Override
    public AccessControl clone() {
        AccessControl result = (AccessControl)super.clone();
        result.ACL = this.ACL != null ? (byte[])this.ACL.clone() : null;
        return result;
    }

    public String toString() {
        return "Access Control: Read Access=" + ReadAccess.toString(this.getReadAccess()) + ", Write Access=" + WriteAccess.toString(this.getWriteAccess()) + ", Transmit Access=" + TransmitAccess.toString(this.getTransmitAccess());
    }

    public String toSelectorString() {
        return ReadAccess.toString(this.getReadAccess()) + "," + WriteAccess.toString(this.getWriteAccess()) + "," + TransmitAccess.toString(this.getTransmitAccess());
    }

    public boolean equals(Object other) {
        return this == other || other instanceof AccessControl && Arrays.equals(this.ACL, ((AccessControl)other).ACL);
    }
}

