/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.sdrpath;

import com.streamscape.ds.types.BinaryData;
import com.streamscape.lib.reflection.ReflectionProvider;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.omf.serializer.AliasManager;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.runtime.mf.operation.edl.annotations.SemanticType;
import com.streamscape.sdo.IAbstractDataEvent;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sdrpath.ReferencePathException;
import com.streamscape.sdo.sdrpath.ReferencedTypeCastException;
import com.streamscape.sdo.tuple.Triple;
import com.streamscape.sdo.tuple.Tuple;
import com.streamscape.sef.mf.admin.FabricContext;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;

public class ReferencePathManager {
    protected FabricContext context;
    protected AliasManager aliasManager;

    protected ReferencePathManager(FabricContext context, AliasManager aliasManager) {
        this.context = context;
        this.aliasManager = aliasManager;
    }

    public Object getValueAtPath(String sdrPath, Object object) throws ReferencePathException {
        return this.getValueAtPath(sdrPath, object, false);
    }

    public Object getValueAtMap(String sdrPath, Object map) throws ReferencePathException {
        return this.getValueAtPath(sdrPath, map, true);
    }

    private Object getValueAtPath(String sdrPath, Object object, boolean atMap) throws ReferencePathException {
        if (!sdrPath.startsWith("//")) {
            throw new ReferencePathException("SDR path must start with root identifier '//'.");
        }
        Object result = object;
        List<String> tokens = StringUtils.split(sdrPath.substring(2), "/");
        ListIterator<String> p = tokens.listIterator();
        for (int i = 0; i < tokens.size(); ++i) {
            Object value = this.getValue(tokens.get(i), result, atMap);
            if (value == null) {
                return null;
            }
            result = this.processResultValue(value, result, i == tokens.size() - 1, sdrPath);
        }
        return result;
    }

    protected Object processResultValue(Object value, Object parent, boolean isLastToken, String sdrPath) throws ReferencePathException {
        if ((parent instanceof Tuple || parent instanceof Triple) && isLastToken && !IAbstractDataEvent.hasSuitableAnnotationType(value)) {
            try {
                return this.context.getJSONSerializer().serialize(value);
            }
            catch (SerializerException exception) {
                throw new ReferencePathException("Conversion of value accessed by '" + sdrPath + "' to JSON string failed.", exception);
            }
        }
        return value;
    }

    public void setValueAtPath(String sdrPath, Object object, Object fieldValue) throws ReferencePathException {
        this.setValueAtPath(sdrPath, object, fieldValue, false);
    }

    public void setValueAtMap(String sdrPath, Object object, Object fieldValue) throws ReferencePathException {
        this.setValueAtMap(sdrPath, object, fieldValue, false);
    }

    public void setValueAtPath(String sdrPath, Object object, Object fieldValue, boolean convertPrimitives) throws ReferencePathException {
        this.setValueAtPath(sdrPath, object, fieldValue, convertPrimitives, false);
    }

    public void setValueAtMap(String sdrPath, Object object, Object fieldValue, boolean convertPrimitives) throws ReferencePathException {
        this.setValueAtPath(sdrPath, object, fieldValue, convertPrimitives, true);
    }

    private void setValueAtPath(String sdrPath, Object object, Object fieldValue, boolean convertPrimitives, boolean atMap) throws ReferencePathException {
        if (!sdrPath.startsWith("//")) {
            throw new ReferencePathException("SDR path must start with root identifier '//'.");
        }
        Object currentObject = object;
        StringTokenizer tokenizer = new StringTokenizer(sdrPath.substring(2), "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (tokenizer.hasMoreElements()) {
                Object temp = currentObject;
                if ((currentObject = this.getValue(token, currentObject, atMap)) != null) continue;
                currentObject = temp;
                if ((currentObject = this.instantiateField(token, currentObject)) != null) continue;
                return;
            }
            this.setValue(token, currentObject, fieldValue, convertPrimitives, atMap);
        }
    }

    public Class<?> getTypeAtPath(String sdrPath, Class<?> clazz) throws ReferencePathException {
        if (!sdrPath.startsWith("//")) {
            throw new ReferencePathException("SDR path must start with root identifier '//'.");
        }
        Class<?> result = clazz;
        StringTokenizer tokenizer = new StringTokenizer(sdrPath.substring(2), "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            Class<?> temp = this.getType(token, result);
            if (temp != null) {
                result = temp;
                continue;
            }
            return null;
        }
        return result;
    }

    public Map<String, Object> getReferenceValueMap(List<String> sdrPaths, Object object) throws ReferencePathException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String sdrPath : sdrPaths) {
            Object obj = this.getValueAtPath(sdrPath, object);
            if (obj == null) continue;
            result.put(sdrPath, obj);
        }
        return result;
    }

    public static SdrInfo parseSdr(String sdr) {
        int endPos;
        SdrInfo info = new SdrInfo();
        if (sdr.startsWith("'") && sdr.endsWith("'")) {
            info.fieldName = sdr.substring(1, sdr.length() - 1);
            info.fieldName = info.fieldName.replaceAll("''", "'");
            return info;
        }
        int pos = sdr.indexOf(91);
        if (pos != -1) {
            info.fieldName = sdr.substring(0, pos);
            endPos = sdr.indexOf(93);
            if (endPos != -1) {
                int indexStart;
                info.index = sdr.substring(pos + 1, endPos);
                if (info.index.equalsIgnoreCase("TOP")) {
                    info.index = "1";
                }
                if ((indexStart = info.index.indexOf("=")) != -1) {
                    if (info.index.startsWith("key")) {
                        info.isMapKey = true;
                    } else if (info.index.startsWith("value")) {
                        info.isMapValue = true;
                    }
                    info.index = info.index.substring(indexStart + 1);
                    info.index = info.index.trim();
                    if (info.index.startsWith("'")) {
                        info.index = info.index.substring(1, info.index.length() - 1);
                    }
                }
            }
        } else {
            pos = sdr.indexOf(58);
            info.fieldName = pos != -1 ? sdr.substring(0, pos) : sdr;
        }
        pos = sdr.indexOf(123);
        if (pos != -1 && (endPos = sdr.indexOf(125)) != -1) {
            info.fieldSemanticType = sdr.substring(pos + 1, endPos);
        }
        return info;
    }

    private void validateResultSemanticType(SdrInfo info, Class<?> resultClass) throws ReferencePathException {
        if (info.fieldSemanticType != null) {
            if (this.aliasManager == null) {
                throw new ReferencePathException("Null Alias Manager specified. Unable to resolve semantic type.");
            }
            String className = this.aliasManager.lookup(info.fieldSemanticType);
            if (className == null) {
                throw new ReferencedTypeCastException("Could not resolve Semantic Type '" + info.fieldSemanticType + " '.");
            }
            if (!className.equals(resultClass.getName())) {
                throw new ReferencedTypeCastException("Semantic Type mismatch: " + info.fieldSemanticType + " is not instance of '" + String.valueOf(resultClass) + "'.");
            }
        }
    }

    private ReferencePathException fieldNotFoundException(Exception exception, SdrInfo info, Class<?> objectClass) throws ReferencePathException {
        String semanticType;
        Object fieldName = info.fieldName;
        if (info.index != null) {
            fieldName = (String)fieldName + "[" + info.index + "]";
        }
        if (this.aliasManager != null && (semanticType = this.aliasManager.lookup(objectClass)) != null) {
            return new ReferencePathException("Element '" + (String)fieldName + "' not found in SemanticType '" + semanticType + "'.", ReferencePathException.ERROR_CODE_FIELD_NOT_FOUND);
        }
        return new ReferencePathException("Element '" + (String)fieldName + "' not found in Class '" + objectClass.getName() + "'.", ReferencePathException.ERROR_CODE_FIELD_NOT_FOUND);
    }

    private Object getValue(String sdr, Object object, boolean atMap) throws ReferencePathException {
        SdrInfo info = ReferencePathManager.parseSdr(sdr);
        Class<?> clazz = object.getClass();
        try {
            Object result;
            if (info.fieldName != null && info.fieldName.length() > 0) {
                if (object instanceof Row && ((Row)object).getMeta().findColumn(info.fieldName) > 0) {
                    result = ((Row)object).getColumn(info.fieldName);
                } else if (object instanceof RowSet && ((RowSet)object).getMeta().findColumn(info.fieldName) > 0) {
                    result = ((RowSet)object).getObject(info.fieldName);
                } else if (object instanceof Map && atMap) {
                    result = ((Map)object).get(info.fieldName);
                } else {
                    Field field = ClassUtils.getClassField(clazz, info.fieldName);
                    if (field != null) {
                        if (!Modifier.isPublic(field.getModifiers())) {
                            field.setAccessible(true);
                        }
                        if ((result = field.get(object)) == null) {
                            return null;
                        }
                    } else {
                        throw new ReferencePathException("Element '" + info.fieldName + "' does not exist.");
                    }
                }
                if (info.index != null && info.index.length() > 0) {
                    result = ReferencePathManager.getValueByIndex(result, info.index, info.isMapKey, info.isMapValue);
                }
            } else {
                result = ReferencePathManager.getValueByIndex(object, info.index, info.isMapKey, info.isMapValue);
            }
            if (result != null) {
                this.validateResultSemanticType(info, result.getClass());
            }
            return result;
        }
        catch (UtilitiesException | IndexOutOfBoundsException exception) {
            throw this.fieldNotFoundException(exception, info, clazz);
        }
        catch (Exception exception) {
            throw new ReferencePathException(exception);
        }
    }

    private Class<?> getType(String sdr, Class<?> clazz) throws ReferencePathException {
        SdrInfo info = ReferencePathManager.parseSdr(sdr);
        try {
            Field field = ClassUtils.getClassField(clazz, info.fieldName);
            if (field == null) {
                throw new ReferencePathException("Element '" + info.fieldName + "' does not exist.");
            }
            Class<?> result = field.getType();
            if (info.fieldSemanticType != null) {
                String className = this.aliasManager.lookup(info.fieldSemanticType);
                result = ClassUtils.loadClass(className, clazz.getClassLoader());
            } else if (info.index != null) {
                result = this.getTypeByIndex(field, info.index, info.isMapKey, info.isMapValue, clazz.getClassLoader());
            }
            this.validateResultSemanticType(info, result);
            return result;
        }
        catch (UtilitiesException | IndexOutOfBoundsException exception) {
            throw this.fieldNotFoundException(exception, info, clazz);
        }
        catch (Exception exception) {
            throw new ReferencePathException(exception);
        }
    }

    private Object instantiateField(String sdr, Object parent) throws ReferencePathException {
        SdrInfo info = ReferencePathManager.parseSdr(sdr);
        Class<?> clazz = parent.getClass();
        try {
            Object result = null;
            if (info.fieldName != null && info.fieldName.length() > 0) {
                Field field = ClassUtils.getClassField(clazz, info.fieldName);
                if (field != null) {
                    if (!Modifier.isPublic(field.getModifiers())) {
                        field.setAccessible(true);
                    }
                    if ((result = this.instantiateClass(field.getType())) != null) {
                        field.set(parent, result);
                    }
                    if (result == null) {
                        return null;
                    }
                    result = ReferencePathManager.getValueByIndex(result, info.index, info.isMapKey, info.isMapValue);
                }
            } else {
                result = ReferencePathManager.getValueByIndex(parent, info.index, info.isMapKey, info.isMapValue);
            }
            if (result != null) {
                this.validateResultSemanticType(info, result.getClass());
            }
            return result;
        }
        catch (IllegalAccessException exception) {
            throw new ReferencePathException(exception);
        }
        catch (Exception exception) {
            throw this.fieldNotFoundException(exception, info, clazz);
        }
    }

    private Object setValue(String sdr, Object object, Object fieldValue, boolean convertPrimitives, boolean atMap) throws ReferencePathException {
        block26: {
            SdrInfo info = ReferencePathManager.parseSdr(sdr);
            Class<?> clazz = object.getClass();
            try {
                if (info.isMapKey) {
                    HashMap map = null;
                    if (info.fieldName == null || info.fieldName.trim().equals("")) {
                        if (!Map.class.isAssignableFrom(clazz)) {
                            throw new ReferencePathException("Failed set spath " + sdr + " to non map object of class " + String.valueOf(clazz) + ".");
                        }
                        map = object;
                    } else {
                        Field field = ClassUtils.getClassField(clazz, info.fieldName);
                        if (field != null) {
                            if (!Modifier.isPublic(field.getModifiers())) {
                                field.setAccessible(true);
                            }
                            if ((map = field.get(object)) == null) {
                                map = new HashMap();
                                field.set(object, map);
                            }
                        }
                    }
                    if (map != null) {
                        ((Map)map).put(info.index, fieldValue);
                    }
                    break block26;
                }
                if (info.fieldName != null && info.fieldName.length() > 0) {
                    if (info.index == null || info.index.length() == 0) {
                        if (object instanceof Map && atMap) {
                            ((Map)object).put(info.fieldName, fieldValue);
                        } else if (object instanceof Row) {
                            ((Row)((Object)object)).setColumn(info.fieldName, fieldValue);
                        } else {
                            Field field = ClassUtils.getClassField(clazz, info.fieldName);
                            if (field != null) {
                                if (!Modifier.isPublic(field.getModifiers())) {
                                    field.setAccessible(true);
                                }
                                if (convertPrimitives) {
                                    fieldValue = this.convertPrimitives(fieldValue, field.getType());
                                }
                                if (fieldValue != null && field.getType().isArray() && fieldValue.getClass().isArray() && fieldValue.getClass().getComponentType() == Object.class) {
                                    Object temp = Array.newInstance(field.getType().getComponentType(), Array.getLength(fieldValue));
                                    for (int i = 0; i < Array.getLength(fieldValue); ++i) {
                                        Object v = Array.get(fieldValue, i);
                                        if (convertPrimitives) {
                                            v = this.convertPrimitives(v, field.getType().getComponentType());
                                        }
                                        Array.set(temp, i, v);
                                    }
                                    fieldValue = temp;
                                }
                                field.set(object, fieldValue);
                            }
                        }
                    } else {
                        object = this.getValueAtPath("//" + info.fieldName, object, atMap);
                        this.setValueByIndex(info, object, fieldValue);
                    }
                    break block26;
                }
                if (info.index != null && info.index.length() > 0) {
                    this.setValueByIndex(info, object, fieldValue);
                    break block26;
                }
                throw new ReferencePathException("Invalid SDR fragment " + sdr + ".");
            }
            catch (IllegalAccessException exception) {
                throw new ReferencePathException(exception);
            }
            catch (UtilitiesException | IndexOutOfBoundsException exception) {
                throw this.fieldNotFoundException(exception, info, clazz);
            }
            catch (RowException exception) {
                throw new ReferencePathException(exception);
            }
        }
        return null;
    }

    private void setValueByIndex(SdrInfo info, Object object, Object value) throws ReferencePathException {
        int index = -1;
        if (!"TOP".equals(info.index)) {
            try {
                index = Integer.parseInt(info.index);
            }
            catch (Exception exception) {
                throw new ReferencePathException("Invalid index in SDR fragment " + String.valueOf(info) + ".");
            }
        }
        if (object instanceof List) {
            if (index != -1) {
                while (index >= ((List)object).size()) {
                    ((List)object).add(null);
                }
                ((List)object).set(index, value);
            } else {
                ((List)object).add(index, value);
            }
        } else {
            throw new ReferencePathException("Set by index is not allowed in object of type '" + String.valueOf(object.getClass()) + "'.");
        }
    }

    private Object convertPrimitives(Object fieldValue, Type fieldType) {
        if (fieldValue instanceof Number) {
            if (fieldType.equals(Byte.class) || fieldType.equals(Byte.TYPE)) {
                fieldValue = ((Number)fieldValue).byteValue();
            } else if (fieldType.equals(Short.class) || fieldType.equals(Short.TYPE)) {
                fieldValue = ((Number)fieldValue).shortValue();
            } else if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
                fieldValue = ((Number)fieldValue).intValue();
            } else if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
                fieldValue = ((Number)fieldValue).longValue();
            } else if (fieldType.equals(Float.class) || fieldType.equals(Float.TYPE)) {
                fieldValue = Float.valueOf(((Number)fieldValue).floatValue());
            } else if (fieldType.equals(Double.class) || fieldType.equals(Double.TYPE)) {
                fieldValue = ((Number)fieldValue).doubleValue();
            } else if (fieldType.equals(BigDecimal.class)) {
                fieldValue = new BigDecimal(String.valueOf(fieldValue));
            }
        } else if (fieldValue instanceof String && !fieldType.equals(String.class)) {
            if (fieldType.equals(Byte.class) || fieldType.equals(Byte.TYPE)) {
                fieldValue = ((String)(fieldValue = ((String)fieldValue).trim())).length() == 0 ? null : Byte.valueOf((String)fieldValue);
            } else if (fieldType.equals(Short.class) || fieldType.equals(Short.TYPE)) {
                fieldValue = ((String)(fieldValue = ((String)fieldValue).trim())).length() == 0 ? null : Short.valueOf((String)fieldValue);
            } else if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
                fieldValue = ((String)(fieldValue = ((String)fieldValue).trim())).length() == 0 ? null : Integer.valueOf((String)fieldValue);
            } else if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
                fieldValue = ((String)(fieldValue = ((String)fieldValue).trim())).length() == 0 ? null : Long.valueOf((String)fieldValue);
            } else if (fieldType.equals(Float.class) || fieldType.equals(Float.TYPE)) {
                fieldValue = ((String)(fieldValue = ((String)fieldValue).trim())).length() == 0 ? null : Float.valueOf((String)fieldValue);
            } else if (fieldType.equals(Double.class) || fieldType.equals(Double.TYPE)) {
                fieldValue = ((String)(fieldValue = ((String)fieldValue).trim())).length() == 0 ? null : Double.valueOf((String)fieldValue);
            } else if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
                fieldValue = ((String)(fieldValue = ((String)fieldValue).trim())).length() == 0 ? null : Boolean.valueOf((String)fieldValue);
            } else if (fieldType.equals(BigInteger.class)) {
                fieldValue = ((String)(fieldValue = ((String)fieldValue).trim())).length() == 0 ? null : new BigInteger((String)fieldValue);
            } else if (fieldType.equals(BigDecimal.class)) {
                fieldValue = ((String)(fieldValue = ((String)fieldValue).trim())).length() == 0 ? null : new BigDecimal((String)fieldValue);
            } else if (fieldType.equals(Double.class) || fieldType.equals(Double.TYPE)) {
                fieldValue = ((String)(fieldValue = ((String)fieldValue).trim())).length() == 0 ? null : Double.valueOf((String)fieldValue);
            } else if (fieldType.equals(Character.class) || fieldType.equals(Character.TYPE)) {
                if (((String)fieldValue).length() == 1) {
                    fieldValue = Character.valueOf(((String)fieldValue).charAt(0));
                } else if (((String)fieldValue).length() == 0) {
                    fieldValue = null;
                }
            }
        } else if (fieldValue instanceof byte[] && fieldType == Byte[].class) {
            fieldValue = BinaryData.convertToByte(fieldValue);
        } else if (fieldValue instanceof Byte[] && fieldType == byte[].class) {
            fieldValue = BinaryData.convertTobyte(fieldValue);
        }
        return fieldValue;
    }

    public Object instantiateClass(Class<?> clazz) throws Exception {
        return ReflectionProvider.getInstance().newInstance(clazz);
    }

    public static Object getValueByIndex(Object result, String index, boolean isMapKey, boolean isMapValue) {
        block11: {
            block12: {
                if (result == null) {
                    return null;
                }
                if (!result.getClass().isArray()) break block12;
                if (index == null || index.length() <= 0) break block11;
                result = Array.get(result, Integer.parseInt(index));
                break block11;
            }
            if (result instanceof List && index != null) {
                result = ((List)result).get(Integer.parseInt(index));
            } else if (result instanceof Map && index != null) {
                Map map = (Map)result;
                result = null;
                if (isMapKey) {
                    result = map.get(index);
                } else if (isMapValue) {
                    for (Map.Entry entry : map.entrySet()) {
                        Map.Entry mapEntry = entry;
                        if (!mapEntry.getValue().toString().equals(index)) continue;
                        result = mapEntry.getKey();
                        break;
                    }
                } else {
                    int counter = Integer.parseInt(index);
                    for (Object value : map.values()) {
                        if (counter == 0) {
                            result = value;
                            break;
                        }
                        --counter;
                    }
                }
            }
        }
        return result;
    }

    private Class<?> getTypeByIndex(Field field, String index, boolean isMapKey, boolean isMapValue, ClassLoader classLoader) throws ReferencePathException {
        Type[] args;
        if (field.getType().isArray()) {
            return field.getType().getComponentType();
        }
        String className = null;
        SemanticType semanticTypeAnnotation = field.getAnnotation(SemanticType.class);
        if (semanticTypeAnnotation != null) {
            if (isMapKey && semanticTypeAnnotation.type().length() > 0) {
                className = semanticTypeAnnotation.type();
            }
            if (isMapValue && semanticTypeAnnotation.type1().length() > 0) {
                className = semanticTypeAnnotation.type1();
            }
            if (!isMapKey && !isMapValue && semanticTypeAnnotation.type().length() > 0) {
                className = semanticTypeAnnotation.type();
            }
            if (className != null) {
                try {
                    return ClassUtils.loadClass(className, classLoader);
                }
                catch (ClassNotFoundException exception) {
                    throw new ReferencePathException("Failed to load class semanticTypeAnnotation.type().");
                }
            }
        }
        if (field.getGenericType() instanceof ParameterizedType && (args = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()) != null && args.length > 0) {
            Type result = null;
            if (isMapKey && args.length == 2) {
                result = args[0];
            } else if (isMapValue && args.length == 2) {
                result = args[1];
            } else if (!isMapKey && !isMapValue) {
                result = args[0];
            }
            if (result instanceof Class) {
                return (Class)result;
            }
        }
        return null;
    }

    public static class SdrInfo {
        public String fieldName;
        public String fieldSemanticType = null;
        public String index = null;
        public boolean isMapKey = false;
        public boolean isMapValue = false;
    }
}

