/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.ds.jdbc.JDBCResultSet;
import com.streamscape.ds.mf.SLDataspaceCall;
import com.streamscape.ds.navigator.RowSetNavigatorDataTable;
import com.streamscape.sdo.rowset.AbstractRowSetLobProxy;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractRowSetProxy;
import java.io.Closeable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RowSetProxy
extends AbstractRowSetProxy
implements Closeable {
    private int fetchSize;
    private int offset;
    private boolean isScrollable = false;
    private boolean isClosed = false;

    private RowSetProxy() {
    }

    public RowSetProxy(RowMetaData rowMetaData) {
        this.meta = rowMetaData;
        this.meta.setHash();
        this.rows = new ArrayList();
        this.currentRow = -1;
    }

    public RowSetProxy(RowSet rowSet) {
        this.meta = rowSet.meta;
        this.rows = rowSet.rows;
        this.currentRow = -1;
    }

    protected RowSetProxy(ResultSet resultSet, RowSet rowSet) throws SQLException {
        this.fetchSize = resultSet.getFetchSize();
        this.offset = 0;
        try {
            this.isScrollable = true;
            if (resultSet instanceof JDBCResultSet && ((JDBCResultSet)resultSet).getNavigator() instanceof RowSetNavigatorDataTable) {
                throw new Exception();
            }
            resultSet.absolute(0);
            if (rowSet.getRowCount() != 0) {
                resultSet.absolute(rowSet.getRowCount());
            }
        }
        catch (Exception exception) {
            this.isScrollable = false;
        }
        this.meta = rowSet.meta;
        this.rows = rowSet.rows;
        this.currentRow = -1;
    }

    protected void populateData(Object[][] rowsData) throws SQLException {
        this.rows.clear();
        if (rowsData == null) {
            return;
        }
        for (Object[] rowData : rowsData) {
            Row row = new Row(this);
            for (int i = 1; i <= rowData.length; ++i) {
                try {
                    Object value = rowData[i - 1];
                    if (value instanceof AbstractRowSetLobProxy) {
                        ((AbstractRowSetLobProxy)value).setAccessor(this);
                        row.setRawColumn(i, value);
                        continue;
                    }
                    row.setColumn(i, value);
                    continue;
                }
                catch (Exception error) {
                    throw new SQLException(error.getMessage());
                }
            }
            super.addToRowSet(row);
        }
    }

    private void fetchRows(int offset) throws SQLException {
        this.offset = offset;
        Object[][] result = this.invokeMethodWithReturn("fetchRows", offset, this.fetchSize);
        if (!(result instanceof Object[][]) && result instanceof Object[]) {
            Object[][] matrix = new Object[((Object[])result).length][this.getMeta().getColumnCount()];
            for (int i = 0; i < ((Object[])result).length; ++i) {
                Object row = ((Object[])result)[i];
                System.arraycopy(row, 0, matrix[i], 0, matrix[i].length);
            }
            result = matrix;
        }
        this.populateData(result);
    }

    public boolean isScrollable() {
        return this.isScrollable;
    }

    public void setIsScrollable(boolean isScrollable) {
        this.isScrollable = isScrollable;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkNotClosed();
        this.checkIsScrollable();
        if (row < 0) {
            boolean absoluteResult = (Boolean)this.invokeMethodWithReturn("absolute", row);
            if (!absoluteResult) {
                return false;
            }
            int realRowNumber = (Integer)this.invokeMethodWithReturn("getRow", new Object[0]);
            row = realRowNumber - 1;
        }
        if (this.offset >= 0 && row >= this.offset && row < this.offset + this.rows.size()) {
            this.currentRow = row - this.offset;
            if (this.rows.size() == 0) {
                this.fetchRows(this.offset);
            }
            return true;
        }
        try {
            Object result = this.invokeMethodWithReturn("absolute", row);
            if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) {
                this.currentRow = -1;
                return false;
            }
            this.fetchRows(row);
            this.currentRow = 0;
            return true;
        }
        catch (SQLException exception) {
            this.currentRow = -1;
            throw exception;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkNotClosed();
        if (this.offset == 0) {
            this.currentRow = -1;
            return;
        }
        this.checkIsScrollable();
        this.currentRow = -1;
        if (this.offset != 0) {
            this.currentRow = -1;
            this.offset = -1;
            this.rows.clear();
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkNotClosed();
        this.checkIsScrollable();
        if (!this.last()) {
            throw new SQLException("Failed to navigate to the last.");
        }
        this.next();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkNotClosed();
        if (this.offset == 0) {
            this.currentRow = 0;
            return true;
        }
        this.checkIsScrollable();
        return this.absolute(0);
    }

    @Override
    public boolean last() throws SQLException {
        this.checkNotClosed();
        this.checkIsScrollable();
        boolean last = (Boolean)this.invokeMethodWithReturn("last", new Object[0]);
        if (!last) {
            return false;
        }
        int row = (Integer)this.invokeMethodWithReturn("getRow", new Object[0]);
        return this.absolute(row - 1);
    }

    @Override
    public boolean relative(int rowsCount) throws SQLException {
        this.checkNotClosed();
        this.checkIsScrollable();
        if (this.offset == -1 && this.currentRow == -1) {
            return this.absolute(0);
        }
        if (this.offset < 0 || this.offset + this.currentRow + rowsCount < 0) {
            this.currentRow = -1;
            return false;
        }
        boolean result = false;
        if (rowsCount < 0 && this.currentRow <= 0 && this.offset > 0) {
            if (this.fetchSize > 0 && this.fetchSize < this.offset) {
                result = this.absolute(this.offset - this.fetchSize);
                if (result) {
                    result = this.absolute(this.offset + this.fetchSize + rowsCount);
                }
            } else {
                int tmp = this.offset + rowsCount;
                result = this.absolute(0);
                if (result) {
                    this.absolute(tmp);
                }
            }
        } else {
            result = this.absolute(this.offset + this.currentRow + rowsCount);
        }
        return result;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkNotClosed();
        this.checkIsScrollable();
        return this.relative(-1);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkNotClosed();
        if (this.currentRow == this.rows.size()) {
            return (Boolean)this.invokeMethodWithReturn("isAfterLast", new Object[0]);
        }
        return false;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.currentRow < 0 && this.offset <= 0;
    }

    @Override
    public boolean isFirst() {
        return this.currentRow == 0 && this.offset == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkNotClosed();
        if (this.rows.size() > 0 && this.currentRow == this.rows.size() - 1) {
            return (Boolean)this.invokeMethodWithReturn("isLast", new Object[0]);
        }
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkNotClosed();
        if (this.isScrollable) {
            boolean result = this.relative(1);
            if (!result && this.offset >= 0 && this.currentRow == -1) {
                this.currentRow = this.rows.size();
            }
            return result;
        }
        if (this.offset >= 0 && this.currentRow >= -1 && this.currentRow < this.rows.size() - 1) {
            ++this.currentRow;
            return true;
        }
        try {
            this.fetchRows(this.offset + this.currentRow + 1);
            this.currentRow = 0;
            return this.rows.size() != 0;
        }
        catch (SQLException exception) {
            this.currentRow = -1;
            throw exception;
        }
    }

    @Override
    public int getRow() throws SQLException {
        if (!this.isBeforeFirst() && !this.isAfterLast()) {
            return this.offset + this.currentRow + 1;
        }
        return 0;
    }

    @Override
    public void close() {
        try {
            this.invokeMethod("close", new Object[0]);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        SLDataspaceCall call = new SLDataspaceCall(0L, "eraseFromObjectCache", new Object[]{this.proxyHelper.getId()});
        this.invokeRequest("e.sys.sl.DataspaceCall", call);
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.fetchSize = fetchSize;
    }

    @Override
    public void setPageSize(int pageSize) throws SQLException {
        this.setFetchSize(pageSize);
    }

    @Override
    public int getPageSize() throws SQLException {
        return this.getFetchSize();
    }

    @Override
    public Row getCurrentRow() throws SQLException {
        if (this.currentRow < 0 || this.currentRow >= this.rows.size()) {
            throw new SQLException("Row not set.");
        }
        return (Row)this.rows.get(this.currentRow);
    }

    @Override
    public Row getRowAt(int index) throws SQLException {
        if (index < 1 + this.offset || index > this.rows.size() + this.offset) {
            throw new SQLException("Row index is out of range.");
        }
        return (Row)this.rows.get(index - 1 - this.offset);
    }

    @Override
    public RowSet asRowSet() throws SQLException {
        RowSet result = new RowSet(this.meta);
        result.addAll(this);
        this.fetchAllRowSetLobs();
        while (this.nextPage()) {
            result.addAll(this);
            this.fetchAllRowSetLobs();
        }
        this.close();
        return result;
    }

    @Override
    public boolean nextPage() throws SQLException {
        this.checkNotClosed();
        Object[] backup = this.backupRowsAndOffset();
        try {
            if (this.offset == -1 && this.currentRow == -1) {
                this.offset = 0;
            }
            this.fetchRows(this.offset + this.rows.size());
            if (this.rows.size() == 0) {
                this.restoreRowsAndOffset(backup);
                return false;
            }
            this.currentRow = 0;
            return true;
        }
        catch (SQLException exception) {
            this.restoreRowsAndOffset(backup);
            if (exception.getMessage().indexOf("Failed to set cursor position to ") == -1) {
                throw exception;
            }
            return false;
        }
    }

    @Override
    public boolean previousPage() throws SQLException {
        if (this.offset == 0) {
            return false;
        }
        Object[] backup = this.backupRowsAndOffset();
        try {
            int pageOffset = -this.currentRow;
            pageOffset = this.fetchSize > 0 && this.fetchSize < this.offset ? (pageOffset -= this.fetchSize) : (pageOffset -= this.offset);
            boolean result = this.relative(pageOffset);
            if (!result) {
                this.restoreRowsAndOffset(backup);
            }
            return result;
        }
        catch (SQLException exception) {
            this.restoreRowsAndOffset(backup);
            throw exception;
        }
    }

    private Object[] backupRowsAndOffset() {
        Object[] backup = new Object[]{new ArrayList(this.rows), this.currentRow, this.offset};
        return backup;
    }

    private void restoreRowsAndOffset(Object[] backup) {
        this.rows = (List)backup[0];
        this.currentRow = (Integer)backup[1];
        this.offset = (Integer)backup[2];
    }

    private void checkIsScrollable() throws SQLException {
        if (!this.isScrollable) {
            throw new SQLException("RowSet is forward only.");
        }
    }

    private void checkNotClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("RowSet is closed.");
        }
    }

    protected Object invokeRowSetMethodWithReturn(long id, String method) throws SQLException {
        return this.invokeMethodWithReturn(method, id);
    }

    protected Object invokeRowSetBlobMethodWithReturn(long id, String method, Object[] params) throws SQLException {
        return this.invokeMethodWithReturn("invokeRowSetBlobMethod", this.makeRowSetBlobMethodParmas(id, method, params));
    }

    protected void invokeRowSetBlobMethod(long id, String method, Object[] params) throws SQLException {
        this.invokeMethod("invokeRowSetBlobMethod", this.makeRowSetBlobMethodParmas(id, method, params));
    }

    protected Object[] makeRowSetBlobMethodParmas(long id, String method, Object[] params) {
        Object[] newParams = new Object[]{id, method, params};
        return newParams;
    }

    @Override
    protected Object getCurrentPosition() {
        return new Object[]{this.offset, this.currentRow};
    }

    @Override
    protected void restoreCurrentPosition(Object object) throws SQLException {
        this.absolute((Integer)((Object[])object)[0]);
        this.currentRow = (Integer)((Object[])object)[1];
    }
}

