/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.Trace;
import com.streamscape.cli.ds.collection.Aspects;
import com.streamscape.cli.ds.collection.Facets;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.types.FacetsUtils;
import com.streamscape.ds.types.FlobInfo;
import com.streamscape.sdo.rowset.DataRow;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.MetaDataProvider;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowArray;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.tools.console.InterruptableStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;

public class RowSetPrinter {
    private static final boolean HTML_MODE = false;
    private static final String DIVIDER = "----------------------------------------------------------------------------------------------------------------------------------";
    private static final String SPACES = "                                                                                                                                  ";
    public static final int DEFAULT_MAX_COLUMN_WIDTH = "----------------------------------------------------------------------------------------------------------------------------------".length();
    private PrintStream stream = new PrintStream(System.out);
    private Map<String, PrintStream> columnStreams = new HashMap<String, PrintStream>();
    private String indent = "";
    private int maxColumnWidth = DEFAULT_MAX_COLUMN_WIDTH;
    private int[] maxWidth;
    private boolean suppressHeader = false;
    private String nullRep = "NULL";
    private TimeZone timezone = TimeZone.getDefault();

    public RowSetPrinter timezone(TimeZone timezone) {
        this.timezone = timezone;
        return this;
    }

    public RowSetPrinter timezone(String timezone) {
        this.timezone = TimeZone.getTimeZone(timezone);
        return this;
    }

    public synchronized void print(RowSet rowSet, String indent) {
        this.indent = indent;
        this.print(rowSet);
    }

    public int getMaxColumnWidth() {
        return this.maxColumnWidth;
    }

    public synchronized void setMaxColumnWidth(int maxColumnWidth) {
        this.maxColumnWidth = maxColumnWidth;
    }

    public String getNullIdentifier() {
        return this.nullRep;
    }

    public void setNullIdentifier(String nullRep) {
        this.nullRep = nullRep;
    }

    public void setSuppressHeader(boolean suppressHeader) {
        this.suppressHeader = suppressHeader;
    }

    public boolean isSuppressHeader() {
        return this.suppressHeader;
    }

    public void setPrintStream(PrintStream stream) {
        this.stream = stream;
    }

    public void setColumnPrintStream(String name, PrintStream printStream) {
        this.columnStreams.put(name, printStream);
    }

    private boolean isStreamInterrupted() {
        return this.stream instanceof InterruptableStream && ((InterruptableStream)((Object)this.stream)).isInterrupted();
    }

    public synchronized String printToString(RowSet rowSet) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.setPrintStream(new PrintStream(os));
        this.print(rowSet);
        return os.toString();
    }

    public synchronized void print(RowSet rowSet) {
        try {
            rowSet.beforeFirst();
            this.printInternal(rowSet, rowSet.getFetchSize(), rowSet::next, rowSet::getObject);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    public synchronized void print(Row row) {
        try {
            boolean[] next = new boolean[]{true};
            this.printInternal(row, 10, () -> {
                if (!next[0]) {
                    return false;
                }
                next[0] = false;
                return true;
            }, row::getColumn);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    public synchronized void print(RowArray array) {
        try {
            DataRow[] current = new DataRow[]{null};
            Iterator<DataRow> iter = array.iteratorByEntry();
            this.printInternal(array, 10, () -> {
                if (iter.hasNext()) {
                    current[0] = (DataRow)iter.next();
                    return true;
                }
                return false;
            }, i -> current[0].getColumn(i));
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    private synchronized void printInternal(MetaDataProvider metaDataProvider, int fetchSize, NextProvider next, RowObjectsProvider rowObjectsProvider) throws Exception {
        int[] incCols = null;
        boolean binary = false;
        int cols = metaDataProvider.getMeta().getColumnCount();
        this.maxWidth = new int[cols];
        for (int i = 0; i < this.maxWidth.length; ++i) {
            this.maxWidth[i] = 0;
        }
        boolean[] rightJust = new boolean[cols];
        boolean[] autonulls = new boolean[cols];
        int[] dataType = new int[cols];
        String[] headerArray = new String[cols];
        int insi = -1;
        for (int i = 1; i <= cols; ++i) {
            if (incCols != null) {
                boolean skip = true;
                for (void var18_24 : incCols) {
                    if (i != var18_24) continue;
                    skip = false;
                }
                if (skip) continue;
            }
            if (!this.suppressHeader) {
                try {
                    headerArray[++insi] = metaDataProvider.getMeta().getColumnName(i);
                }
                catch (MetaDataException error) {
                    headerArray[++insi] = "UNKNOWN_COLUMN";
                }
                if (headerArray[insi].length() > this.maxWidth[insi] && headerArray[insi].length() <= this.maxColumnWidth) {
                    this.maxWidth[insi] = headerArray[insi].length();
                }
            } else {
                ++insi;
            }
            try {
                dataType[insi] = metaDataProvider.getMeta().getColumnSQLType(i);
            }
            catch (MetaDataException error) {
                dataType[insi] = 12;
            }
            rightJust[insi] = false;
            autonulls[insi] = true;
        }
        try {
            ArrayList<String[]> rows = new ArrayList<String[]>();
            int loadCount = -1;
            if (fetchSize > 0) {
                loadCount = Math.max(fetchSize, 60);
            }
            while (loadCount != 0 && next.get().booleanValue()) {
                rows.add(this.getRowData(rowObjectsProvider, metaDataProvider.getMeta().getColumnCount(), incCols, binary, dataType, this.maxWidth));
                if (loadCount <= 0) continue;
                --loadCount;
            }
            if (cols > 0 && !this.suppressHeader) {
                int currentColumnWidth;
                int i;
                for (i = 0; i < headerArray.length; ++i) {
                    currentColumnWidth = this.maxWidth[i];
                    if (currentColumnWidth > this.maxColumnWidth) {
                        currentColumnWidth = this.maxColumnWidth;
                    }
                    this.print((i > 0 ? this.spaces(2) : "") + this.pad(this.truncate(headerArray[i], currentColumnWidth), currentColumnWidth, rightJust[i], i < headerArray.length - 1 || rightJust[i]), false);
                }
                this.println("", false);
                for (i = 0; i < headerArray.length; ++i) {
                    currentColumnWidth = this.maxWidth[i];
                    if (currentColumnWidth > this.maxColumnWidth) {
                        currentColumnWidth = this.maxColumnWidth;
                    }
                    this.print((i > 0 ? this.spaces(2) : "") + RowSetPrinter.divider(currentColumnWidth), false);
                }
                this.println("", false);
            }
            boolean interrupted = false;
            while (!interrupted) {
                for (int i = 0; i < rows.size(); ++i) {
                    String[] stringArray = (String[])rows.get(i);
                    this.printRowData(metaDataProvider, stringArray, this.maxWidth, rightJust);
                    if (!this.isStreamInterrupted()) continue;
                    interrupted = true;
                    break;
                }
                if (!interrupted) {
                    loadCount = -1;
                    if (fetchSize > 0) {
                        loadCount = Math.max(fetchSize, 60);
                    }
                    rows.clear();
                    while (loadCount != 0 && next.get().booleanValue()) {
                        if (this.isStreamInterrupted()) {
                            interrupted = true;
                            break;
                        }
                        rows.add(this.getRowData(rowObjectsProvider, metaDataProvider.getMeta().getColumnCount(), incCols, binary, dataType, this.maxWidth));
                        if (loadCount <= 0) continue;
                        --loadCount;
                    }
                    if (rows.size() != 0) continue;
                }
                break;
            }
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, false);
        }
    }

    private String[] getRowData(RowObjectsProvider rowObjectProvider, int columnCount, int[] incCols, boolean binary, int[] dataType, int[] maxWidth) throws SQLException, RowException {
        int insi = -1;
        String[] fieldArray = new String[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            if (incCols != null) {
                boolean skip = true;
                for (int incCol : incCols) {
                    if (i != incCol) continue;
                    skip = false;
                }
                if (skip) continue;
            }
            ++insi;
            Object val = null;
            if (!binary) {
                switch (dataType[insi]) {
                    case 92: {
                        if (!(rowObjectProvider.get(i) instanceof Time)) break;
                        Time time = (Time)rowObjectProvider.get(i);
                        val = time == null ? null : DataspaceDateTime.getSqlTimeString(time.getTime(), this.timezone);
                        break;
                    }
                    case 91: 
                    case 93: {
                        if (rowObjectProvider.get(i) instanceof Timestamp) {
                            Timestamp ts = (Timestamp)rowObjectProvider.get(i);
                            val = ts == null ? null : DataspaceDateTime.getSqlTimestampString(ts, this.timezone);
                        } else if (rowObjectProvider.get(i) instanceof Date) {
                            Date date = (Date)rowObjectProvider.get(i);
                            Object object = val = date == null ? null : DataspaceDateTime.getSqlDateString(date.getTime(), this.timezone);
                        }
                        if (dataType[insi] == 93 || val == null) break;
                        int dotAt = ((String)val).lastIndexOf(46);
                        for (int z = dotAt + 1; z < ((String)val).length(); ++z) {
                            if (((String)val).charAt(z) == '0') continue;
                            dotAt = 0;
                            break;
                        }
                        if (dotAt <= 1) break;
                        val = ((String)val).substring(0, dotAt);
                        break;
                    }
                    case 50: 
                    case 2003: {
                        if (rowObjectProvider.get(i) == null) break;
                        if (rowObjectProvider.get(i).getClass().isArray()) {
                            Object[] data = (Object[])rowObjectProvider.get(i);
                            StringBuilder builder = new StringBuilder();
                            boolean first = true;
                            builder.append("ARRAY[");
                            for (Object dataVal : data) {
                                if (!first) {
                                    builder.append(',');
                                } else {
                                    first = false;
                                }
                                if (dataVal instanceof String) {
                                    builder.append('\'').append(dataVal).append('\'');
                                    continue;
                                }
                                builder.append(dataVal);
                            }
                            builder.append("]");
                            val = builder.toString();
                            break;
                        }
                        val = rowObjectProvider.get(i).toString();
                        break;
                    }
                    default: {
                        Object object = rowObjectProvider.get(i);
                        if (object instanceof Timestamp) {
                            val = DataspaceDateTime.getSqlTimestampString((Timestamp)object, this.timezone);
                            break;
                        }
                        if (object instanceof Time) {
                            val = DataspaceDateTime.getSqlTimeString(((Time)object).getTime(), this.timezone);
                            break;
                        }
                        if (object instanceof Date) {
                            val = DataspaceDateTime.getSqlDateString(((Date)object).getTime(), this.timezone);
                            break;
                        }
                        if (object instanceof java.util.Date) {
                            val = DataspaceDateTime.getJavaDateTimeString((java.util.Date)object, this.timezone);
                            break;
                        }
                        if (object instanceof FlobInfo) {
                            val = "[ FLOB " + ((FlobInfo)object).getId() + " ]";
                            break;
                        }
                        if (object instanceof Facets) {
                            val = FacetsUtils.facetsToString((Facets)object);
                            break;
                        }
                        if (object instanceof Aspects) {
                            val = FacetsUtils.aspectsToString((Aspects)object);
                            break;
                        }
                        if (object == null) break;
                        val = object.toString();
                    }
                }
            }
            fieldArray[insi] = val == null ? this.nullRep : val;
            int currentMaxWidth = fieldArray[insi].length();
            int index = fieldArray[insi].indexOf(10);
            if (index > 0) {
                int rest = currentMaxWidth - index;
                currentMaxWidth = index;
                while (index > 0) {
                    int next = fieldArray[insi].indexOf(10, index + 1);
                    if (next > 0) {
                        if (next - index > currentMaxWidth) {
                            currentMaxWidth = next - index;
                        }
                        rest -= next - index;
                    }
                    index = next;
                }
                if (rest > currentMaxWidth) {
                    currentMaxWidth = rest;
                }
            }
            if (maxWidth == null || currentMaxWidth <= maxWidth[insi]) continue;
            maxWidth[insi] = currentMaxWidth;
        }
        return fieldArray;
    }

    private void println(String s, boolean printHtml) {
        if (printHtml) {
            return;
        }
        if (this.stream != null) {
            this.stream.println(this.indent + s);
        }
    }

    private void print(String s, boolean printHtml) {
        if (printHtml) {
            return;
        }
        if (this.stream != null) {
            this.stream.print(this.indent + s);
        }
    }

    void printColumn(String name, String s, boolean printHtml) {
        PrintStream columnStream;
        PrintStream printStream = columnStream = name != null ? this.columnStreams.get(name) : null;
        if (columnStream != null) {
            columnStream.print(s);
        } else {
            this.print(s, printHtml);
        }
    }

    private void printRowData(MetaDataProvider metaDataProvider, String[] row, int[] maxWidth, boolean[] rightJust) throws MetaDataException {
        String[] temp = new String[row.length];
        System.arraycopy(row, 0, temp, 0, row.length);
        int columnsPrinted = row.length;
        while (columnsPrinted > 0) {
            for (int i = 0; i < temp.length; ++i) {
                String columnName = metaDataProvider != null && metaDataProvider.getMeta() != null ? metaDataProvider.getMeta().getColumnName(i + 1) : null;
                Object current = temp[i];
                int columnWidth = maxWidth[i];
                if (columnWidth > this.maxColumnWidth) {
                    columnWidth = this.maxColumnWidth;
                }
                if (current != null) {
                    int index = ((String)current).indexOf(10);
                    if (index != -1) {
                        current = ((String)current).substring(0, index);
                        temp[i] = temp[i].substring(index + 1);
                        index = ((String)current).lastIndexOf(13);
                        if (index > 0) {
                            current = ((String)current).substring(0, index);
                        }
                        if (((String)current).length() > columnWidth) {
                            current = ((String)current).substring(0, columnWidth - 3);
                            current = (String)current + "...";
                        }
                        this.printColumn(columnName, (i > 0 ? this.spaces(2) : "") + this.pad((String)current, columnWidth, rightJust[i], i < row.length - 1 || rightJust[i]), false);
                        continue;
                    }
                    if (((String)current).length() > columnWidth) {
                        current = ((String)current).substring(0, Math.max(0, Math.min(((String)current).length() - 3, columnWidth - 3)));
                        current = (String)current + "...";
                    }
                    this.printColumn(columnName, (i > 0 ? this.spaces(2) : "") + this.pad((String)current, columnWidth, rightJust[i], i < row.length - 1 || rightJust[i]), false);
                    --columnsPrinted;
                    temp[i] = null;
                    continue;
                }
                this.print((i > 0 ? this.spaces(2) : "") + this.spaces(columnWidth), false);
            }
            this.println("", false);
        }
    }

    private String spaces(int len) {
        return len > SPACES.length() ? SPACES : SPACES.substring(0, len);
    }

    private String truncate(String source, int length) {
        if (source == null) {
            return null;
        }
        if (source.length() > length) {
            return source.substring(0, length - 4) + "...";
        }
        return source;
    }

    private String pad(String inString, int fullLen, boolean rightJustify, boolean doPad) {
        if (!doPad) {
            return inString;
        }
        int len = fullLen - inString.length();
        if (len < 1) {
            return inString;
        }
        String pad = this.spaces(len);
        return (rightJustify ? pad : "") + inString + (rightJustify ? "" : pad);
    }

    public static String divider(int len) {
        return len > DIVIDER.length() ? DIVIDER : DIVIDER.substring(0, len);
    }

    public synchronized RowSetPrinter doPseudoPrint(RowSet rowSet) {
        this.stream = null;
        this.print(rowSet);
        return this;
    }

    public int getMaxColumnWidth(int iColumn) {
        return Math.min(this.maxWidth[iColumn - 1], this.maxColumnWidth);
    }

    public String getDivider(int iColumn) {
        return RowSetPrinter.divider(this.getMaxColumnWidth(iColumn));
    }

    static interface NextProvider {
        public Boolean get() throws SQLException;
    }

    static interface RowObjectsProvider {
        public Object get(Integer var1) throws SQLException, RowException;
    }
}

