/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.Trace;
import com.streamscape.cli.ds.collection.Aspects;
import com.streamscape.cli.ds.collection.Facets;
import com.streamscape.cli.ds.collection.FacetsKeys;
import com.streamscape.cli.ds.collection.FacetsValues;
import com.streamscape.ds.jdbc.JDBCBlobClient;
import com.streamscape.ds.jdbc.JDBCResultSet;
import com.streamscape.ds.parser.expression.URL;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.types.FacetsUtils;
import com.streamscape.ds.types.FlobData;
import com.streamscape.ds.types.FlobInfo;
import com.streamscape.ds.utils.SqlUtils;
import com.streamscape.sdo.rowset.AbstractRowSetFactory;
import com.streamscape.sdo.rowset.AbstractRowSetLobClient;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetBlobClientImpl;
import com.streamscape.sdo.rowset.RowSetClobClientImpl;
import com.streamscape.sdo.rowset.RowSetLobHolder;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.slex.SLSessionData;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class RowSetFactory
extends AbstractRowSetFactory<RowSetFactory> {
    public RowSet createRowSet(ResultSet resultSet) throws SQLException {
        if (resultSet instanceof RowSet) {
            return new RowSet((RowSet)resultSet);
        }
        RowSet rowSet = new RowSet(RowSetFactory.createMetaData(resultSet));
        this.populateDataFromResultSet(rowSet, resultSet);
        rowSet.beforeFirst();
        return rowSet;
    }

    public static RowMetaData createMetaData(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("ResultSet is null");
        }
        try {
            RowMetaData meta = new RowMetaData(resultSet);
            meta.setHash();
            return meta;
        }
        catch (MetaDataException error) {
            throw new SQLException(error.getMessage());
        }
    }

    public Object convertValue(Object value, ColumnDescriptor descriptor, boolean isSingle) throws SQLException {
        if (this.withBlobs) {
            if (value instanceof Blob) {
                if (this.blobSize == -1 || ((Blob)value).length() <= (long)this.blobSize) {
                    return value;
                }
                return new RowSetBlobClientImpl((Blob)value);
            }
            if (value instanceof Clob) {
                if (this.blobSize == -1 || ((Clob)value).length() <= (long)(this.blobSize / 2)) {
                    return value;
                }
                return new RowSetClobClientImpl((Clob)value);
            }
        } else if (value != null && !(value instanceof String) && !TypeFactory.unwrapBoxer(value.getClass()).isPrimitive()) {
            switch (descriptor.getType()) {
                case BLOB: 
                case CLOB: {
                    if (value instanceof Blob) {
                        value = "[ BLOB ]";
                        break;
                    }
                    if (!(value instanceof Clob)) break;
                    value = "[ CLOB ]";
                    break;
                }
                case FLOB: {
                    Long id = null;
                    if (value instanceof FlobData) {
                        id = ((FlobData)value).getId();
                    } else if (value instanceof JDBCBlobClient && ((JDBCBlobClient)value).getBlob() != null) {
                        id = ((JDBCBlobClient)value).getBlob().getId();
                    }
                    value = "[ FLOB " + (String)(id != null ? id + " " : "") + "]";
                    break;
                }
                case EVENT: {
                    value = this.convertValueInNotation(value, "[ EVENT : " + value.getClass().getSimpleName() + " ]");
                    break;
                }
                case FACETS: {
                    value = value instanceof Facets ? FacetsUtils.facetsToString((Facets)value) : value;
                    break;
                }
                case ASPECTS: {
                    value = value instanceof Aspects ? FacetsUtils.aspectsToString((Aspects)value) : value;
                    break;
                }
                case OTHER: {
                    if (value instanceof RowSet && isSingle) {
                        value = RowSetFactory.updateRowSetFromSlang(value);
                        break;
                    }
                    if (value instanceof Row && isSingle) {
                        value = RowSetFactory.updateRowFromSlang((Row)value);
                        break;
                    }
                    if (value.getClass().isEnum()) {
                        value = value.toString();
                        break;
                    }
                    if (value instanceof FlobInfo || value.getClass() == FacetsKeys.class || value.getClass() == FacetsValues.class || TypeFactory.isPrimitive(value.getClass()) || value.getClass() == Date.class) break;
                    value = this.convertValueInNotation(value, "[ OBJECT : " + value.getClass().getSimpleName() + " ]");
                    break;
                }
                case ARRAY: {
                    if (value instanceof java.sql.Array) {
                        value = ((java.sql.Array)value).getArray();
                    }
                    if (this.notation != SLSessionData.DataObjectNotation.none) {
                        Object valueBkp = value;
                        if ("[ ARRAY ]".equals(value = this.convertValueInNotation(value, "[ ARRAY ]"))) {
                            value = valueBkp;
                        }
                    }
                    if (value == null || !value.getClass().isArray() || Array.getLength(value) <= 0) break;
                    String arrayElementClassName = null;
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        Object arrayValue = Array.get(value, i);
                        if (arrayValue == null || TypeFactory.isPrimitive(arrayValue.getClass()) || arrayValue.getClass() == String.class || arrayValue instanceof Date) continue;
                        arrayElementClassName = arrayValue.getClass().getSimpleName();
                        break;
                    }
                    if (arrayElementClassName == null) break;
                    value = this.convertValueInNotation(value, "[ ARRAY : " + arrayElementClassName + " ]");
                    break;
                }
                case URL: {
                    if (!(value instanceof URL)) break;
                    value = ((URL)value).getLink();
                    break;
                }
                case SQLTIMESTAMP: {
                    if (!(value instanceof Timestamp) || value.getClass() == Timestamp.class || !value.getClass().getSimpleName().equals("SybTimestamp")) break;
                    value = new Timestamp(((Timestamp)value).getTime());
                    break;
                }
            }
        }
        return value;
    }

    private Object convertValueInNotation(Object value, String name) {
        return RowSetFactory.convertValueInNotation(value, name, this.notation);
    }

    public static Object convertValueInNotation(Object value, String name, SLSessionData.DataObjectNotation notation) {
        switch (notation) {
            case json: 
            case json_pretty: {
                try {
                    value = HTTPUtils.getJsonSerializerForRest().withPrettyPrint(notation == SLSessionData.DataObjectNotation.json_pretty).serialize(value);
                }
                catch (Exception exception) {
                    Trace.logError(RowSetFactory.class, "Failed to serialize value. Cause: " + exception.getMessage());
                    value = name;
                }
                break;
            }
            case xml: {
                try {
                    value = HTTPUtils.getOrCreateXmlSerializer("XMLSerialzier$RowSetFactory").serialize(value);
                }
                catch (Exception exception) {
                    Trace.logError(RowSetFactory.class, "Failed to serialize value. Cause: " + exception.getMessage());
                    value = name;
                }
                break;
            }
            case none: {
                value = name;
                break;
            }
        }
        return value;
    }

    private void populateDataFromResultSet(RowSet rowSet, ResultSet resultSet) throws SQLException {
        Result result;
        if (resultSet == null) {
            throw new IllegalArgumentException("ResultSet is null.");
        }
        if (rowSet.getMeta() == null) {
            throw new IllegalArgumentException("Metadata is not yet initialized.");
        }
        RowMetaData meta = rowSet.getMeta();
        int columnCount = meta.getColumnCount();
        while (resultSet.next() && (this.fetchSize <= 0 || rowSet.getRowCount() < this.fetchSize)) {
            Row row = new Row(meta);
            try {
                for (int i = 1; i <= columnCount; ++i) {
                    Object value = resultSet.getObject(i);
                    if (resultSet.wasNull()) continue;
                    boolean isLast = false;
                    try {
                        isLast = resultSet.isLast();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    value = this.convertValue(value, meta.getColumnDescriptor(i), isLast && rowSet.getRowCount() == 0 && columnCount == 1);
                    if (this.withBlobs) {
                        row.setColumn(i, value);
                    } else {
                        row.setRawColumn(i, value);
                    }
                    if (!(value instanceof AbstractRowSetLobClient)) continue;
                    rowSet.addRowSetLob(new RowSetLobHolder((AbstractRowSetLobClient)value, rowSet.getRowCount(), i));
                }
            }
            catch (RowException error) {
                throw new SQLException(error);
            }
            rowSet.addToRowSet(row);
        }
        if (resultSet instanceof JDBCResultSet && (result = ((JDBCResultSet)resultSet).result) != null && result.statement != null) {
            rowSet.setParserStatement(result.statement);
        }
    }

    public static Object updateRowSetFromSlang(Object value) {
        if (!(value instanceof RowSet)) {
            return value;
        }
        try {
            RowSet rowSet = (RowSet)value;
            rowSet.beforeFirst();
            RowSet newRowSet = new RowSet(rowSet.getRowMetaData());
            while (rowSet.next()) {
                Row row = rowSet.getCurrentRow();
                Row newRow = newRowSet.newRow();
                newRowSet.addToRowSet(RowSetFactory.updateRowFromSlang(row, newRow));
            }
            value = newRowSet;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    private static Row updateRowFromSlang(Row row, Row newRow) throws SQLException, RowException {
        for (int index = 1; index <= row.getColumnCount(); ++index) {
            Object v = row.getColumn(index);
            if (v != null) {
                v = v.toString();
            }
            newRow.setColumn(index, v);
        }
        return newRow;
    }

    private static Row updateRowFromSlang(Row row) {
        Row newRow = new Row(row.getMetaData());
        try {
            return RowSetFactory.updateRowFromSlang(row, newRow);
        }
        catch (Exception exception) {
            Trace.logError(SqlUtils.class, "Converting Row values failed. Cause: " + exception.getMessage());
            return row;
        }
    }
}

