/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.sdo.rowset.AbstractRowSetLobProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class RowSetClobProxy
extends AbstractRowSetLobProxy
implements Clob {
    RowSetClobProxy(long id) {
        super(id);
    }

    @Override
    public long length() throws SQLException {
        return ((Number)this.invokeMethodWithReturn("length", new Object[0])).longValue();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        return (String)this.invokeMethodWithReturn("getSubString", pos, length);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        return (Long)this.invokeMethodWithReturn("position", searchstr, start);
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        return (Long)this.invokeMethodWithReturn("position", searchstr.getSubString(1L, (int)searchstr.length()), start);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return (Integer)this.invokeMethodWithReturn("setString", pos, str);
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        return (Integer)this.invokeMethodWithReturn("setString", pos, str, offset, len);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.invokeMethod("truncate", len);
    }

    @Override
    public void free() throws SQLException {
        this.invokeMethod("free", new Object[0]);
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        return new RowSetClobReaderProxy(pos, length);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new RowSetClobReaderProxy();
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        throw new SQLException("getAsciiStream for clob not implemented yet.");
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new SQLException("setAsciiStream for clob not implemented yet.");
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        throw new SQLException("setCharacterStream for clob not implemented yet.");
    }

    private class RowSetClobReaderProxy
    extends Reader {
        private long startOffset = 0L;
        private long offset = 0L;
        private long maxLength = Long.MAX_VALUE;
        private boolean isClosed = false;

        public RowSetClobReaderProxy() throws SQLException {
            this(1L, Long.MAX_VALUE);
        }

        public RowSetClobReaderProxy(long pos, long length) throws SQLException {
            this.startOffset = pos - 1L;
            this.maxLength = length;
            length = RowSetClobProxy.this.length();
            if (this.startOffset < 0L || this.startOffset >= length) {
                throw new IllegalArgumentException("pos is negative of greater than clob length");
            }
            if (this.startOffset + this.maxLength > length) {
                this.maxLength = length - this.startOffset;
            }
        }

        @Override
        public int read() throws IOException {
            this.checkClosed();
            if (this.offset >= this.maxLength) {
                return -1;
            }
            String s = this.getSubStringForReader(this.startOffset + this.offset, 1);
            if (s == null || s.length() != 1) {
                return -1;
            }
            ++this.offset;
            return s.charAt(0);
        }

        @Override
        public int read(char[] b, int off, int len) throws IOException {
            this.checkClosed();
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.offset >= this.maxLength) {
                return -1;
            }
            if ((len = (int)Math.min((long)len, this.maxLength - this.offset)) <= 0) {
                return -1;
            }
            String s = this.getSubStringForReader(this.startOffset + this.offset, len);
            if (s == null || s.length() == 0) {
                return -1;
            }
            len = Math.min(s.length(), len);
            s.getChars(0, len, b, off);
            this.offset += (long)len;
            return len;
        }

        @Override
        public long skip(long n) throws IOException {
            this.checkClosed();
            long length = Math.min(this.maxLength, this.lengthForStream() - this.startOffset);
            long oldOffset = this.offset;
            this.offset += n;
            if (this.offset < 0L) {
                this.offset = 0L;
            }
            if (this.offset > length) {
                this.offset = length;
            }
            return this.offset - oldOffset;
        }

        @Override
        public void close() throws IOException {
            this.isClosed = true;
        }

        private void checkClosed() throws IOException {
            if (this.isClosed) {
                throw new IOException("Blob input strea is closed.");
            }
        }

        private String getSubStringForReader(long offset, int length) throws IOException {
            try {
                return RowSetClobProxy.this.getSubString(offset + 1L, length);
            }
            catch (SQLException exception) {
                throw new IOException(exception.getMessage());
            }
        }

        private long lengthForStream() throws IOException {
            try {
                return RowSetClobProxy.this.length();
            }
            catch (SQLException exception) {
                throw new IOException(exception.getMessage());
            }
        }
    }
}

