/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.ds.mf.SLDataspaceCall;
import com.streamscape.sdo.rowset.AbstractRowSetLobClient;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetBlobClientImpl;
import com.streamscape.sdo.rowset.RowSetClient;
import com.streamscape.sdo.rowset.RowSetClobProxy;
import com.streamscape.sdo.rowset.RowSetFactory;
import com.streamscape.sdo.rowset.RowSetLobHolder;
import com.streamscape.sdo.rowset.RowSetProxy;
import com.streamscape.sef.dii.AccessibleObject;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.dii.AccessibleObjectsCache;
import com.streamscape.sef.dii.AccessibleObjectsCacheException;
import com.streamscape.slex.SLSessionData;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RowSetClientResultSetImpl
implements RowSetClient {
    private ResultSet resultSet;
    private RowSetProxy proxy;
    private boolean isScrollable;
    private List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private boolean withBlobs;
    private int blobSize;
    private SLSessionData.DataObjectNotation notation;
    private RowMetaData meta;
    private AccessibleObjectsCache cache = new AccessibleObjectsCache();

    RowSetClientResultSetImpl(ResultSet resultSet, RowSet rowSet, boolean withBlobs, int blobSize, SLSessionData.DataObjectNotation notation) throws SQLException {
        this.resultSet = resultSet;
        this.proxy = new RowSetProxy(resultSet, rowSet);
        this.isScrollable = this.proxy.isScrollable();
        this.withBlobs = withBlobs;
        this.blobSize = blobSize;
        this.notation = notation;
        this.meta = this.proxy.meta;
        for (RowSetLobHolder holder : rowSet.getRowSetLobHolders().values()) {
            this.cache.putAccessibleObject(holder.getLob().getId(), holder.getLob());
        }
        rowSet.replaceRowSetLobsWithProxies();
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        RowSetProxy result = this.proxy;
        this.proxy = null;
        return result;
    }

    public void addCloseableObject(AutoCloseable object) {
        this.closeables.add(object);
    }

    @Override
    public void close() throws IOException {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        for (AutoCloseable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Exception exception) {}
        }
        this.cache.clearAndCloseAll();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.resultSet.last();
    }

    @Override
    public boolean last() throws SQLException {
        return this.resultSet.last();
    }

    @Override
    public int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.resultSet.absolute(row + 1);
    }

    @Override
    public Object[][] fetchRows(int offset, int fetchSize) throws SQLException {
        if (this.isScrollable) {
            if (offset >= 0) {
                ++offset;
            }
            if (!this.resultSet.absolute(offset)) {
                throw new SQLException("Failed to set cursor position to " + offset);
            }
        } else {
            while (offset > this.resultSet.getRow() && !this.resultSet.isAfterLast()) {
                this.resultSet.next();
            }
            if (offset != this.resultSet.getRow() - 1 && this.resultSet.getRow() != 0 && !this.resultSet.isAfterLast()) {
                throw new SQLException("Wrong offset passed to forward only ResultSet, offset: " + offset + ", rowNum: " + this.resultSet.getRow());
            }
        }
        if (this.resultSet.isAfterLast()) {
            return new Object[0][];
        }
        Object[][] result = fetchSize > 0 ? new Object[fetchSize][] : new Object[1][];
        RowSetFactory rowSetFactory = (RowSetFactory)((RowSetFactory)((RowSetFactory)((RowSetFactory)new RowSetFactory().setFetchSize(fetchSize)).setBlobSize(this.blobSize)).setWithBlobs(this.withBlobs)).setNotation(this.notation);
        int index = 0;
        do {
            if (index >= result.length) {
                result = (Object[][])Arrays.copyOf(result, result.length * 2);
            }
            result[index] = new Object[this.resultSet.getMetaData().getColumnCount()];
            Object[] row = result[index];
            for (int i = 0; i < this.resultSet.getMetaData().getColumnCount(); ++i) {
                row[i] = rowSetFactory.convertValue(this.resultSet.getObject(i + 1), this.meta.getColumnDescriptor(i + 1), false);
                if (row[i] instanceof AbstractRowSetLobClient) {
                    AbstractRowSetLobClient lob = (AbstractRowSetLobClient)row[i];
                    this.cache.putAccessibleObject(lob.getId(), lob);
                    row[i] = lob.getProxy();
                    continue;
                }
                if (row[i] instanceof Blob) {
                    row[i] = ((Blob)row[i]).getBytes(1L, (int)((Blob)row[i]).length());
                    continue;
                }
                if (!(row[i] instanceof Clob)) continue;
                row[i] = ((Clob)row[i]).getSubString(1L, (int)((Clob)row[i]).length());
            }
        } while (this.resultSet.next() && (fetchSize <= 0 || ++index < fetchSize));
        if (index < result.length) {
            result = (Object[][])Arrays.copyOf(result, index);
        }
        return result;
    }

    public RowSetClobProxy castToRowSetClobProxy(long id) throws SQLException {
        AccessibleObject accessibleObject = this.cache.getAccessibleObject(id);
        if (accessibleObject == null) {
            throw new SQLException("Unable to find callable object for id '" + id + "'.");
        }
        accessibleObject = ((RowSetBlobClientImpl)accessibleObject).getClobAdapter();
        this.cache.removeAccessibleObject(id);
        return (RowSetClobProxy)this.cache.putAndConvertToProxy(accessibleObject);
    }

    public Object invokeRowSetBlobMethod(long id, String methodName, Object[] params) throws SQLException {
        try {
            return this.cache.invoke(new SLDataspaceCall(id, methodName, params));
        }
        catch (AccessibleObjectsCacheException exception) {
            throw new SQLException(exception.getMessage(), exception.getCause());
        }
    }
}

