/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetClient;
import com.streamscape.sdo.rowset.RowSetProxy;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;

public class RowSetClientIteratorImpl
implements RowSetClient {
    private Iterator iterator;
    private RowSetProxy proxy;
    private int index;
    private Object last = null;
    private boolean isAfterLast = false;

    public RowSetClientIteratorImpl(int fetchSize, Iterator iterator, RowSet rowSet) {
        this.iterator = iterator;
        this.proxy = new RowSetProxy(rowSet);
        try {
            this.proxy.setFetchSize(fetchSize);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.index = rowSet.getRowCount();
        this.last = iterator.next();
    }

    @Override
    public AccessibleObjectProxy getProxy() {
        RowSetProxy result = this.proxy;
        this.proxy = null;
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.iterator instanceof Closeable) {
            ((Closeable)((Object)this.iterator)).close();
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.isAfterLast;
    }

    @Override
    public boolean isLast() throws SQLException {
        return !this.isAfterLast && !this.iterator.hasNext();
    }

    @Override
    public boolean last() throws SQLException {
        while (this.iterator.hasNext()) {
            this.last = this.iterator.next();
            ++this.index;
        }
        return this.index >= 0;
    }

    @Override
    public int getRow() throws SQLException {
        return this.index + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        for (row = row - this.index - 1; row > 0 && this.iterator.hasNext(); --row) {
            this.last = this.iterator.next();
            ++this.index;
        }
        return row == 0;
    }

    @Override
    public Object[][] fetchRows(int offset, int fetchSize) throws SQLException {
        if (offset < 0) {
            throw new SQLException("Wrong offset passed to forward only iterator, offset: " + offset + ".");
        }
        if (!this.absolute(offset + 1)) {
            throw new SQLException("Failed to set cursor position to " + offset);
        }
        if (this.isAfterLast()) {
            return new Object[0][];
        }
        Object[][] result = fetchSize > 0 ? new Object[fetchSize][] : new Object[1][];
        int count = 0;
        do {
            if (count >= result.length) {
                result = (Object[][])Arrays.copyOf(result, result.length * 2);
            }
            result[count] = new Object[1];
            result[count][0] = this.last;
            boolean bl = this.isAfterLast = !this.iterator.hasNext();
            if (!this.isAfterLast) {
                this.last = this.iterator.next();
            }
            ++this.index;
        } while (!this.isAfterLast && (fetchSize <= 0 || ++count < fetchSize));
        if (count < result.length) {
            result = (Object[][])Arrays.copyOf(result, count);
        }
        return result;
    }
}

