/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.ds.utils.RowSetFactoryForDSResult;
import com.streamscape.sdo.rowset.AbstractRowSetFactory;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetClientResultSetImpl;
import com.streamscape.sdo.rowset.RowSetFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class RowSetClientFactory
extends AbstractRowSetFactory<RowSetClientFactory> {
    public Object createRowSetClientResponse(Statement statement, String query) throws SQLException {
        ResultSet resultSet = statement.getResultSet();
        if (resultSet == null) {
            int updateCount = statement.getUpdateCount();
            boolean isUpdateCount = RowSetFactoryForDSResult.isUpdateCountResult(query, updateCount);
            while (statement.getMoreResults() && (statement.getUpdateCount() != -1 || (resultSet = statement.getResultSet()) == null)) {
            }
            if (resultSet == null && isUpdateCount) {
                return RowSetFactoryForDSResult.createUpdateCountRowSet(updateCount);
            }
            if (resultSet == null && statement.getWarnings() != null) {
                RowMetaData meta = new RowMetaData(1);
                meta.addColumn("WARNING", String.class);
                RowSet rowSet = new RowSet(meta);
                for (SQLWarning warning = statement.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    rowSet.addToRowSet(new Object[]{warning.getMessage()});
                }
                return rowSet;
            }
            if (resultSet == null) {
                return null;
            }
        }
        if (this.fetchSize >= 0) {
            resultSet.setFetchSize(this.fetchSize);
        }
        RowSet rowSet = ((RowSetFactory)new RowSetFactory().set(this)).createRowSet(resultSet);
        if ((resultSet.getFetchSize() <= 0 || resultSet.isAfterLast() || rowSet.getRowCount() == 0) && !rowSet.containsLobProxies()) {
            return rowSet;
        }
        return new RowSetClientResultSetImpl(resultSet, rowSet, this.withBlobs, this.blobSize, this.notation);
    }
}

