/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.lib.utils.SQLType;
import com.streamscape.sdo.rowset.AbstractRowSetLobProxy;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetClobProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class RowSetBlobProxy
extends AbstractRowSetLobProxy
implements Blob {
    RowSetBlobProxy(long id) {
        super(id);
    }

    @Override
    public long length() throws SQLException {
        return ((Number)this.invokeMethodWithReturn("length", new Object[0])).longValue();
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        Object result = this.invokeMethodWithReturn("getBytes", pos, length);
        if (result instanceof String) {
            result = RowSet.convertStringToBytes((String)result, SQLType.BLOB);
        }
        return (byte[])result;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        return ((Number)this.invokeMethodWithReturn("position", pattern, start)).longValue();
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(0L, (int)pattern.length()), start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return ((Number)this.invokeMethodWithReturn("setBytes", pos, bytes)).intValue();
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        return ((Number)this.invokeMethodWithReturn("setBytes", pos, bytes, offset, len)).intValue();
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.invokeMethod("truncate", len);
    }

    @Override
    public void free() throws SQLException {
        this.invokeMethod("free", new Object[0]);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new RowSetBlobInputStreamProxy();
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return new RowSetBlobInputStreamProxy(pos, length);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLException("setBinaryStream for blob not implemented yet.");
    }

    public RowSetClobProxy castToRowSetClobProxy() throws SQLException {
        return (RowSetClobProxy)this.rowSetProxy.invokeRowSetMethodWithReturn(this.getId(), "castToRowSetClobProxy");
    }

    private class RowSetBlobInputStreamProxy
    extends InputStream {
        private long startOffset = 0L;
        private long offset = 0L;
        private long maxLength = Long.MAX_VALUE;
        private boolean isClosed = false;

        public RowSetBlobInputStreamProxy() throws SQLException {
            this(1L, Long.MAX_VALUE);
        }

        public RowSetBlobInputStreamProxy(long pos, long length) throws SQLException {
            this.startOffset = pos - 1L;
            this.maxLength = length;
            length = RowSetBlobProxy.this.length();
            if (this.startOffset < 0L || this.startOffset >= length) {
                throw new IllegalArgumentException("pos is negative of greater than blob length");
            }
            if (this.startOffset + this.maxLength > length) {
                this.maxLength = length - this.startOffset;
            }
        }

        @Override
        public int read() throws IOException {
            this.checkClosed();
            if (this.offset >= this.maxLength) {
                return -1;
            }
            byte[] bytes = this.getBytesForStream(this.startOffset + this.offset, 1);
            if (bytes == null || bytes.length == 0) {
                return -1;
            }
            ++this.offset;
            return bytes[0];
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.checkClosed();
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.offset >= this.maxLength) {
                return -1;
            }
            if ((len = (int)Math.min((long)len, this.maxLength - this.offset)) <= 0) {
                return -1;
            }
            byte[] bytes = this.getBytesForStream(this.startOffset + this.offset, len);
            if (bytes == null || bytes.length == 0) {
                return -1;
            }
            len = Math.min(bytes.length, len);
            System.arraycopy(bytes, 0, b, off, len);
            this.offset += (long)len;
            return len;
        }

        @Override
        public long skip(long n) throws IOException {
            this.checkClosed();
            long length = Math.min(this.maxLength, this.lengthForStream() - this.startOffset);
            long oldOffset = this.offset;
            this.offset += n;
            if (this.offset < 0L) {
                this.offset = 0L;
            }
            if (this.offset > length) {
                this.offset = length;
            }
            return this.offset - oldOffset;
        }

        @Override
        public int available() throws IOException {
            this.checkClosed();
            long length = Math.min(this.maxLength, this.lengthForStream() - this.startOffset);
            long avaliable = length - this.offset;
            if (avaliable > Integer.MAX_VALUE) {
                avaliable = Integer.MAX_VALUE;
            }
            return (int)avaliable;
        }

        @Override
        public void close() throws IOException {
            this.isClosed = true;
        }

        private void checkClosed() throws IOException {
            if (this.isClosed) {
                throw new IOException("Blob input strea is closed.");
            }
        }

        private byte[] getBytesForStream(long offset, int length) throws IOException {
            try {
                return RowSetBlobProxy.this.getBytes(offset + 1L, length);
            }
            catch (SQLException exception) {
                throw new IOException(exception.getMessage());
            }
        }

        private long lengthForStream() throws IOException {
            try {
                return RowSetBlobProxy.this.length();
            }
            catch (SQLException exception) {
                throw new IOException(exception.getMessage());
            }
        }
    }
}

