/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.Trace;
import com.streamscape.ds.jdbc.Util;
import com.streamscape.ds.lib.CharArrayWriter;
import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.ds.lib.HsqlByteArrayOutputStream;
import com.streamscape.ds.lib.MD5;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.lib.StringInputStream;
import com.streamscape.ds.stable.table.DataFrame;
import com.streamscape.lib.utils.Base64;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.rowset.AbstractRowSetLobProxy;
import com.streamscape.sdo.rowset.ArrayImpl;
import com.streamscape.sdo.rowset.BlobImpl;
import com.streamscape.sdo.rowset.ClobImpl;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.MetaDataProvider;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSetBlobClientImpl;
import com.streamscape.sdo.rowset.RowSetBlobProxy;
import com.streamscape.sdo.rowset.RowSetChangedEvent;
import com.streamscape.sdo.rowset.RowSetClobClientImpl;
import com.streamscape.sdo.rowset.RowSetClobProxy;
import com.streamscape.sdo.rowset.RowSetInterface;
import com.streamscape.sdo.rowset.RowSetListener;
import com.streamscape.sdo.rowset.RowSetLobHolder;
import com.streamscape.sdo.rowset.RowSetPrinter;
import com.streamscape.sdo.rowset.RowSetProxy;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.SQLQueryParameterList;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import com.streamscape.sdo.tuple.CollectionTupleSet;
import com.streamscape.sdo.utils.SDOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RowSet
extends MetaDataProvider
implements RowSetInterface {
    protected transient int currentRow = -1;
    private transient boolean wasNullValue = false;
    protected RowMetaData meta = null;
    private Object returnCodeValue = null;
    private Object[] outParameterValues = null;
    protected List<Row> rows = null;
    private boolean readOnly = false;
    private byte[] encryptedPassword = null;
    private transient List<RowSetListener> listeners = null;
    private transient int pageSize = 0;
    private transient Map<Long, RowSetLobHolder> rowSetLobHolders;
    private transient com.streamscape.ds.parser.statement.Statement parserStatement;

    public RowSet() {
        this.meta = new RowMetaData();
        this.rows = new ArrayList<Row>();
    }

    public RowSet(RowMetaData descriptor) {
        this.meta = descriptor;
        this.meta.setHash();
        this.rows = new ArrayList<Row>();
        if (descriptor.getOutParameterCount() > 0) {
            this.outParameterValues = new Object[descriptor.getOutParameterCount()];
        }
        try {
            this.beforeFirst();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RowSet(RowSet set) throws SQLException {
        this.meta = set.getRowMetaData();
        this.populateData(set);
        this.beforeFirst();
    }

    public RowSet(String[] columnNames, Object[] values) throws SQLException {
        this.meta = new RowMetaData(1);
        for (int i = 0; i < columnNames.length; ++i) {
            this.meta.addColumn(columnNames[i], values[i] != null ? values[i].getClass() : Object.class);
        }
        this.rows = new ArrayList<Row>();
        Row row = new Row(this.meta);
        try {
            for (int i = 0; i < values.length; ++i) {
                row.setColumn(i + 1, values[i]);
            }
        }
        catch (RowException error) {
            throw new SQLException(error.getMessage());
        }
        this.rows.add(row);
        this.beforeFirst();
    }

    @Override
    public RowMetaData getRowMetaData() {
        if (this.meta != null) {
            return this.meta.clone();
        }
        return null;
    }

    @Override
    public RowMetaData getMeta() {
        return this.meta;
    }

    @Override
    public Object getReturnCodeValue() {
        return this.returnCodeValue;
    }

    @Override
    public void setReturnCodeValue(Object code) {
        this.returnCodeValue = code;
    }

    @Override
    public int getOutParameterIndex(String name) {
        if (this.meta.getOutParameterNames() == null) {
            return -1;
        }
        for (int i = 0; i < this.meta.getOutParameterNames().length; ++i) {
            if (!this.meta.getOutParameterNames()[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getOutParameterName(int index) {
        if (this.meta.getOutParameterNames() == null) {
            return null;
        }
        if (index < 0 || index >= this.meta.getOutParameterCount()) {
            return null;
        }
        return this.meta.getOutParameterNames()[index];
    }

    @Override
    public Object getOutParameterValue(int index) {
        if (index < 0 || index >= this.outParameterValues.length) {
            return null;
        }
        return this.outParameterValues[index];
    }

    @Override
    public void setOutParameterValue(String name, Object value) throws RowException {
        int index = this.getOutParameterIndex(name);
        if (index == -1) {
            throw new RowException("Specified index is out of bounds.");
        }
        this.setOutParameterValue(index, value);
    }

    @Override
    public void setOutParameterValue(int index, Object value) throws RowException {
        block5: {
            if (this.getOutParameterName(index) == null) {
                throw new RowException("Specified index is out of bounds.");
            }
            try {
                Class<?> dataType = this.getMeta().getOutputParameterTypeClass(index);
                if (dataType.isAssignableFrom(value.getClass())) {
                    this.outParameterValues[index] = value;
                    break block5;
                }
                if (dataType.equals(String.class) && value.getClass().isEnum()) {
                    this.outParameterValues[index] = ((Enum)value).name();
                    break block5;
                }
                throw new RowException("Incompatible data type '" + value.getClass().getName() + "', expected '" + dataType.getName() + "'.");
            }
            catch (MetaDataException error) {
                throw new RowException(error.getMessage());
            }
        }
    }

    @Override
    public Object getOutParameterValue(String name) {
        int index = this.getOutParameterIndex(name);
        if (index >= 0) {
            return this.outParameterValues[index];
        }
        return null;
    }

    @Override
    public void populateOutParameters(CallableStatement callable, SQLQueryParameterList parameters) throws SQLException {
        if (parameters == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(10);
        ArrayList<Object> values = new ArrayList<Object>(10);
        ArrayList<SQLType> types = new ArrayList<SQLType>(10);
        Iterator<SQLQueryParameter> iterator = parameters.iterator();
        while (iterator.hasNext()) {
            SQLQueryParameter param = iterator.next();
            if (param.getMode() != SQLQueryParameterMode.OUT.getMode() && param.getMode() != SQLQueryParameterMode.INOUT.getMode()) continue;
            String name = param.getName();
            Object value = callable.getObject(param.getOrdinal());
            if (param.isReturnCode()) {
                this.meta.setHasReturnCode(true);
                this.returnCodeValue = value;
                continue;
            }
            names.add(name);
            types.add(SQLType.typeForId(param.getType()));
            values.add(value);
        }
        String[] outParameterNames = new String[names.size()];
        names.toArray(outParameterNames);
        this.meta.setOutParameterNamesAndTypes(outParameterNames, types.toArray(new SQLType[types.size()]));
        this.outParameterValues = values.toArray();
    }

    @Override
    @Deprecated
    public boolean addRow(Object[] rowValues) {
        try {
            Row row = new Row(this);
            for (int i = 1; i <= rowValues.length; ++i) {
                row.setColumn(i, rowValues[i - 1]);
            }
            this.rows.add(row);
            this.notifyRowAdded(this.rows.size());
            return true;
        }
        catch (Exception error) {
            return false;
        }
    }

    @Override
    public synchronized void addToRowSet(Object[] rowValues) throws SQLException {
        this.checkRowSetIsUpdateable();
        if (rowValues.length != this.meta.getColumnCount()) {
            throw new SQLException("Provided values count and row columns count mismatch.");
        }
        try {
            Row row = new Row(this);
            for (int i = 1; i <= rowValues.length; ++i) {
                row.setColumn(i, rowValues[i - 1]);
            }
            this.rows.add(row);
            this.notifyRowAdded(this.rows.size());
        }
        catch (Exception error) {
            throw new SQLException(error.getMessage());
        }
    }

    @Override
    public synchronized void addToRowSet(Row row) throws SQLException {
        this.checkRowSetIsUpdateable();
        if (row.provider != this) {
            if (row.meta != null && row.meta.hash != this.meta.hash) {
                throw new SQLException("Meta data mismatch.");
            }
            row.provider = this;
            row.meta = null;
        }
        this.rows.add(row);
        this.notifyRowAdded(this.rows.size());
    }

    public synchronized void addAll(RowSet other) throws SQLException {
        this.checkRowSetIsUpdateable();
        if (other.rows != null) {
            for (Row row : other.rows) {
                if (row.meta != null && row.meta.hash != this.meta.hash) {
                    throw new SQLException("Meta data mismatch.");
                }
                row.provider = this;
                row.meta = null;
                this.rows.add(row);
                this.notifyRowAdded(this.rows.size());
            }
        }
    }

    @Override
    public synchronized Row deleteFromRowSet(int index) throws SQLException {
        this.checkRowSetIsUpdateable();
        if (index < 1 || index > this.rows.size()) {
            throw new SQLException("Row index is out of range.");
        }
        Row deletedRow = this.rows.remove(index - 1);
        this.notifyRowDeleted(deletedRow);
        if (this.currentRow + 1 >= index) {
            --this.currentRow;
        }
        return deletedRow;
    }

    @Override
    public synchronized void insertIntoRowSet(int index, Row row) throws SQLException {
        this.checkRowSetIsUpdateable();
        if (index < 1 || index > this.rows.size()) {
            throw new SQLException("Row index is out of range.");
        }
        if (row.provider != this) {
            if (row.meta != null || row.meta.hash != this.meta.hash) {
                throw new SQLException("Meta data mismatch.");
            }
            row.provider = this;
            row.meta = null;
        }
        this.rows.add(index - 1, row);
        this.notifyRowAdded(index);
    }

    @Override
    public synchronized void insertIntoRowSet(int index, Object[] rowValues) throws SQLException {
        this.checkRowSetIsUpdateable();
        if (index < 1 || index > this.rows.size()) {
            throw new SQLException("Row index is out of range.");
        }
        if (rowValues.length != this.meta.getColumnCount()) {
            throw new SQLException("Provided values count and row columns count mismatch.");
        }
        try {
            Row row = new Row(this);
            for (int i = 1; i <= rowValues.length; ++i) {
                row.setColumn(i, rowValues[i - 1]);
            }
            this.insertIntoRowSet(index, row);
        }
        catch (Exception error) {
            throw new SQLException(error.getMessage());
        }
    }

    @Override
    public synchronized List<ColumnDescriptor> updateRowSet(int index, Row row) throws SQLException {
        this.checkRowSetIsUpdateable();
        if (index < 1 || index > this.rows.size()) {
            throw new SQLException("Row index is out of range.");
        }
        if (row.provider != this) {
            if (row.meta != null || row.meta.hash != this.meta.hash) {
                throw new SQLException("Meta data mismatch.");
            }
            row.provider = this;
            row.meta = null;
        }
        ArrayList<ColumnDescriptor> columnDescriptors = new ArrayList<ColumnDescriptor>();
        try {
            Row oldRow = this.getRowAt(index);
            for (int i = 1; i <= row.getColumnCount(); ++i) {
                Object oldRowValue = oldRow.getColumn(i);
                Object rowValue = row.getColumn(i);
                if ((oldRowValue != null || rowValue == null) && (oldRowValue == null || oldRowValue.equals(rowValue))) continue;
                columnDescriptors.add(this.meta.getColumnDescriptor(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.rows.set(index - 1, row);
        this.notifyRowUpdated(index);
        return columnDescriptors;
    }

    @Override
    public synchronized List<ColumnDescriptor> updateRowSet(int index, Object[] rowValues) throws SQLException {
        this.checkRowSetIsUpdateable();
        if (index < 1 || index > this.rows.size()) {
            throw new SQLException("Row index is out of range.");
        }
        if (rowValues.length != this.meta.getColumnCount()) {
            throw new SQLException("Provided values count and row columns count mismatch.");
        }
        try {
            Row row = this.getRowAt(index);
            ArrayList<ColumnDescriptor> columnDescriptors = new ArrayList<ColumnDescriptor>();
            for (int i = 1; i <= rowValues.length; ++i) {
                Object rowValue = row.getColumn(i);
                if ((rowValue != null || rowValues[i - 1] == null) && (rowValue == null || rowValue.equals(rowValues[i - 1]))) continue;
                row.setColumn(i, rowValues[i - 1]);
                columnDescriptors.add(this.meta.getColumnDescriptor(i));
            }
            if (!columnDescriptors.isEmpty()) {
                this.notifyRowUpdated(index);
            }
            return columnDescriptors;
        }
        catch (Exception error) {
            throw new SQLException(error.getMessage());
        }
    }

    @Override
    public Row getRowAt(int index) throws SQLException {
        if (index < 1 || index > this.rows.size()) {
            throw new SQLException("Row index is out of range.");
        }
        return this.rows.get(index - 1);
    }

    @Override
    public Row newRow() {
        return new Row(this);
    }

    @Override
    public boolean isEmpty() {
        return !(this.outParameterValues != null && this.outParameterValues.length > 0 || this.meta.hasReturnCode() && this.returnCodeValue != null || this.rows.size() > 0);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isProtected()) {
            throw new SQLException("RowSet is protected by password, failed to change read only flag.");
        }
        this.readOnly = readOnly;
    }

    @Override
    public boolean isProtected() {
        return this.encryptedPassword != null;
    }

    @Override
    public void protect(String password) throws SQLException {
        byte[] digest = MD5.digest(password, null);
        if (this.encryptedPassword != null) {
            if (!Arrays.equals(this.encryptedPassword, digest)) {
                throw new SQLException("RowSet is already protected, failed to ptotect with wrong password.");
            }
        } else {
            this.encryptedPassword = digest;
        }
    }

    @Override
    public void unprotect(String password) throws SQLException {
        byte[] digest = MD5.digest(password, null);
        if (this.encryptedPassword != null) {
            if (!Arrays.equals(this.encryptedPassword, digest)) {
                throw new SQLException("Wrong password. Failed to unprotect RowSet.");
            }
            this.encryptedPassword = null;
        }
    }

    @Override
    public void addRowSetListener(RowSetListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<RowSetListener>();
        }
        boolean exists = false;
        for (RowSetListener l : this.listeners) {
            if (l != listener) continue;
            exists = true;
        }
        if (!exists) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeRowSetListener(RowSetListener listener) {
        if (this.listeners == null || listener == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (listener != this.listeners.get(i)) continue;
            this.listeners.remove(i);
            break;
        }
    }

    private void notifyRowDeleted(Row row) {
        if (this.listeners == null) {
            return;
        }
        RowSetChangedEvent event = new RowSetChangedEvent(this, row);
        for (RowSetListener listener : this.listeners) {
            listener.rowDeleted(event);
        }
    }

    private void notifyRowUpdated(int index) {
        if (this.listeners == null) {
            return;
        }
        RowSetChangedEvent event = new RowSetChangedEvent(this, index, this.rows.get(index - 1));
        for (RowSetListener listener : this.listeners) {
            listener.rowUpdated(event);
        }
    }

    private void notifyRowAdded(int index) {
        if (this.listeners == null) {
            return;
        }
        RowSetChangedEvent event = new RowSetChangedEvent(this, index, this.rows.get(index - 1));
        for (RowSetListener listener : this.listeners) {
            listener.rowAdded(event);
        }
    }

    private void notifyRowUpdated() {
        this.notifyRowUpdated(this.currentRow + 1);
    }

    @Override
    public RowSet selectFromRowSet(int startRowIndex, int endRowIndex) throws SQLException {
        if (startRowIndex < 1 || startRowIndex > this.rows.size()) {
            throw new SQLException("Start row index is out of range.");
        }
        if (endRowIndex < 1 || endRowIndex > this.rows.size()) {
            throw new SQLException("End row index is out of range.");
        }
        if (startRowIndex > endRowIndex) {
            throw new SQLException("Start row index is greater then end row index.");
        }
        RowSet rowSet = new RowSet(this.getRowMetaData());
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            rowSet.addToRowSet(this.rows.get(i - 1));
        }
        return rowSet;
    }

    @Override
    public RowSet selectFromRowSet(String columnName, Object columnValue) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        if (columnIndex == -1) {
            throw new SQLException("Column with provided name does not exist.");
        }
        RowSet rowSet = new RowSet(this.getRowMetaData());
        for (Row row : this.rows) {
            try {
                Object value = row.getColumn(columnIndex);
                if ((value != null || columnValue != null) && (value == null || !value.equals(columnValue))) continue;
                rowSet.addToRowSet(row);
            }
            catch (RowException e) {
                throw new SQLException(e.getMessage());
            }
            finally {
                if (rowSet == null) continue;
                try {
                    rowSet.close();
                }
                catch (Exception exception) {}
            }
        }
        return rowSet;
    }

    protected void populateMetaData(ResultSet set) throws SQLException {
        this.meta = RowSet.createMetaData(set);
    }

    private void populateData(ResultSet set) throws SQLException {
        if (set == null) {
            throw new IllegalArgumentException("ResultSet is null.");
        }
        if (this.meta == null) {
            throw new IllegalArgumentException("Metadata is not yet initialized.");
        }
        this.rows = new ArrayList<Row>();
        int columnCount = this.meta.getColumnCount();
        while (set.next()) {
            Row row = new Row(this);
            try {
                for (int i = 1; i <= columnCount; ++i) {
                    Object value = set.getObject(i);
                    if (set.wasNull()) continue;
                    row.setColumn(i, value);
                }
            }
            catch (RowException error) {
                throw new SQLException(error.getMessage());
            }
            this.rows.add(row);
        }
    }

    @Override
    public int findColumn(String columnName) {
        int index = 0;
        for (String column : this.meta.getColumnNames()) {
            ++index;
            if (!column.equalsIgnoreCase(columnName)) continue;
            return index;
        }
        return -1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        int n = row = row < 0 ? this.rows.size() - 1 + row : row;
        if (row < 0 || row >= this.rows.size()) {
            return false;
        }
        this.currentRow = row;
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        this.currentRow = this.rows.size();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.currentRow = -1;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.rows.size() > 0) {
            this.currentRow = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.currentRow >= this.rows.size();
    }

    @Override
    public boolean isBeforeFirst() {
        return this.currentRow < 0;
    }

    @Override
    public boolean isFirst() {
        return this.currentRow == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.currentRow == this.rows.size() - 1;
    }

    @Override
    public boolean last() throws SQLException {
        this.currentRow = this.rows.size() - 1;
        return true;
    }

    @Override
    public boolean next() throws SQLException {
        ++this.currentRow;
        return !this.isAfterLast();
    }

    @Override
    public boolean previous() throws SQLException {
        --this.currentRow;
        return !this.isBeforeFirst();
    }

    @Override
    public boolean relative(int rowsCount) throws SQLException {
        int curRow = this.currentRow;
        if (this.isBeforeFirst()) {
            curRow = -1;
        } else if (this.isAfterLast()) {
            curRow = this.rows.size();
        }
        int row = curRow + rowsCount;
        if (row < 0 || row >= this.rows.size()) {
            return false;
        }
        this.currentRow = row;
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        return this.currentRow + 1;
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.meta.getColumnCount()) {
            throw new SQLException("Column index " + columnIndex + " is out of range.");
        }
    }

    protected boolean trackNull(Object o) {
        this.wasNullValue = o == null;
        return this.wasNullValue;
    }

    private Object getObjectWithColumnIndexOrThrowException(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        Object object = this.getObject(columnIndex);
        if (this.trackNull(object)) {
            return null;
        }
        return object;
    }

    private int getColumnIndexOrThrowException(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        if (index == -1) {
            throw new SQLException("Column with name " + columnName + " doesn't exist");
        }
        return index;
    }

    private ColumnDescriptor getColumnDescriptor(int columnIndex) throws SQLException {
        return this.meta.getColumnDescriptor(columnIndex);
    }

    private Number getIntNumberOfType(int columnIndex, Class<?> clazz) throws SQLException {
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        if (object == null) {
            return 0;
        }
        ColumnDescriptor columnDescriptor = this.getColumnDescriptor(columnIndex);
        if (object.getClass().equals(clazz) || object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        try {
            if (object instanceof String) {
                String string = (String)object;
                if (string.indexOf(46) > 0) {
                    string = string.substring(0, string.indexOf(46));
                }
                return Long.parseLong(string);
            }
        }
        catch (NumberFormatException exception) {
            throw RowSet.uncompatibleTypeException(columnDescriptor, object, clazz);
        }
        throw RowSet.uncompatibleTypeException(columnDescriptor, object, clazz);
    }

    private Number convertToFloatOrDoubleNumberOfType(int columnIndex, Object object, Class<?> clazz) throws SQLException {
        if (object == null) {
            return 0;
        }
        ColumnDescriptor columnDescriptor = this.getColumnDescriptor(columnIndex);
        if (object.getClass().equals(clazz) || object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Boolean) {
            object = (Boolean)object != false ? "1" : "0";
        }
        try {
            if (object instanceof String) {
                if (clazz.equals(Float.class)) {
                    return Float.valueOf(Float.parseFloat((String)object));
                }
                return Double.parseDouble((String)object);
            }
        }
        catch (NumberFormatException exception) {
            throw RowSet.uncompatibleTypeException(columnDescriptor, object, clazz);
        }
        throw RowSet.uncompatibleTypeException(columnDescriptor, object, clazz);
    }

    private static SQLException uncompatibleTypeException(ColumnDescriptor columnDescriptor, Object object, Class<?> toClazz) {
        return RowSet.uncompatibleTypeException(columnDescriptor.getType(), object, toClazz);
    }

    private static SQLException uncompatibleTypeException(SQLType type, Object object, Class<?> toClazz) {
        return new SQLException("Cannot cast from SQL type " + String.valueOf((Object)type) + " " + String.valueOf(object.getClass()) + " to " + String.valueOf(toClazz));
    }

    @Override
    public Row getCurrentRow() throws SQLException {
        return this.getRowAt(this.currentRow + 1);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNullValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            Object object = this.getCurrentRow().getColumn(columnIndex);
            if (object instanceof Blob) {
                if (!(object instanceof RowSetBlobProxy)) return object;
                if (!(this instanceof RowSetProxy)) throw RowSet.uncompatibleTypeException(this.getColumnDescriptor(columnIndex), object, Blob.class);
                ((RowSetBlobProxy)object).setAccessor((RowSetProxy)this);
                return object;
            } else {
                if (object instanceof Clob) {
                    if (!(object instanceof RowSetClobProxy)) return object;
                    if (!(this instanceof RowSetProxy)) throw RowSet.uncompatibleTypeException(this.getColumnDescriptor(columnIndex), object, Blob.class);
                    ((RowSetClobProxy)object).setAccessor((RowSetProxy)this);
                    return object;
                }
                if (!BigDecimal.class.getName().equals(this.getColumnDescriptor(columnIndex).getType().getTypeClass().getName())) return object;
                return this.convertToBigDecimal(columnIndex, object);
            }
        }
        catch (RowException error) {
            return null;
        }
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        if (index > 0) {
            return this.getObject(index);
        }
        return null;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        if (object == null) {
            return null;
        }
        ColumnDescriptor columnDescriptor = this.getColumnDescriptor(columnIndex);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Clob) {
            return ((Clob)object).getSubString(1L, (int)((Clob)object).length());
        }
        if (object instanceof Number || object instanceof java.util.Date || object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof byte[]) {
            if (columnDescriptor.getType() == SQLType.BIT) {
                return StringConverter.byteArrayToBitString((byte[])object, ((byte[])object).length * 8);
            }
            if (columnDescriptor.getType() == SQLType.FLOB) {
                return new String((byte[])object);
            }
            return StringConverter.byteArrayToHexString((byte[])object);
        }
        throw RowSet.uncompatibleTypeException(columnDescriptor, object, String.class);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        if (object == null) {
            return false;
        }
        ColumnDescriptor columnDescriptor = this.getColumnDescriptor(columnIndex);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() != 1) {
                throw RowSet.uncompatibleTypeException(columnDescriptor, object, Boolean.class);
            }
            return string.charAt(0) != '0';
        }
        throw RowSet.uncompatibleTypeException(columnDescriptor, object, Boolean.class);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Number number = this.getIntNumberOfType(columnIndex, Byte.class);
        if (number.longValue() < -128L || number.longValue() > 127L) {
            throw RowSet.uncompatibleTypeException(this.getColumnDescriptor(columnIndex), this.getObjectWithColumnIndexOrThrowException(columnIndex), Byte.class);
        }
        return number.byteValue();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Number number = this.getIntNumberOfType(columnIndex, Short.class);
        if (number.longValue() < -32768L || number.longValue() > 32767L) {
            throw RowSet.uncompatibleTypeException(this.getColumnDescriptor(columnIndex), this.getObjectWithColumnIndexOrThrowException(columnIndex), Short.class);
        }
        return number.shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Number number = this.getIntNumberOfType(columnIndex, Integer.class);
        if (number.longValue() < Integer.MIN_VALUE || number.longValue() > Integer.MAX_VALUE) {
            throw RowSet.uncompatibleTypeException(this.getColumnDescriptor(columnIndex), this.getObjectWithColumnIndexOrThrowException(columnIndex), Integer.class);
        }
        return number.intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Number number = this.getIntNumberOfType(columnIndex, Long.class);
        return number.longValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        Number number = this.convertToFloatOrDoubleNumberOfType(columnIndex, object, Float.class);
        return number.floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        Number number = this.convertToFloatOrDoubleNumberOfType(columnIndex, object, Double.class);
        return number.doubleValue();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        byte[] x;
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        if (object == null) {
            return null;
        }
        ColumnDescriptor columnDescriptor = this.getColumnDescriptor(columnIndex);
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof Blob) {
            return ((Blob)object).getBytes(1L, (int)((Blob)object).length());
        }
        if (object instanceof String && (x = RowSet.convertStringToBytes((String)object, columnDescriptor.getType())) != null) {
            return x;
        }
        throw RowSet.uncompatibleTypeException(columnDescriptor, object, byte[].class);
    }

    public static byte[] convertStringToBytes(String str, SQLType type) throws SQLException {
        if (str != null && str.startsWith("[") && str.endsWith("]")) {
            return str.getBytes();
        }
        try {
            return StringConverter.hexStringToByteArray(str);
        }
        catch (Exception exception) {
            try {
                return Base64.decode(str);
            }
            catch (Exception e) {
                throw RowSet.uncompatibleTypeException(type, (Object)str, byte[].class);
            }
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        if (object == null) {
            return null;
        }
        ColumnDescriptor columnDescriptor = this.getColumnDescriptor(columnIndex);
        Class<?> objectClass = object.getClass();
        if (Date.class.equals(objectClass)) {
            return (Date)object;
        }
        if (Timestamp.class.equals(objectClass)) {
            Timestamp timestamp = (Timestamp)object;
            return new Date(timestamp.getTime());
        }
        throw RowSet.uncompatibleTypeException(columnDescriptor, object, Date.class);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        if (object == null) {
            return null;
        }
        ColumnDescriptor columnDescriptor = this.getColumnDescriptor(columnIndex);
        Class<?> objectClass = object.getClass();
        if (Time.class.equals(objectClass)) {
            return (Time)object;
        }
        if (Timestamp.class.equals(objectClass)) {
            Timestamp timestamp = (Timestamp)object;
            return new Time(timestamp.getTime());
        }
        throw RowSet.uncompatibleTypeException(columnDescriptor, object, Time.class);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        if (object == null) {
            return null;
        }
        ColumnDescriptor columnDescriptor = this.getColumnDescriptor(columnIndex);
        Class<?> objectClass = object.getClass();
        if (Timestamp.class.equals(objectClass)) {
            return (Timestamp)object;
        }
        throw RowSet.uncompatibleTypeException(columnDescriptor, object, Timestamp.class);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new ByteArrayInputStream(s.getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new StringInputStream(s);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        if (object == null) {
            return null;
        }
        byte[] bytes = this.getBytes(columnIndex);
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new StringReader((String)object);
        }
        throw RowSet.uncompatibleTypeException(this.getColumnDescriptor(columnIndex), object, StringReader.class);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        if (object == null) {
            return null;
        }
        return this.convertToBigDecimal(columnIndex, object);
    }

    private BigDecimal convertToBigDecimal(int columnIndex, Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        BigDecimal result = null;
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            result = BigDecimal.valueOf(((Number)object).longValue());
        }
        if (object instanceof Float || object instanceof Double) {
            result = BigDecimal.valueOf(((Number)object).doubleValue());
        }
        ColumnDescriptor columnDescriptor = this.getColumnDescriptor(columnIndex);
        if (object instanceof String) {
            try {
                result = new BigDecimal((String)object);
            }
            catch (NumberFormatException exception) {
                throw RowSet.uncompatibleTypeException(columnDescriptor, object, BigDecimal.class);
            }
        }
        if (result == null) {
            throw RowSet.uncompatibleTypeException(columnDescriptor, object, BigDecimal.class);
        }
        return result;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        byte[] x;
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        if (object == null) {
            return null;
        }
        ColumnDescriptor columnDescriptor = this.getColumnDescriptor(columnIndex);
        if (object instanceof String && (x = RowSet.convertStringToBytes((String)object, columnDescriptor.getType())) != null) {
            object = x;
        }
        if (object instanceof byte[]) {
            return new BlobImpl((byte[])object);
        }
        if (object instanceof Blob) {
            if (object instanceof RowSetBlobProxy) {
                if (this instanceof RowSetProxy) {
                    ((RowSetBlobProxy)object).setAccessor((RowSetProxy)this);
                } else {
                    throw RowSet.uncompatibleTypeException(this.getColumnDescriptor(columnIndex), object, Blob.class);
                }
            }
            return (Blob)object;
        }
        throw RowSet.uncompatibleTypeException(columnDescriptor, object, Blob.class);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new ClobImpl((String)object);
        }
        if (object instanceof Clob) {
            if (object instanceof RowSetClobProxy) {
                if (this instanceof RowSetProxy) {
                    ((RowSetClobProxy)object).setAccessor((RowSetProxy)this);
                } else {
                    throw RowSet.uncompatibleTypeException(this.getColumnDescriptor(columnIndex), object, Blob.class);
                }
            }
            return (Clob)object;
        }
        if (object instanceof RowSetBlobProxy) {
            ((RowSetBlobProxy)object).setAccessor((RowSetProxy)this);
            object = ((RowSetBlobProxy)object).castToRowSetClobProxy();
            ((RowSetClobProxy)object).setAccessor((RowSetProxy)this);
            try {
                this.rows.get(this.currentRow).setRawColumn(columnIndex, object);
            }
            catch (RowException e) {
                throw new SQLException(e);
            }
            return (Clob)object;
        }
        if (object instanceof byte[] && this.getColumnDescriptor(columnIndex).getType() == SQLType.FLOB) {
            return new ClobImpl(new String((byte[])object));
        }
        throw RowSet.uncompatibleTypeException(this.getColumnDescriptor(columnIndex), object, Clob.class);
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        Object object = this.getObjectWithColumnIndexOrThrowException(columnIndex);
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            return new ArrayImpl((Object[])object);
        }
        throw RowSet.uncompatibleTypeException(this.getColumnDescriptor(columnIndex), object, Object[].class);
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        return this.getArray(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date date = this.getDate(columnIndex);
        if (date == null) {
            return null;
        }
        long millis = date.getTime();
        if (cal != null) {
            millis = DataspaceDateTime.convertMillisToCalendar(cal, millis);
        }
        return new Date(millis);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.getColumnIndexOrThrowException(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.getColumnIndexOrThrowException(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.getColumnIndexOrThrowException(columnName), cal);
    }

    private void checkCurrentRowIsUpdatable() throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw new SQLException("Current row is out of range.");
        }
        this.checkRowSetIsUpdateable();
    }

    private void checkRowSetIsUpdateable() throws SQLException {
        if (this.isReadOnly()) {
            throw new SQLException("RowSet is read-only. Any updates are forbidden.");
        }
    }

    protected void doUpdateColumn(int columnIndex, Object value) throws SQLException {
        this.checkCurrentRowIsUpdatable();
        try {
            this.getCurrentRow().setColumn(columnIndex, value);
            this.notifyRowUpdated();
        }
        catch (RowException error) {
            throw new SQLException(error.getMessage());
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.doUpdateColumn(columnIndex, null);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.doUpdateColumn(columnIndex, Float.valueOf(x));
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        String s;
        try {
            s = StringConverter.inputStreamToString(x, "US-ASCII");
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        if (length >= 0 && s.length() > length) {
            s = s.substring(0, length);
        }
        this.doUpdateColumn(columnIndex, s);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        HsqlByteArrayOutputStream output = null;
        try {
            output = length >= 0 ? new HsqlByteArrayOutputStream(x, length) : new HsqlByteArrayOutputStream(x);
            this.doUpdateColumn(columnIndex, output.toByteArray());
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        CharArrayWriter writer;
        try {
            writer = length >= 0 ? new CharArrayWriter(x, length) : new CharArrayWriter(x);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        this.doUpdateColumn(columnIndex, writer.toString());
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.updateAsciiStream(columnIndex, x, -1);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.updateAsciiStream(this.getColumnIndexOrThrowException(columnLabel), x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.updateBinaryStream(columnIndex, x, -1);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.updateBinaryStream(this.getColumnIndexOrThrowException(columnLabel), x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateCharacterStream(columnIndex, x, -1);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        this.updateCharacterStream(this.getColumnIndexOrThrowException(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Argument length is out of range.");
        }
        this.updateAsciiStream(columnIndex, x, (int)length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.getColumnIndexOrThrowException(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Argument length is out of range.");
        }
        this.updateBinaryStream(columnIndex, x, (int)length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.getColumnIndexOrThrowException(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Argument length is out of range.");
        }
        this.updateCharacterStream(columnIndex, x, (int)length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.getColumnIndexOrThrowException(columnLabel), reader, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (x instanceof InputStream) {
            this.updateBinaryStream(columnIndex, (InputStream)x, scale);
        } else if (x instanceof Reader) {
            this.updateCharacterStream(columnIndex, (Reader)x, scale);
        } else {
            this.updateObject(columnIndex, x);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.getColumnIndexOrThrowException(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.getColumnIndexOrThrowException(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.getColumnIndexOrThrowException(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.getColumnIndexOrThrowException(columnName), reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.getColumnIndexOrThrowException(columnName), x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBlob(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.updateClob(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateBlob(columnIndex, inputStream, -1L);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateBlob(this.getColumnIndexOrThrowException(columnLabel), inputStream);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Argument length is out of range.");
        }
        HsqlByteArrayOutputStream output = null;
        try {
            output = length >= 0L ? new HsqlByteArrayOutputStream(inputStream, (int)length) : new HsqlByteArrayOutputStream(inputStream);
            this.doUpdateColumn(columnIndex, output.toByteArray());
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.getColumnIndexOrThrowException(columnLabel), inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.updateClob(columnIndex, reader, -1L);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.updateClob(this.getColumnIndexOrThrowException(columnLabel), reader);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        CharArrayWriter writer;
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Argument length is out of range.");
        }
        try {
            writer = length >= 0L ? new CharArrayWriter(reader, (int)length) : new CharArrayWriter(reader);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        this.doUpdateColumn(columnIndex, writer.toString());
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(this.getColumnIndexOrThrowException(columnLabel), reader, length);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.doUpdateColumn(columnIndex, x);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.updateArray(this.getColumnIndexOrThrowException(columnName), x);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.pageSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.pageSize;
    }

    @Override
    public RowSet asRowSet() throws SQLException {
        if (this.rowSetLobHolders != null && this.rowSetLobHolders.size() > 0) {
            this.fetchAllRowSetLobs();
        }
        return this;
    }

    @Override
    public void setPageSize(int pageSize) throws SQLException {
        this.setFetchSize(pageSize);
    }

    @Override
    public int getPageSize() throws SQLException {
        return this.getFetchSize();
    }

    @Override
    public boolean nextPage() throws SQLException {
        if (this.getPageSize() <= 0) {
            return false;
        }
        if (this.currentRow + this.getPageSize() < this.rows.size()) {
            this.currentRow = (this.currentRow / this.getPageSize() + 1) * this.getPageSize();
            return true;
        }
        return false;
    }

    @Override
    public boolean previousPage() throws SQLException {
        if (this.getPageSize() <= 0) {
            return false;
        }
        if (this.currentRow - this.getPageSize() > 0) {
            this.currentRow = (this.currentRow / this.getPageSize() - 1) * this.getPageSize();
            return true;
        }
        return false;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + String.valueOf(iface));
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return (T)this.getObject(columnIndex);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return (T)this.getObject(columnLabel);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("No suitable connection available.");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("No suitable connection available.");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("No suitable connection available.");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("No suitable connection available.");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("No suitable connection available.");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("No suitable connection available.");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("No suitable connection available.");
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new SQLException("No suitable connection available.");
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    public Object getObject(String colName, Map map) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("No suitable connection available.");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLException("No suitable connection available.");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public int getType() throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLException("Feature not yet implemented.");
    }

    @Override
    public RowSet clone() {
        RowSet result = (RowSet)super.clone();
        if (this.meta != null) {
            result.meta = this.meta.clone();
        }
        if (this.outParameterValues != null) {
            result.outParameterValues = new Object[this.outParameterValues.length];
            for (int i = 0; i < this.outParameterValues.length; ++i) {
                try {
                    result.outParameterValues[i] = SDOUtils.clone(this.outParameterValues[i]);
                    continue;
                }
                catch (SDOException error) {
                    Trace.logError(this, "RowSet out parameters clone failed. " + error.getMessage());
                }
            }
        }
        if (this.rows != null) {
            result.rows = new ArrayList<Row>();
            for (Row row : this.rows) {
                Row clonedRow = row.clone();
                clonedRow.provider = result;
                result.rows.add(clonedRow);
            }
        }
        return result;
    }

    public static RowMetaData createMetaData(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("ResultSet is null");
        }
        try {
            RowMetaData meta = new RowMetaData(resultSet);
            meta.setHash();
            return meta;
        }
        catch (MetaDataException error) {
            throw new SQLException(error.getMessage());
        }
    }

    protected void addRowSetLob(RowSetLobHolder rowSetLobHolder) {
        if (this.rowSetLobHolders == null) {
            this.rowSetLobHolders = new HashMap<Long, RowSetLobHolder>();
        }
        this.rowSetLobHolders.put(rowSetLobHolder.getLob().getId(), rowSetLobHolder);
    }

    protected Map<Long, RowSetLobHolder> getRowSetLobHolders() {
        if (this.rowSetLobHolders != null) {
            return this.rowSetLobHolders;
        }
        return Collections.EMPTY_MAP;
    }

    protected void replaceRowSetLobsWithProxies() {
        if (this.rowSetLobHolders != null) {
            for (RowSetLobHolder holder : this.rowSetLobHolders.values()) {
                try {
                    this.rows.get(holder.getRowIndex()).setRawColumn(holder.getColumnIndex(), holder.getLob().getProxy());
                }
                catch (RowException exception) {
                    Trace.logException(this, exception, true);
                }
            }
        }
    }

    protected boolean containsLobProxies() {
        return this.rowSetLobHolders != null && this.rowSetLobHolders.size() > 0;
    }

    protected void fetchAllRowSetLobs() throws SQLException {
        ArrayList<Integer> lobIndexes = new ArrayList<Integer>();
        for (int i = 1; i <= this.getMeta().getColumnCount(); ++i) {
            if (this.getMeta().getColumnDescriptor(i).getType() != SQLType.BLOB && this.getMeta().getColumnDescriptor(i).getType() != SQLType.CLOB && this.getMeta().getColumnDescriptor(i).getType() != SQLType.FLOB) continue;
            lobIndexes.add(i);
        }
        for (Row row : this.rows) {
            Iterator iterator = lobIndexes.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                try {
                    Object value = row.getColumn(index);
                    if (value instanceof AbstractRowSetLobProxy && this instanceof RowSetProxy) {
                        ((AbstractRowSetLobProxy)value).setAccessor((RowSetProxy)this);
                    }
                    if (value instanceof RowSetBlobProxy || value instanceof RowSetBlobClientImpl) {
                        value = ((Blob)value).getBytes(1L, (int)((Blob)value).length());
                    } else if (value instanceof RowSetClobProxy || value instanceof RowSetClobClientImpl) {
                        value = ((Clob)value).getSubString(1L, (int)((Clob)value).length());
                    }
                    row.setRawColumn(index, value);
                }
                catch (RowException exception) {
                    throw new SQLException(exception.getMessage());
                }
            }
        }
    }

    private void setRows(List<Row> rows) {
        this.rows = rows;
        if (rows != null) {
            for (Row row : rows) {
                if (row == null) continue;
                row.provider = this;
            }
            this.updateRowSetBinaryColumns();
        }
    }

    private void updateRowSetBinaryColumns() {
        if (this.rows == null || this.rows.size() == 0) {
            return;
        }
        ArrayList<Integer> binaryColumns = null;
        for (int i = 1; i <= this.getMeta().getColumnCount(); ++i) {
            SQLType type = this.getMeta().getColumnDescriptor(i).getType();
            if (type != SQLType.BLOB && type != SQLType.FLOB && type != SQLType.BINARY && type != SQLType.VARBINARY) continue;
            if (binaryColumns == null) {
                binaryColumns = new ArrayList<Integer>();
            }
            binaryColumns.add(i);
        }
        if (binaryColumns != null) {
            try {
                for (Row row : this.rows) {
                    Iterator iterator = binaryColumns.iterator();
                    while (iterator.hasNext()) {
                        int columnIndex = (Integer)iterator.next();
                        Object value = row.getColumn(columnIndex);
                        if (!(value instanceof String) || ((String)value).startsWith("[") && ((String)value).endsWith("]")) continue;
                        value = RowSet.convertStringToBytes((String)value, this.getMeta().getColumnDescriptor(columnIndex).getType());
                        row.setRawColumn(columnIndex, value);
                    }
                }
            }
            catch (RowException | SQLException exception) {
                Trace.logException(this, exception, true);
            }
        }
    }

    public String toText(int maxColumnWidth) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream result = new PrintStream(output);
        RowSetPrinter printer = new RowSetPrinter();
        printer.setMaxColumnWidth(maxColumnWidth);
        printer.setPrintStream(result);
        printer.print(this);
        try {
            this.beforeFirst();
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, false);
        }
        return output.toString();
    }

    public CollectionTupleSet toTupleSet() {
        CollectionTupleSet result = new CollectionTupleSet();
        this.rows.forEach(row -> {
            HashMap<String, Object> tuple = new HashMap<String, Object>();
            for (int i = 0; i < this.meta.getColumnCount(); ++i) {
                tuple.put(this.meta.columns.get(i).getName(), row.data[i]);
            }
            result.add(tuple);
        });
        return result;
    }

    public DataFrame toDataFrame() throws SQLException {
        DataFrame dataFrame = new DataFrame("", this.rows.size(), this.getRowMetaData().getColumnCount());
        int i = 0;
        this.beforeFirst();
        while (this.next()) {
            if (i + 1 > dataFrame.rowCount()) {
                dataFrame = dataFrame.withRowsCount(dataFrame.rowCount() + this.rows.size());
            }
            for (int j = 1; j <= this.getRowMetaData().getColumnCount(); ++j) {
                dataFrame.set(i, j - 1, this.getDouble(j));
            }
            ++i;
        }
        this.beforeFirst();
        dataFrame.setColumnNames(new ArrayList<String>(this.getRowMetaData().getColumnDescriptors().stream().map(ColumnDescriptor::getName).collect(Collectors.toList())));
        return dataFrame;
    }

    public com.streamscape.ds.parser.statement.Statement getParserStatement() {
        return this.parserStatement;
    }

    public void setParserStatement(com.streamscape.ds.parser.statement.Statement parserStatement) {
        this.parserStatement = parserStatement;
    }

    public void sortRows(Comparator<Row> comparator) {
        this.rows.sort(comparator);
    }

    public List<Integer> getIntColumn(String columnName) throws SQLException {
        return this.getIntColumn(this.getColumnIndexOrThrowException(columnName));
    }

    public List<Integer> getIntColumn(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex, this::getInt);
    }

    public List<BigDecimal> getBigDecimalColumn(String columnName) throws SQLException {
        return this.getBigDecimalColumn(this.getColumnIndexOrThrowException(columnName));
    }

    public List<BigDecimal> getBigDecimalColumn(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex, this::getBigDecimal);
    }

    public List<Short> getShortColumn(String columnName) throws SQLException {
        return this.getShortColumn(this.getColumnIndexOrThrowException(columnName));
    }

    public List<Short> getShortColumn(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex, this::getShort);
    }

    public List<Long> getLongColumn(String columnName) throws SQLException {
        return this.getLongColumn(this.getColumnIndexOrThrowException(columnName));
    }

    public List<Long> getLongColumn(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex, this::getLong);
    }

    public List<Byte> getByteColumn(String columnName) throws SQLException {
        return this.getByteColumn(this.getColumnIndexOrThrowException(columnName));
    }

    public List<Byte> getByteColumn(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex, this::getByte);
    }

    public List<Boolean> getBooleanColumn(String columnName) throws SQLException {
        return this.getBooleanColumn(this.getColumnIndexOrThrowException(columnName));
    }

    public List<Boolean> getBooleanColumn(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex, this::getBoolean);
    }

    public List<Float> getFloatColumn(String columnName) throws SQLException {
        return this.getFloatColumn(this.getColumnIndexOrThrowException(columnName));
    }

    public List<Float> getFloatColumn(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex, this::getFloat);
    }

    public List<Double> getDoubleColumn(String columnName) throws SQLException {
        return this.getDoubleColumn(this.getColumnIndexOrThrowException(columnName));
    }

    public List<Double> getDoubleColumn(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex, this::getDouble);
    }

    public List<String> getStringColumn(String columnName) throws SQLException {
        return this.getStringColumn(this.getColumnIndexOrThrowException(columnName));
    }

    public List<String> getStringColumn(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex, this::getString);
    }

    public List<Object> getObjectColumn(String columnName) throws SQLException {
        return this.getObjectColumn(this.getColumnIndexOrThrowException(columnName));
    }

    public List<Object> getObjectColumn(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex, this::getObject);
    }

    public List<Date> getDateColumn(String columnName) throws SQLException {
        return this.getDateColumn(this.getColumnIndexOrThrowException(columnName));
    }

    public List<Date> getDateColumn(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex, this::getDate);
    }

    public List<Time> getTimeColumn(String columnName) throws SQLException {
        return this.getTimeColumn(this.getColumnIndexOrThrowException(columnName));
    }

    public List<Time> getTimeColumn(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex, this::getTime);
    }

    public List<Timestamp> getTimestampColumn(String columnName) throws SQLException {
        return this.getTimestampColumn(this.getColumnIndexOrThrowException(columnName));
    }

    public List<Timestamp> getTimestampColumn(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex, this::getTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> List<T> getColumn(int columnIndex, FunctionWithSQLException<Integer, T> valueGetter) throws SQLException {
        ArrayList<T> result = new ArrayList<T>(this.getRowCount());
        Object currentPosition = this.getCurrentPosition();
        try {
            this.beforeFirst();
            while (this.next()) {
                result.add(valueGetter.apply(columnIndex));
            }
        }
        finally {
            this.restoreCurrentPosition(currentPosition);
        }
        return result;
    }

    public List<String> getColumnNames() {
        return this.getMeta().getColumnNames();
    }

    protected Object getCurrentPosition() {
        return this.currentRow;
    }

    protected void restoreCurrentPosition(Object object) throws SQLException {
        this.currentRow = (Integer)object;
    }

    protected static interface FunctionWithSQLException<T, R> {
        public R apply(T var1) throws SQLException;
    }
}

