/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.ds.jdbc.JDBCResultSetMetaData;
import com.streamscape.ds.types.OtherType;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.RowArrayException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RowMetaData
extends CloneableDataObject {
    private int capacity = -1;
    private boolean hasReturnCode = false;
    private int[] keyIndices = null;
    protected List<ColumnDescriptor> columns = null;
    protected ColumnDescriptor[] outParameters = null;
    protected int hash = 0;

    public RowMetaData() {
        this.columns = new ArrayList<ColumnDescriptor>();
    }

    public RowMetaData(int capacity) {
        this.capacity = capacity;
        this.keyIndices = new int[0];
        this.columns = new ArrayList<ColumnDescriptor>();
    }

    public RowMetaData(List<ColumnDescriptor> columns) {
        this.columns = columns;
    }

    public RowMetaData(ResultSet rs) throws MetaDataException {
        this.columns = new ArrayList<ColumnDescriptor>();
        try {
            ResultSetMetaData resultSetMeta = rs.getMetaData();
            int count = resultSetMeta.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                Type jdbcType;
                SQLType type;
                String columnName = resultSetMeta.getColumnLabel(i);
                if (columnName == null) {
                    columnName = resultSetMeta.getColumnName(i);
                }
                if ((type = SQLType.typeForId(resultSetMeta.getColumnType(i), resultSetMeta.getColumnTypeName(i), resultSetMeta.getColumnClassName(i))) == SQLType.OTHER && resultSetMeta instanceof JDBCResultSetMetaData && (jdbcType = ((JDBCResultSetMetaData)resultSetMeta).getType(i)) instanceof OtherType) {
                    if (jdbcType.userTypeModifier != null && jdbcType.getObjectName().getNameString().equalsIgnoreCase("URL")) {
                        type = SQLType.URL;
                    } else if (jdbcType.getNameString().equalsIgnoreCase("date")) {
                        type = SQLType.DATE;
                    }
                }
                boolean nullable = resultSetMeta.isNullable(i) != 0;
                columnName = this.buildUniqueColumnName(columnName, 0);
                ColumnDescriptor c = new ColumnDescriptor(columnName, type, nullable, resultSetMeta.getPrecision(i), resultSetMeta.getScale(i));
                this.columns.add(c);
            }
        }
        catch (SQLException error) {
            throw new MetaDataException(error.getMessage());
        }
    }

    private String buildUniqueColumnName(String columnName, int index) {
        Object newColumnName = columnName;
        if (index != 0) {
            newColumnName = (String)newColumnName + "_" + index;
        }
        String finalNewColumnName = newColumnName;
        ColumnDescriptor descriptor = this.columns.stream().filter(d -> d.getName().equals(finalNewColumnName)).findFirst().orElse(null);
        if (descriptor == null) {
            return newColumnName;
        }
        return this.buildUniqueColumnName(columnName, ++index);
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setHasReturnCode(boolean hasReturnCode) {
        this.hasReturnCode = hasReturnCode;
    }

    public boolean hasReturnCode() {
        return this.hasReturnCode;
    }

    public ColumnDescriptor getOutParameterColumnDescriptor(int index) throws MetaDataException {
        if (this.outParameters == null) {
            throw new MetaDataException("Output parameters meta data is not initialized.");
        }
        if (index >= 0 && index < this.outParameters.length) {
            return this.outParameters[index];
        }
        throw new MetaDataException("Index '" + index + "' is out of range.");
    }

    public ColumnDescriptor getOutParameterColumnDescriptor(String name) throws MetaDataException {
        if (this.outParameters == null) {
            throw new MetaDataException("Output parameters meta data is not initialized.");
        }
        for (ColumnDescriptor param : this.outParameters) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        throw new MetaDataException("Output parameter '" + name + "' does not exist.");
    }

    public String[] getOutParameterNames() {
        if (this.outParameters != null) {
            String[] result = new String[this.outParameters.length];
            int index = -1;
            for (ColumnDescriptor param : this.outParameters) {
                result[++index] = param.getName();
            }
            return result;
        }
        return null;
    }

    public void setOutParameterNamesAndTypes(String[] outParams, SQLType[] types) {
        if (outParams == null) {
            throw new IllegalArgumentException("Out parameter names array is NULL.");
        }
        if (this.outParameters == null) {
            this.outParameters = new ColumnDescriptor[outParams.length];
        }
        int index = -1;
        for (String outParam : outParams) {
            this.outParameters[++index] = new ColumnDescriptor(outParam, types[index], true);
        }
    }

    public int getOutParameterCount() {
        if (this.outParameters != null) {
            return this.outParameters.length;
        }
        return -1;
    }

    public Class<?> getColumnTypeClass(int index) throws MetaDataException {
        if (index > 0 && index <= this.columns.size()) {
            return this.columns.get(index - 1).getTypeClass();
        }
        throw new MetaDataException("Index '" + index + "' is out of range.");
    }

    public Class<?> getOutputParameterTypeClass(int index) throws MetaDataException {
        if (this.outParameters == null) {
            throw new MetaDataException("Output parameters meta data is not initialized.");
        }
        if (index >= 0 && index < this.outParameters.length) {
            return this.outParameters[index].getTypeClass();
        }
        throw new MetaDataException("Index '" + index + "' is out of range.");
    }

    public Class<?> getOutputParameterTypeClass(String name) throws MetaDataException {
        if (this.outParameters == null) {
            throw new MetaDataException("Output parameters meta data is not initialized.");
        }
        int counter = -1;
        for (ColumnDescriptor param : this.outParameters) {
            ++counter;
            if (!param.getName().equals(name)) continue;
            return this.getOutputParameterTypeClass(counter);
        }
        throw new MetaDataException("Output parameter '" + name + "' does not exist.");
    }

    public Class<?> getColumnTypeClass(String name) throws MetaDataException {
        int index = this.findColumn(name);
        if (index != -1) {
            return this.columns.get(index - 1).getTypeClass();
        }
        return null;
    }

    public int getColumnSQLType(String name) throws MetaDataException {
        int index = this.findColumn(name);
        if (index != -1) {
            return this.columns.get(index - 1).getSQLType();
        }
        return -1;
    }

    public int getColumnSQLType(int index) throws MetaDataException {
        if (index > 0 && index <= this.columns.size()) {
            return this.columns.get(index - 1).getSQLType();
        }
        throw new MetaDataException("Index '" + index + "' is out of range.");
    }

    public void enableRowId(boolean useRID) throws MetaDataException {
        if (useRID) {
            if (this.getColumnCount() > 0) {
                throw new RowArrayException("Column definitions already exist. Row Id must be enabled prior to adding columns.");
            }
            if (this.keyIndices == null) {
                this.keyIndices = new int[1];
            }
            this.keyIndices[0] = -2;
            this.addColumn("row_id", SQLType.INTEGER, false);
        } else if (this.findColumn("row_id") != -1) {
            if (this.getColumnCount() > 1) {
                throw new RowArrayException("Column definitions already exist. Remove all data columns prior to Row Id.");
            }
            this.removeColumn("row_id");
        }
    }

    public boolean isRowIdEnabled() {
        return this.keyIndices != null && this.keyIndices.length > 0 && this.keyIndices[0] == -2;
    }

    public int findColumn(String columnName) {
        int index = 0;
        for (ColumnDescriptor column : this.columns) {
            ++index;
            if (!column.getName().equals(columnName)) continue;
            return index;
        }
        return -1;
    }

    public void addColumn(String name) {
        this.addColumn(name, Object.class);
    }

    public RowMetaData addColumn(String name, Class<?> clazz) {
        this.addColumn(name, clazz, true);
        return this;
    }

    public void addColumn(String name, SQLType type) {
        this.addColumn(name, type, true);
    }

    public void addColumn(String name, Class<?> columnClass, boolean nullable) {
        this.addColumn(new ColumnDescriptor(name, this.convertClassToWrapper(columnClass), nullable));
    }

    public void addColumn(String name, Class<?> columnClass, boolean nullable, int precision, int scale) {
        this.addColumn(new ColumnDescriptor(name, this.convertClassToWrapper(columnClass), nullable, precision, scale));
    }

    private Class<?> convertClassToWrapper(Class<?> columnClass) {
        if (columnClass.isPrimitive()) {
            if (columnClass == Integer.TYPE) {
                columnClass = Integer.class;
            } else if (columnClass == Long.TYPE) {
                columnClass = Long.class;
            } else if (columnClass == Double.TYPE) {
                columnClass = Double.class;
            } else if (columnClass == Float.TYPE) {
                columnClass = Float.class;
            } else if (columnClass == Boolean.TYPE) {
                columnClass = Boolean.class;
            } else if (columnClass == Character.TYPE) {
                columnClass = Character.class;
            } else if (columnClass == Byte.TYPE) {
                columnClass = Byte.class;
            } else if (columnClass == Short.TYPE) {
                columnClass = Short.class;
            } else {
                throw new IllegalArgumentException("Row Array meta data exception. Unsupported type '" + String.valueOf(columnClass) + "'.");
            }
        }
        return columnClass;
    }

    public void addColumn(String name, SQLType type, boolean nullable) {
        this.addColumn(new ColumnDescriptor(name, type, nullable));
    }

    public void addColumn(String name, SQLType type, boolean nullable, int precision, int scale) {
        this.addColumn(new ColumnDescriptor(name, type, nullable, precision, scale));
    }

    public void addColumn(ColumnDescriptor columnDescriptor) {
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnDescriptor>();
        }
        if (this.findColumn(columnDescriptor.getName()) > 0) {
            throw new IllegalArgumentException("Duplicate column name specified.");
        }
        this.columns.add(columnDescriptor);
    }

    public void removeColumn(String columnName) throws MetaDataException {
        if (columnName.equals("row_id")) {
            throw new MetaDataException("Row Id column may not be removed. Row Id must be disabled.");
        }
        int index = this.findColumn(columnName);
        if (index > 0 && index <= this.columns.size()) {
            this.columns.remove(index - 1);
        }
    }

    public List<String> getColumnNames() {
        if (this.columns != null) {
            ArrayList<String> result = new ArrayList<String>(this.columns.size());
            for (ColumnDescriptor column : this.columns) {
                result.add(column.getName());
            }
            return result;
        }
        return new ArrayList<String>();
    }

    public int getColumnCount() {
        if (this.columns != null) {
            return this.columns.size();
        }
        return -1;
    }

    public int[] getKeyColumnsIndices() {
        return this.keyIndices;
    }

    public void setKeyColumnsIndices(int[] keyIndices) throws MetaDataException {
        if (this.keyIndices != null && keyIndices.length > 0 && keyIndices[0] == -2) {
            throw new RowArrayException("Row Id usage is enabled.  Key Column may not be set.");
        }
        this.keyIndices = keyIndices;
    }

    public String getColumnName(int colIndex) throws MetaDataException {
        if (colIndex > 0 && colIndex <= this.columns.size()) {
            return this.columns.get(colIndex - 1).getName();
        }
        return null;
    }

    public ColumnDescriptor getColumnDescriptor(String name) throws MetaDataException {
        int index = this.findColumn(name);
        if (index == -1) {
            throw new MetaDataException("Undefined column name '" + name + "'.");
        }
        return this.columns.get(index - 1);
    }

    public ColumnDescriptor getColumnDescriptor(int index) {
        if (index > 0 && index <= this.columns.size()) {
            return this.columns.get(index - 1);
        }
        return null;
    }

    public List<ColumnDescriptor> getColumnDescriptors() {
        return new ArrayList<ColumnDescriptor>(this.columns);
    }

    public Iterator<ColumnDescriptor> iterator() throws MetaDataException {
        return this.columns.iterator();
    }

    @Override
    public RowMetaData clone() {
        RowMetaData result = (RowMetaData)super.clone();
        if (this.columns != null) {
            result.columns = new ArrayList<ColumnDescriptor>();
            result.columns.addAll(this.columns);
        } else {
            result.columns = null;
        }
        result.outParameters = this.outParameters != null ? (ColumnDescriptor[])this.outParameters.clone() : null;
        return result;
    }

    protected void setHash() {
        StringBuilder buffer = new StringBuilder();
        for (ColumnDescriptor column : this.columns) {
            buffer.append(column.getSQLType()).append(" ");
        }
        this.hash = buffer.toString().hashCode();
    }
}

