/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.Trace;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.DataRow;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.MetaDataProvider;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowArrayException;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.sys.Null;
import com.streamscape.sdo.utils.SDOUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class RowArray
extends MetaDataProvider {
    protected RowMetaData rowArrayMetaData = null;
    protected LinkedHashMap<Object, DataRow> rowArray = null;
    protected int rowId = 1;
    protected boolean cache = false;

    public RowArray() {
    }

    public RowArray(RowMetaData metaData) {
        this.rowArrayMetaData = metaData;
        this.rowArray = new AdoptedLinkedHashMap<Object, DataRow>();
    }

    public RowMetaData getMetaData() {
        return this.rowArrayMetaData.clone();
    }

    @Override
    public RowMetaData getMeta() {
        return this.rowArrayMetaData;
    }

    public void init(ResultSet set) throws SQLException, MetaDataException {
        this.rowArrayMetaData = new RowMetaData(set);
        this.rowArray = new AdoptedLinkedHashMap<Object, DataRow>();
    }

    public void init(RowMetaData metaData) throws RowArrayException {
        if (this.rowArrayMetaData != null) {
            throw new RowArrayException("Illegal object state.  Meta data already initialized.");
        }
        this.rowArrayMetaData = metaData;
        this.rowArray = new AdoptedLinkedHashMap<Object, DataRow>();
    }

    public int getCapacity() throws RowArrayException {
        if (this.rowArrayMetaData == null) {
            throw new RowArrayException("Illegal object state.  Meta data not initialized.");
        }
        return this.rowArrayMetaData.getCapacity();
    }

    public void setMRUEnabled(boolean cache) {
        this.cache = cache;
    }

    public boolean isMRUEnabled() {
        return this.cache;
    }

    public boolean containsRow(DataRow row) {
        return this.rowArray.containsValue(row);
    }

    public DataRow newRow() throws MetaDataException, RowException {
        if (this.rowArrayMetaData == null) {
            throw new RowArrayException("Illegal object state.  Meta data not initialized.");
        }
        this.assertState();
        Row row = new Row(this);
        if (this.rowArrayMetaData.isRowIdEnabled()) {
            row.enableRID();
        }
        return row;
    }

    public void addRow(DataRow row) throws RowArrayException, RowException {
        Object key;
        int capacity;
        this.assertState();
        if (!this.cache && (capacity = this.rowArrayMetaData.getCapacity()) > 0 && this.size() == capacity) {
            throw new RowArrayException("Array capacity exceeded.");
        }
        int[] keyColumnIndices = this.rowArrayMetaData.getKeyColumnsIndices();
        if (keyColumnIndices == null || keyColumnIndices.length != 1) {
            throw new RowArrayException("Key column index is not specified.");
        }
        int idx = keyColumnIndices[0];
        if (idx > 0 && this.rowArray.containsKey(key = row.getColumn(idx))) {
            throw new RowException("Integrity constraint violation. Duplicate key value '" + String.valueOf(key) + "' specified.");
        }
        try {
            Iterator<ColumnDescriptor> cols = this.rowArrayMetaData.iterator();
            idx = 0;
            while (cols.hasNext()) {
                ColumnDescriptor desc = cols.next();
                if (row.getColumn(++idx) == null || row.getColumn(idx).getClass().equals(Null.class)) {
                    if (desc.isNullable()) continue;
                    throw new RowException("Integrity constraint violation. Column '" + desc.getName() + "' may not be null.");
                }
                if (!(row.getColumn(idx) instanceof Class) || row.hasRowId() && idx == 1) continue;
                throw new RowException("No data for column '" + desc.getName() + "'.");
            }
        }
        catch (MetaDataException error) {
            throw new RowArrayException(error.getMessage());
        }
        idx = keyColumnIndices[0];
        if (idx == -1) {
            int rid = this.getNextrowId();
            this.rowArray.put(rid, row);
        } else if (idx == -2) {
            int rid = this.getNextrowId();
            ((Row)row).setRowId(rid);
            this.rowArray.put(rid, row);
        } else {
            key = row.getColumn(idx);
            this.rowArray.put(key, row);
        }
    }

    public boolean existsKey(Object key) throws RowArrayException {
        return this.rowArray.containsKey(key);
    }

    public void removeRowByKey(Object key) throws RowArrayException {
        if (!this.rowArray.containsKey(key)) {
            throw new RowArrayException("Integrity constraint violation. Key value '" + String.valueOf(key) + "' does not exist.");
        }
        this.rowArray.remove(key);
    }

    public void removeRow() {
        Iterator<Object> rowKeys = this.rowArray.keySet().iterator();
        if (rowKeys.hasNext()) {
            Object key = rowKeys.next();
            this.rowArray.remove(key);
        }
    }

    public DataRow getRowByKey(Object key) throws RowArrayException {
        if (!this.rowArray.containsKey(key)) {
            throw new RowArrayException("Integrity constraint violation. Key value '" + String.valueOf(key) + "' does not exist.");
        }
        return this.rowArray.get(key);
    }

    public String getIndexColumnName() throws MetaDataException {
        if (this.rowArrayMetaData == null) {
            throw new RowArrayException("Illegal object state.  Meta data not initialized.");
        }
        int[] keyColumnIndices = this.rowArrayMetaData.getKeyColumnsIndices();
        if (keyColumnIndices == null || keyColumnIndices.length != 1) {
            throw new RowArrayException("Key column index is not specified.");
        }
        int idx = keyColumnIndices[0];
        if (idx == -1) {
            return null;
        }
        if (idx == -2) {
            return "row_id";
        }
        return this.rowArrayMetaData.getColumnName(idx);
    }

    public boolean hasKeyIndex() throws RowArrayException {
        if (this.rowArrayMetaData == null) {
            throw new RowArrayException("Illegal object state.  Meta data not initialized.");
        }
        int[] keyColumnIndices = this.rowArrayMetaData.getKeyColumnsIndices();
        if (keyColumnIndices != null && keyColumnIndices.length == 1) {
            return keyColumnIndices[0] != -1;
        }
        return false;
    }

    public Iterator<DataRow> iteratorByEntry() {
        return new ArrayList<DataRow>(this.rowArray.values()).iterator();
    }

    public Iterator<DataRow> iteratorByKey() {
        Vector<Object> keyList = new Vector<Object>();
        for (Object key : this.rowArray.keySet()) {
            keyList.add(key);
        }
        Collections.sort(keyList);
        Vector<DataRow> sortedRows = new Vector<DataRow>();
        for (Object e : keyList) {
            sortedRows.add(this.rowArray.get(e));
        }
        return sortedRows.iterator();
    }

    public int size() {
        return this.rowArray.size();
    }

    public void clear() {
        this.rowArray.clear();
    }

    protected int getNextrowId() {
        return this.rowId++;
    }

    protected void assertState() throws RowArrayException {
        if (this.rowArray == null) {
            throw new RowArrayException("Illegal object state. Row Array not initialized.");
        }
    }

    @Override
    public RowArray clone() {
        RowArray result = (RowArray)super.clone();
        RowMetaData rowMetaData = result.rowArrayMetaData = this.rowArrayMetaData != null ? this.rowArrayMetaData.clone() : null;
        if (this.rowArray != null) {
            result.rowArray = new LinkedHashMap();
            for (Map.Entry<Object, DataRow> entry : this.rowArray.entrySet()) {
                try {
                    Row clonedRow = (Row)entry.getValue().clone();
                    clonedRow.provider = result;
                    result.rowArray.put(SDOUtils.clone(entry.getKey()), clonedRow);
                }
                catch (SDOException error) {
                    Trace.logError(this, "RowArray row clone failed. " + error.getMessage());
                }
            }
        }
        return result;
    }

    private void setRowArray(LinkedHashMap<Object, DataRow> rowArray) {
        if (rowArray != null) {
            for (Map.Entry<Object, DataRow> entry : rowArray.entrySet()) {
                if (!(entry.getValue() instanceof Row)) continue;
                ((Row)entry.getValue()).provider = this;
            }
        }
        this.rowArray = new AdoptedLinkedHashMap<Object, DataRow>();
        this.rowArray.putAll(rowArray);
    }

    class AdoptedLinkedHashMap<T, X>
    extends LinkedHashMap<T, X> {
        AdoptedLinkedHashMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<T, X> eldest) {
            int capacity;
            return RowArray.this.cache && (capacity = RowArray.this.rowArrayMetaData.getCapacity()) > 0 && this.size() > capacity;
        }
    }
}

