/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.streamscape.Trace;
import com.streamscape.cli.ds.collection.Aspects;
import com.streamscape.cli.ds.collection.Facets;
import com.streamscape.ds.types.BinaryData;
import com.streamscape.ds.types.TimeData;
import com.streamscape.ds.types.TimestampData;
import com.streamscape.lib.utils.ArrayIterator;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.DataRow;
import com.streamscape.sdo.rowset.MetaDataException;
import com.streamscape.sdo.rowset.MetaDataProvider;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSetBlobClientImpl;
import com.streamscape.sdo.rowset.RowSetClobClientImpl;
import com.streamscape.sdo.utils.SDOUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;

public class Row
extends MetaDataProvider
implements DataRow {
    protected RowMetaData meta = null;
    protected Object[] data = null;
    protected boolean hasRID = false;
    @JsonIgnore
    protected MetaDataProvider provider = null;

    public Row(RowMetaData meta, Object[] values) throws RowException {
        if (values == null) {
            throw new RowException("Illegal row state, Row Object not initialized.");
        }
        if (meta.getColumnCount() != values.length) {
            throw new RowException("Column count does not match value array size.");
        }
        this.meta = meta.clone();
        this.meta.setHash();
        this.meta.setCapacity(1);
        this.data = values;
    }

    public Row(RowMetaData descriptor) {
        this.meta = descriptor.clone();
        this.meta.setHash();
        this.meta.setCapacity(1);
        this.data = new Object[descriptor.getColumnCount()];
    }

    Row(MetaDataProvider provider) {
        this.provider = provider;
        this.data = new Object[this.getMeta().getColumnCount()];
    }

    public Row(ResultSet result) throws SecurityViolationException, SQLException, MetaDataException, RowException {
        this.meta = new RowMetaData(result);
        this.meta.setHash();
        this.data = new Object[result.getMetaData().getColumnCount()];
        for (int i = 0; i < this.data.length; ++i) {
            Object value = result.getObject(i + 1);
            if (value == null) continue;
            this.setColumn(i + 1, value);
        }
    }

    @Override
    public RowMetaData getMeta() {
        if (this.provider == null) {
            return this.meta;
        }
        return this.provider.getMeta();
    }

    @Override
    public RowMetaData getMetaData() {
        return this.getMeta().clone();
    }

    @Override
    public void setRawData(Object[] data) throws RowException {
        if (data == null) {
            throw new RowException("Invalid data provided. Should be not null.");
        }
        if (data.length != this.getMeta().getColumnCount()) {
            throw new RowException("Columns count mismatch. Expected " + this.getMeta().getColumnCount() + ", but provided " + data.length + ".");
        }
        this.data = data;
    }

    public void setRawColumn(int index, Object value) throws RowException {
        if (index > this.data.length || index <= 0) {
            throw new RowException("Column index " + index + " is out of range.");
        }
        this.data[index - 1] = value;
    }

    @Override
    public Object[] getRawData() {
        return this.data;
    }

    @Override
    public void setColumn(int index, Object value) throws RowException {
        if (index > this.data.length || index <= 0) {
            throw new RowException("Column index " + index + " is out of range.");
        }
        this.doSetColumn(index, value);
    }

    @Override
    public void setColumn(String columnName, Object value) throws RowException {
        int index = this.findColumn(columnName);
        if (index == -1) {
            throw new RowException("Undefined column '" + columnName + "'.");
        }
        this.doSetColumn(index, value);
    }

    protected void doSetColumn(int index, Object value) throws RowException {
        if (value == null) {
            if (!this.getMeta().getColumnDescriptor(index).isNullable()) {
                throw new RowException("Column " + index + " does not allow NULL values.");
            }
            this.data[index - 1] = null;
            return;
        }
        this.data[index - 1] = this.convertValue(index, value);
    }

    private Object convertValue(int index, Object value) throws RowException {
        try {
            ColumnDescriptor columnDescriptor = this.getMeta().getColumnDescriptor(index);
            Class<?> columnTypeClass = columnDescriptor.getTypeClass();
            SQLType columnType = columnDescriptor.getType();
            try {
                if (columnTypeClass.equals(value.getClass())) {
                    return value;
                }
                if ((columnType == SQLType.TINYINT || columnType == SQLType.SMALLINT || columnType == SQLType.INTEGER) && ((Number)value).longValue() <= Integer.MAX_VALUE) {
                    return ((Number)value).intValue();
                }
                if (columnType == SQLType.BIGINT && new BigInteger(value.toString(), 10).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) {
                    return ((Number)value).longValue();
                }
                if ((columnType == SQLType.REAL || columnType == SQLType.FLOAT) && ((Number)value).doubleValue() <= 3.4028234663852886E38) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                if (columnType == SQLType.SQLTIMESTAMP) {
                    if (value instanceof TimestampData) {
                        return value;
                    }
                    return Timestamp.valueOf(value.toString());
                }
                if (columnType == SQLType.SQLDATE) {
                    if (value instanceof TimestampData) {
                        return value;
                    }
                    return Date.valueOf(value.toString());
                }
                if (columnType == SQLType.SQLTIME) {
                    if (value instanceof TimeData) {
                        return value;
                    }
                    return Time.valueOf(value.toString());
                }
                if (columnTypeClass.isAssignableFrom(value.getClass())) {
                    return value;
                }
                if (columnTypeClass.equals(BigDecimal.class) && value instanceof Number) {
                    if (value instanceof Double) {
                        return BigDecimal.valueOf(((Number)value).doubleValue());
                    }
                    if (value instanceof Float) {
                        return BigDecimal.valueOf(((Number)value).floatValue());
                    }
                    return BigDecimal.valueOf(((Number)value).longValue());
                }
                if (columnTypeClass.equals(String.class) && value.getClass().isEnum()) {
                    return ((Enum)value).name();
                }
                if (columnTypeClass.equals(String.class) && value.getClass().equals(char[].class)) {
                    return new String((char[])value);
                }
                if (columnTypeClass.equals(String.class)) {
                    if (value.getClass().equals(RowSetClobClientImpl.class)) {
                        return value;
                    }
                    if (Clob.class.isAssignableFrom(value.getClass())) {
                        return ((Clob)value).getSubString(1L, (int)((Clob)value).length());
                    }
                }
                if (columnTypeClass.equals(byte[].class) && value.getClass().equals(BinaryData.class)) {
                    return ((BinaryData)value).getBytes(null, 0L, (int)((BinaryData)value).length(null));
                }
                if (columnTypeClass.equals(byte[].class)) {
                    if (value.getClass().equals(RowSetBlobClientImpl.class)) {
                        return value;
                    }
                    if (Blob.class.isAssignableFrom(value.getClass())) {
                        return ((Blob)value).getBytes(1L, (int)((Blob)value).length());
                    }
                }
                if (columnType == SQLType.FLOB && value instanceof String) {
                    return value;
                }
                if (columnTypeClass.equals(Object[].class) && Array.class.isAssignableFrom(value.getClass())) {
                    return ((Array)value).getArray();
                }
                if (columnType == SQLType.BIT && value.getClass().equals(Boolean.class)) {
                    return value;
                }
                if (columnTypeClass.equals(String.class)) {
                    return value != null ? value.toString() : value;
                }
                if ((columnTypeClass == Facets.class || columnTypeClass == Aspects.class) && value instanceof String) {
                    return value;
                }
                throw new RowException("Incompatible data type '" + value.getClass().getName() + "', expected '" + columnTypeClass.getName() + "', value : " + String.valueOf(value));
            }
            catch (IllegalArgumentException exception) {
                throw new RowException("Cannot convert value of class " + value.getClass().getName() + " '" + value.toString() + "' to '" + columnTypeClass.getName() + "'.");
            }
        }
        catch (SQLException error) {
            throw new RowException(error);
        }
    }

    @Override
    public Object getColumn(int index) throws RowException {
        if (index > this.data.length || index <= 0) {
            throw new RowException("Column index " + index + " is out of range.");
        }
        return this.data[index - 1];
    }

    @Override
    public Object getColumn(String name) throws RowException {
        int index = this.findColumn(name);
        if (index == -1) {
            throw new RowException("Undefined column '" + name + "'.");
        }
        return this.data[index - 1];
    }

    @Override
    public int findColumn(String columnName) throws RowException {
        int index = 0;
        for (String column : this.getMeta().getColumnNames()) {
            ++index;
            if (!column.equals(columnName)) continue;
            return index;
        }
        return -1;
    }

    public Class<?> getColumnClass(String columnName) throws RowException {
        try {
            return this.getMeta().getColumnTypeClass(columnName);
        }
        catch (MetaDataException error) {
            throw new RowException(error.getMessage());
        }
    }

    @Override
    public Class<?> getColumnClass(int index) throws RowException {
        try {
            return this.getMeta().getColumnTypeClass(index);
        }
        catch (MetaDataException error) {
            throw new RowException(error.getMessage());
        }
    }

    public int getColumnSQLType(String columnName) throws RowException {
        try {
            return this.getMeta().getColumnSQLType(columnName);
        }
        catch (MetaDataException error) {
            throw new RowException(error.getMessage());
        }
    }

    @Override
    public void clear() {
        if (this.data != null) {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = null;
            }
        }
    }

    @Override
    public boolean isColumnNull(int index) throws RowException {
        if (this.data == null) {
            throw new RowException("Illegal row state, Row Object not initialized.");
        }
        if (index <= 0 && index > this.data.length) {
            throw new RowException("Column index " + index + " is out of range.");
        }
        return this.data[index - 1] == null;
    }

    @Override
    public boolean isColumnNull(String columnName) throws RowException {
        int colIndex = this.findColumn(columnName);
        return this.isColumnNull(colIndex);
    }

    @Override
    public int getColumnCount() throws RowException {
        return this.getMeta().getColumnCount();
    }

    @Override
    public int getColumnSQLType(int index) throws RowException {
        try {
            return this.getMeta().getColumnSQLType(index);
        }
        catch (MetaDataException error) {
            throw new RowException(error.getMessage());
        }
    }

    @Override
    public boolean hasRowId() throws RowException {
        return this.hasRID;
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.data != null) {
            return new ArrayIterator<Object>(this.data);
        }
        return null;
    }

    @Override
    public void setColumnNull(int index) throws RowException {
        if (index > 0 && index <= this.data.length) {
            if (this.getMeta().getColumnDescriptor(index).isNullable()) {
                this.data[index - 1] = null;
            }
        } else {
            throw new RowException("Column index " + index + " is out of range.");
        }
    }

    protected void enableRID() {
        this.hasRID = true;
    }

    protected void setRowId(int rid) {
        this.data[0] = rid;
    }

    @Override
    public Row clone() {
        Row result = (Row)super.clone();
        if (this.data != null) {
            result.data = new Object[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                try {
                    result.data[i] = SDOUtils.clone(this.data[i]);
                    continue;
                }
                catch (SDOException error) {
                    Trace.logError(this, "Row element clone failed. " + error.getMessage());
                }
            }
        }
        if (this.meta != null) {
            result.meta = this.meta.clone();
        }
        return result;
    }
}

