/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.lib.utils.SQLType;

public class ColumnDescriptor {
    private String name = null;
    private SQLType type = null;
    private boolean nullable = true;
    private String typeName = null;
    private int precision = 128;
    private int scale = 0;

    public ColumnDescriptor() {
        this.type = SQLType.VARCHAR;
    }

    public ColumnDescriptor(String name, Class<?> clazz, boolean nullable) {
        this(name, SQLType.typeForClass(clazz), nullable);
    }

    public ColumnDescriptor(String name, SQLType type, boolean nullable) {
        this(name, type, nullable, 128, 0);
    }

    public ColumnDescriptor(String name, Class<?> clazz, boolean nullable, int precision, int scale) {
        this(name, SQLType.typeForClass(clazz), nullable, precision, scale);
    }

    public ColumnDescriptor(String name, SQLType type, boolean nullable, int precision, int scale) {
        this.name = name;
        this.type = type;
        this.nullable = nullable;
        this.precision = precision;
        this.scale = scale;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public int getSQLType() {
        if (this.type != null) {
            return this.type.getType();
        }
        return 1111;
    }

    public SQLType getType() {
        return this.type;
    }

    public Class<?> getTypeClass() {
        return this.type.getTypeClass();
    }

    public String toString() {
        return this.name;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public ColumnDescriptor setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }
}

