/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.ds.lib.KMPSearchAlgorithm;
import com.streamscape.ds.lib.java.JavaSystem;
import com.streamscape.sdo.CloneableDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobImpl
extends CloneableDataObject
implements Clob {
    String data = null;

    ClobImpl(String data) throws SQLException {
        if (data == null) {
            throw new SQLException("Argument data is null");
        }
        this.data = data;
    }

    @Override
    public long length() throws SQLException {
        return this.data.length();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 1L || pos > (long)this.data.length()) {
            throw new SQLException("Argument pos is out of range.");
        }
        if (length < 0 || (long)length > (long)this.data.length() - --pos) {
            throw new SQLException("Argument length is out of range.");
        }
        return pos == 0L && length == this.data.length() ? this.data : this.data.substring((int)pos, (int)pos + length);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.data);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        try {
            return new ByteArrayInputStream(this.data.getBytes("US-ASCII"));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        if (start < 1L) {
            throw new SQLException("Argument start is out of range.");
        }
        if (searchstr == null || start > Integer.MAX_VALUE) {
            return -1L;
        }
        int position = KMPSearchAlgorithm.search(this.data, searchstr, null, (int)start);
        return position == -1 ? -1L : (long)(position + 1);
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        if (start < 1L) {
            throw new SQLException("Argument start is out of range.");
        }
        if (searchstr == null) {
            return -1L;
        }
        if (--start > (long)this.data.length() - searchstr.length()) {
            return -1L;
        }
        String pattern = searchstr instanceof ClobImpl ? ((ClobImpl)searchstr).data() : searchstr.getSubString(1L, (int)searchstr.length());
        int position = KMPSearchAlgorithm.search(this.data, pattern, null, (int)start);
        return position == -1 ? -1L : (long)(position + 1);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        StringBuffer sb;
        if (str == null) {
            throw new SQLException("Argument str is null.");
        }
        if (offset < 0 || offset > str.length()) {
            throw new SQLException("Argument offset is out of range.");
        }
        if (len > str.length() - offset) {
            throw new SQLException("Argument len is out of range.");
        }
        if (pos < 1L || pos > 1L + (long)(Integer.MAX_VALUE - len)) {
            throw new SQLException("Argument pos is out of range.");
        }
        int ipos = (int)(pos - 1L);
        if (ipos > this.data.length() - len) {
            sb = new StringBuffer(ipos + len);
            sb.append(this.data.substring(0, ipos));
            this.data = null;
            sb.append(str.substring(offset, offset + len));
            str = null;
        } else {
            sb = new StringBuffer(this.data);
            this.data = null;
            int i = ipos;
            for (int j = 0; j < len; ++j) {
                sb.setCharAt(i, str.charAt(offset + j));
                ++i;
            }
            str = null;
        }
        this.data = sb.toString();
        return len;
    }

    @Override
    public OutputStream setAsciiStream(final long pos) throws SQLException {
        if (pos < 1L || pos > Integer.MAX_VALUE) {
            throw new SQLException("Argument pos is out of range.");
        }
        return new ByteArrayOutputStream(){

            @Override
            public synchronized void close() throws IOException {
                try {
                    ClobImpl.this.setString(pos, new String(this.toByteArray(), "US-ASCII"));
                }
                catch (SQLException se) {
                    throw JavaSystem.toIOException(se);
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public Writer setCharacterStream(final long pos) throws SQLException {
        if (pos < 1L || pos > Integer.MAX_VALUE) {
            throw new SQLException("Argument pos is out of range.");
        }
        return new StringWriter(){

            @Override
            public synchronized void close() throws IOException {
                try {
                    ClobImpl.this.setString(pos, this.toString());
                }
                catch (SQLException se) {
                    throw JavaSystem.toIOException(se);
                }
            }
        };
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (len < 0L || len > (long)this.data.length()) {
            throw new SQLException("Argument len is out of range.");
        }
        this.data = this.data.substring(0, (int)len);
    }

    @Override
    public void free() throws SQLException {
        this.data = null;
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Argument length is out of range.");
        }
        return new StringReader(this.getSubString(pos, (int)length));
    }

    public String toString() {
        return this.data;
    }

    private String data() {
        return this.data;
    }
}

