/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo.rowset;

import com.streamscape.ds.lib.KMPSearchAlgorithm;
import com.streamscape.ds.lib.StringConverter;
import com.streamscape.ds.lib.java.JavaSystem;
import com.streamscape.sdo.CloneableDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobImpl
extends CloneableDataObject
implements Blob {
    byte[] data = null;

    public BlobImpl(byte[] data) throws SQLException {
        if (data == null) {
            throw new SQLException("data is null");
        }
        this.data = data;
    }

    @Override
    public long length() throws SQLException {
        return this.data.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L || pos > (long)(this.data.length + 1)) {
            throw new SQLException("Argument pos is out of range");
        }
        if (length < 0 || (long)length > (long)this.data.length - --pos) {
            throw new SQLException("Argument length is out of range");
        }
        byte[] result = new byte[length];
        System.arraycopy(this.data, (int)pos, result, 0, length);
        return result;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (start < 1L) {
            throw new SQLException("Argument pos is out of range");
        }
        if (start > (long)this.data.length || pattern == null) {
            return -1L;
        }
        int startIndex = (int)start - 1;
        if (pattern.length == 0 || startIndex > this.data.length - pattern.length) {
            return -1L;
        }
        int result = KMPSearchAlgorithm.search(this.data, pattern, KMPSearchAlgorithm.computeTable(pattern), startIndex);
        return result == -1 ? -1L : (long)(result + 1);
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        if (start < 1L) {
            throw new SQLException("Argument po is out of range");
        }
        if (start > (long)this.data.length || pattern == null) {
            return -1L;
        }
        int startIndex = (int)start - 1;
        if (pattern.length() == 0L || (long)startIndex > (long)this.data.length - pattern.length()) {
            return -1L;
        }
        byte[] bytePattern = null;
        bytePattern = pattern instanceof BlobImpl ? ((BlobImpl)pattern).data() : pattern.getBytes(1L, (int)pattern.length());
        int result = KMPSearchAlgorithm.search(this.data, bytePattern, KMPSearchAlgorithm.computeTable(bytePattern), startIndex);
        return result == -1 ? -1L : (long)(result + 1);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (bytes == null) {
            throw new SQLException("Argument bytes is null");
        }
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (bytes == null) {
            throw new SQLException("Argument bytes is null");
        }
        if (offset < 0 || offset > bytes.length) {
            throw new SQLException("Argument offset is out of range.");
        }
        if (len > bytes.length - offset) {
            throw new SQLException("Argument len is out of range.");
        }
        if (pos < 1L || pos > 1L + (long)(Integer.MAX_VALUE - len)) {
            throw new SQLException("Argument pos is out of range.");
        }
        if (--pos + (long)len > (long)this.data.length) {
            byte[] temp = new byte[(int)pos + len];
            System.arraycopy(this.data, 0, temp, 0, this.data.length);
            this.data = temp;
            temp = null;
        }
        System.arraycopy(bytes, offset, this.data, (int)pos, len);
        return len;
    }

    @Override
    public OutputStream setBinaryStream(final long pos) throws SQLException {
        if (pos < 1L || pos > Integer.MIN_VALUE) {
            throw new SQLException("Argument pos is out of range.");
        }
        return new ByteArrayOutputStream(){

            @Override
            public synchronized void close() throws IOException {
                try {
                    BlobImpl.this.setBytes(pos, this.toByteArray());
                }
                catch (SQLException se) {
                    throw JavaSystem.toIOException(se);
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (len < 0L || len > (long)this.data.length) {
            throw new SQLException("Argument len is out of range.");
        }
        if (len == (long)this.data.length) {
            return;
        }
        byte[] newData = new byte[(int)len];
        System.arraycopy(this.data, 0, newData, 0, (int)len);
        this.data = newData;
    }

    @Override
    public void free() throws SQLException {
        this.data = null;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (pos < 1L || pos > (long)this.data.length) {
            throw new SQLException("Argument pos is out of range.");
        }
        if (length < 0L || length > (long)this.data.length - --pos) {
            throw new SQLException("Argument length is out of range.");
        }
        if (pos == 0L && length == (long)this.data.length) {
            return new ByteArrayInputStream(this.data);
        }
        byte[] result = new byte[(int)length];
        System.arraycopy(this.data, (int)pos, result, 0, (int)length);
        return new ByteArrayInputStream(result);
    }

    public String toString() {
        return StringConverter.byteArrayToHexString(this.data);
    }

    protected byte[] data() {
        return this.data;
    }
}

